/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.palette;

import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.struts.StrutsPlugin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.osgi.framework.Bundle;

public class StrutsActionTaglibURIRegistryReader {
    private static WeakReference elementsReference;

    public static Element[] getElements() {
        Element[] elements;
        if (elementsReference != null && (elements = (Element[])elementsReference.get()) != null) {
            return elements;
        }
        elements = StrutsActionTaglibURIRegistryReader.createElements();
        elementsReference = new WeakReference<Element[]>(elements);
        return elements;
    }

    private static Element[] createElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(StrutsPlugin.getPluginId(), "tagliburi");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            Arrays.sort(extensions, new PluginIdComparator());
            ArrayList elementList = new ArrayList(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals("element")) {
                        StrutsActionTaglibURIRegistryReader.readElement(element, elementList);
                    }
                    ++j;
                }
                ++i;
            }
            if (!elementList.isEmpty()) {
                return elementList.toArray(new Element[elementList.size()]);
            }
        }
        return new Element[0];
    }

    private static void readElement(IConfigurationElement parent, List elementList) {
        HashSet facetVersions = new HashSet();
        HashMap uris = new HashMap();
        IConfigurationElement[] elements = parent.getChildren();
        int j = 0;
        while (j < elements.length) {
            IConfigurationElement element = elements[j];
            if (element.getName().equals("facet")) {
                StrutsActionTaglibURIRegistryReader.readFacet(element, facetVersions);
            } else if (element.getName().equals("taglib")) {
                StrutsActionTaglibURIRegistryReader.readTaglib(element, uris);
            }
            ++j;
        }
        if (!facetVersions.isEmpty() && !uris.isEmpty()) {
            elementList.add(new Element(facetVersions, uris));
        }
    }

    private static void readFacet(IConfigurationElement element, Set facetVersions) {
        IProjectFacet facet;
        String version;
        String id = element.getAttribute("facetId");
        if (id != null && (version = element.getAttribute("version")) != null && (facet = ProjectFacetUtil.getProjectFacet((String)id)) != null) {
            Set versions = ProjectFacetUtil.getFacetVersions((IProjectFacet)facet, (String)version);
            facetVersions.addAll(versions);
        }
    }

    private static void readTaglib(IConfigurationElement element, Map uris) {
        String uri;
        String prefix = element.getAttribute("prefix");
        if (prefix != null && (uri = element.getAttribute("uri")) != null) {
            uris.put(prefix, uri);
        }
    }

    public static class Element {
        public final Set facetVersions;
        public final Map uris;

        public Element(Set facetVersions, Map uris) {
            this.facetVersions = facetVersions;
            this.uris = uris;
        }
    }

    private static class PluginIdComparator
    implements Comparator {
        private PluginIdComparator() {
        }

        public int compare(Object extension1, Object extension2) {
            Bundle bundle1 = Platform.getBundle((String)((IExtension)extension1).getContributor().getName());
            Bundle bundle2 = Platform.getBundle((String)((IExtension)extension2).getContributor().getName());
            if (bundle1 == null) {
                return bundle2 == null ? 0 : -1;
            }
            if (bundle2 == null) {
                return 1;
            }
            return bundle1.getSymbolicName().compareTo(bundle2.getSymbolicName());
        }
    }
}

