/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.logictags;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.jspeditor.vct.IterateStructure;
import com.ibm.etools.struts.jspeditor.vct.StrutsVisualizer;
import com.ibm.etools.struts.jspeditor.vct.StrutsVisualizerUtil;
import com.ibm.etools.struts.jspeditor.vct.nestedtags.StrutsNestedIterateTagVisualizer;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.preference.StrutsPreferences;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StrutsLogicIterateTagVisualizer
extends StrutsVisualizer {
    public Text text;
    public int iterateCount = -1;
    private Context currentContext;
    private Node currentNode;
    private boolean firstTime = true;

    public StrutsLogicIterateTagVisualizer() {
        StrutsPreferences preferences = StrutsVisualizerUtil.getPreferences();
        this.iterateCount = preferences.getIterateCount();
    }

    public boolean isReadOnlyVisual() {
        return false;
    }

    public VisualizerReturnCode doStart(Context context) {
        Node self;
        this.currentContext = context;
        this.currentNode = self = context.getSelf();
        if (this.firstTime) {
            this.setDefaultIterateCount(context, self);
        }
        this.firstTime = false;
        IterateStructure structure = (IterateStructure)StrutsVisualizerUtil.getPageScopeVariable(context, "ITERATE");
        if (structure == null) {
            structure = new IterateStructure();
            StrutsVisualizerUtil.storePageScopeVariable(context, "ITERATE", structure);
        }
        Node idNode = null;
        Node nameNode = null;
        Node propertyNode = null;
        Vector<String> dataVector = new Vector<String>();
        if (self.hasAttributes()) {
            NamedNodeMap nnm = self.getAttributes();
            idNode = nnm.getNamedItem("id");
            nameNode = nnm.getNamedItem("name");
            propertyNode = nnm.getNamedItem("property");
        }
        if (idNode == null || nameNode == null && !(this instanceof StrutsNestedIterateTagVisualizer)) {
            StrutsVisualizerUtil.displayErrorMessage(context, ResourceHandler.StrutsVCT_iteratetag_error_missing_id_or_name, this);
            return VisualizerReturnCode.OK;
        }
        String name = "";
        if (nameNode != null) {
            name = nameNode.getNodeValue();
        }
        NodeList body = self.getChildNodes();
        Vector<Node> iteratorList = new Vector<Node>();
        String key = String.valueOf(idNode.getNodeValue()) + "." + name;
        if (propertyNode != null) {
            key = String.valueOf(key) + "." + propertyNode.getNodeValue();
        }
        String dataString = null;
        if (structure != null) {
            dataString = structure.getDataStringForChild((Object)this, context);
        }
        if (dataString == null) {
            dataString = name;
        }
        dataString = String.valueOf(dataString) + "." + idNode.getNodeValue();
        int i = 0;
        while (i < this.iterateCount) {
            int j = 0;
            while (j < body.getLength()) {
                Node currentNode = body.item(j);
                if (i == 0) {
                    this.storeDependentNodesRecursively(structure, currentNode, key);
                    iteratorList.add(currentNode);
                } else {
                    Node newNode = currentNode.cloneNode(true);
                    iteratorList.add(newNode);
                }
                ++j;
            }
            String currentString = String.valueOf(dataString) + "[" + Integer.toString(i) + "]";
            dataVector.add(currentString);
            ++i;
        }
        if (!dataVector.isEmpty()) {
            structure.putLastData(key, dataVector);
        }
        if (iteratorList.size() > 0) {
            context.putVisual(iteratorList);
        } else {
            context.putVisual((Node)StrutsVisualizerUtil.createHiddenTagIcon(context, "logic/iterate_pal"));
        }
        return VisualizerReturnCode.OK;
    }

    private void storeDependentNodesRecursively(IterateStructure structure, Node node, String key) {
        if (node.getNodeName().equals("bean:write") || node.getNodeName().equals("nested:write") || node.getNodeName().equals("logic:iterate") || node.getNodeName().equals("nested:iterate") || node.getNodeName().equals("nested:writeNesting")) {
            structure.putLastChild(key, node, new Integer(0));
        } else {
            NodeList body = node.getChildNodes();
            int i = 0;
            while (i < body.getLength()) {
                this.storeDependentNodesRecursively(structure, body.item(i), key);
                ++i;
            }
        }
    }

    public NodeList getNodeList(Document doc) {
        NodeList nl = doc.getElementsByTagName("table");
        return nl;
    }

    public void setAttribute(String value) {
        try {
            if (this.currentNode == null) {
                return;
            }
            if (Integer.parseInt(value) >= 0) {
                this.iterateCount = Integer.parseInt(value);
                this.savePreference(this.currentContext, this.currentNode);
                this.currentContext.refresh();
                this.findIterateParent();
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setDefaultIterateCount(Context context, Node currentNode) {
        try {
            String pathString = context.getMyPath();
            String count = StrutsVisualizerUtil.getResourcePreference(pathString, currentNode);
            if (count != null) {
                try {
                    this.iterateCount = Integer.parseInt(count);
                }
                catch (NumberFormatException numberFormatException) {
                    StrutsPreferences preferences = StrutsVisualizerUtil.getPreferences();
                    this.iterateCount = preferences.getIterateCount();
                }
            } else {
                StrutsPreferences preferences = StrutsVisualizerUtil.getPreferences();
                this.iterateCount = preferences.getIterateCount();
            }
            StrutsPlugin.getLogger().trace("StrutsPlugin", "property is: " + this.iterateCount);
        }
        catch (CoreException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    public void savePreference(Context context, Node currentNode) {
        try {
            String pathString = context.getMyPath();
            String preferenceString = Integer.toString(this.iterateCount);
            StrutsVisualizerUtil.setResourcePreference(pathString, currentNode, preferenceString);
        }
        catch (CoreException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    public void findIterateParent() {
        StrutsLogicIterateTagVisualizer slitv = (StrutsLogicIterateTagVisualizer)((Object)this.currentContext.getAncestorVisualizer(StrutsLogicIterateTagVisualizer.class));
        if (slitv != null) {
            slitv.refresh();
        }
    }

    public void refresh() {
        this.currentContext.refresh();
    }
}

