/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.htmltags;

import com.ibm.etools.struts.ContextIds;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.jspeditor.attrview.parts.StrutsTextPart;
import com.ibm.etools.struts.jspeditor.vct.ErrorOpenResourceBundleException;
import com.ibm.etools.struts.jspeditor.vct.StrutsVisualizerUtil;
import com.ibm.etools.struts.jspeditor.vct.htmltags.AddErrorsKeysDialog;
import com.ibm.etools.struts.jspeditor.vct.htmltags.StrutsHtmlTagVisualizer;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StrutsHtmlMessagesTagVisualizer
extends StrutsHtmlTagVisualizer
implements ContextIds {
    private Context myContext;
    private Node myNode;
    private static String MessagesDisplayOptionKey = "messages.display.option";
    private static String MessagesKeysKey = "messages.keys";

    public VisualizerReturnCode doStart(Context context) {
        this.myContext = context;
        this.myNode = context.getSelf();
        if (this.getMessagesDisplayOption()) {
            ArrayList messagesMsgs = null;
            String messagesKeysString = this.getMessagesKeysString();
            if (messagesKeysString != null && messagesKeysString.length() > 0) {
                try {
                    messagesMsgs = StrutsVisualizerUtil.getStringsFromKeys(context, StrutsVisualizerUtil.getCollectionOfLines(messagesKeysString), this);
                }
                catch (ErrorOpenResourceBundleException e) {
                    StrutsVisualizerUtil.displayErrorMessageString(context, e.getMessage(), this);
                    return VisualizerReturnCode.OK;
                }
            } else {
                messagesMsgs = StrutsVisualizerUtil.getActionMessages();
            }
            String messagesMsgText = this.getMessagesMsgsText(context, messagesMsgs);
            if (messagesMsgText != null) {
                context.putVisual(messagesMsgText);
            }
        } else {
            context.putVisual(null);
        }
        return VisualizerReturnCode.OK;
    }

    public boolean isReadOnlyVisual() {
        return true;
    }

    private String getMessagesMsgsText(Context context, ArrayList messagesMsgs) {
        StringBuffer messagesTextBuffer = new StringBuffer();
        Node self = context.getSelf();
        if (self.hasAttributes()) {
            NamedNodeMap attributes = self.getAttributes();
            Node header = attributes.getNamedItem("header");
            if (header != null) {
                messagesTextBuffer.append(header.getNodeValue());
            }
            Iterator iterator = messagesMsgs.iterator();
            while (iterator.hasNext()) {
                messagesTextBuffer.append("\r\n");
                messagesTextBuffer.append((String)iterator.next());
            }
            Node footer = attributes.getNamedItem("footer");
            if (footer != null) {
                messagesTextBuffer.append("\r\n");
                messagesTextBuffer.append(footer.getNodeValue());
            }
        }
        return messagesTextBuffer.toString();
    }

    public boolean useCustomAttributeView() {
        return true;
    }

    public boolean getMessagesDisplayOption() {
        String preferenceString = null;
        if (this.myContext != null) {
            try {
                preferenceString = StrutsVisualizerUtil.getResourcePreference(this.myContext.getMyPath(), this.myNode, MessagesDisplayOptionKey);
            }
            catch (CoreException e) {
                StrutsPlugin.getLogger().log((Throwable)e);
            }
        }
        boolean value = preferenceString == null ? StrutsVisualizerUtil.getMessagesDisplay() : new Boolean(preferenceString);
        return value;
    }

    public void setMessagesDisplayOption(boolean selection) {
        if (this.myContext != null) {
            this.savePreference(MessagesDisplayOptionKey, new Boolean(selection).toString());
            this.myContext.refresh();
        }
    }

    public String getMessagesKeysString() {
        String preferenceString = null;
        if (this.myContext != null) {
            try {
                preferenceString = StrutsVisualizerUtil.getResourcePreference(this.myContext.getMyPath(), this.myNode, MessagesKeysKey);
            }
            catch (CoreException e) {
                StrutsPlugin.getLogger().log((Throwable)e);
            }
        }
        return preferenceString;
    }

    public ArrayList getMessagesStrings() {
        String keysStr = this.getMessagesKeysString();
        if (keysStr != null && keysStr.length() > 0) {
            return StrutsVisualizerUtil.getCollectionOfLines(keysStr);
        }
        return null;
    }

    public void setMessagesKeysString(String keysString) {
        if (this.myContext != null) {
            this.savePreference(MessagesKeysKey, keysString);
            this.myContext.refresh();
        }
    }

    public void savePreference(String key, String value) {
        try {
            String pathString = this.myContext.getMyPath();
            StrutsVisualizerUtil.setResourcePreference(pathString, this.myNode, key, value);
        }
        catch (CoreException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    public void addPushButtonSelected(Composite composite, StrutsTextPart textPart) {
        if (this.myContext == null) {
            return;
        }
        AddErrorsKeysDialog dialog = new AddErrorsKeysDialog(composite.getShell(), this.myContext, this);
        dialog.open();
        String[] selectedKeys = dialog.getSelectedKeys();
        if (selectedKeys == null || dialog.getReturnCode() == 1) {
            return;
        }
        String temp = textPart.getValue();
        if (temp == null) {
            temp = "";
        }
        int i = 0;
        while (i < selectedKeys.length) {
            temp = temp.concat("\r\n" + selectedKeys[i]);
            textPart.setValue(temp);
            temp = textPart.getValue();
            ++i;
        }
    }
}

