/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.dialog;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.web.javaee.taglib.WebEEUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.jspeditor.vct.dialog.ActionContentProvider;
import com.ibm.etools.struts.jspeditor.vct.dialog.ActionDialogElement;
import com.ibm.etools.struts.jspeditor.vct.dialog.ActionLabelProvider;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.treeviewer.AddActionMappingAction;
import com.ibm.etools.struts.treeviewer.OpenNewModuleWizardAction;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SelectActionDialog
extends SelectionDialog {
    private ActionDialogElement actionMappingResult;
    private Label actionPathDescription;
    private Group actionPathGroup;
    private Label actionPathLabel;
    private Label actionPathPreview;
    private Text actionPathText;
    private String DEFAULT_DESCRIPTION = NLS.bind((String)ResourceHandler.action_selection_dialog_wildcard_path_description, (Object)(String.valueOf(ResourceHandler.action_selection_dialog_wildcard_path_example) + "*"));
    private String DEFAULT_EXAMPLE = NLS.bind((String)ResourceHandler.action_selection_dialog_wildcard_path_example_label, (Object)ResourceHandler.action_selection_dialog_wildcard_path_example);
    private int DIALOG_HEIGHT = 400;
    private int DIALOG_WIDTH = 400;
    private String ignoreModule;
    private String lastSelectedModule = null;
    private IProject project;
    private String showOnlyModule;
    private TreeViewer treeViewer;

    public SelectActionDialog(Shell shell, IProject project) {
        super(shell);
        this.project = project;
        this.setTitle(ResourceHandler.ui_proppage_dlg_select_action_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getOkButton().setEnabled(false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite child = new Composite(parent, 0);
        child.setFont(parent.getFont());
        GridLayout gl = new GridLayout();
        gl.marginWidth = 8;
        gl.marginHeight = 8;
        child.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = this.DIALOG_HEIGHT;
        child.setLayoutData((Object)gd);
        Label label = new Label(child, 16384);
        label.setText(ResourceHandler.ui_proppage_dlg_select_action_label);
        Composite mainContent = new Composite(child, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        mainContent.setLayout((Layout)gl);
        mainContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeConrols(mainContent);
        this.createWildcardPathEntryControls(child);
        this.createSideButtonControls(mainContent);
        return child;
    }

    private void createSideButtonControls(Composite parent) {
        Composite actionSelectionbuttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionSelectionbuttonBar.setLayout((Layout)layout);
        actionSelectionbuttonBar.setLayoutData((Object)new GridData(2));
        Button newAction = new Button(actionSelectionbuttonBar, 0);
        newAction.setText(ResourceHandler.NewAction);
        newAction.setLayoutData((Object)new GridData(1, 1, false, false));
        newAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionDialog.this.handleNewActionButtonSelected();
            }
        });
        newAction.setLayoutData((Object)new GridData(768));
        if (this.getShowOnlyModule() == null) {
            Button newModule = new Button(actionSelectionbuttonBar, 0);
            newModule.setText(ResourceHandler.NewModule);
            newModule.setLayoutData((Object)new GridData(1, 1, false, false));
            newModule.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectActionDialog.this.handleNewModuleButtonSelected();
                }
            });
            newModule.setLayoutData((Object)new GridData(768));
        }
    }

    private void createTreeConrols(Composite parent) {
        Composite viewerCol = new Composite(parent, 0);
        viewerCol.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout viewerLayout = new GridLayout();
        viewerLayout.marginHeight = 0;
        viewerLayout.marginWidth = 0;
        viewerCol.setLayout((Layout)viewerLayout);
        this.treeViewer = new TreeViewer(viewerCol, 2816);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ActionContentProvider(this.getIgnoreModule(), this.getShowOnlyModule()));
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectActionDialog.this.handleDoubleClick();
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectActionDialog.this.handleSelectionChanged(event);
            }
        });
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setInput((Object)this.project);
    }

    private void createWildcardPathEntryControls(Composite parent) {
        this.actionPathGroup = new Group(parent, 0);
        GridData data = new GridData(4, 2, true, false);
        this.actionPathGroup.setLayoutData((Object)data);
        GridLayout agl = new GridLayout();
        agl.numColumns = 2;
        this.actionPathGroup.setLayout((Layout)agl);
        this.actionPathGroup.setText(ResourceHandler.action_selection_dialog_wildcard_path_entry_group_title);
        this.actionPathDescription = new Label((Composite)this.actionPathGroup, 64);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.widthHint = this.DIALOG_WIDTH - 20;
        data.heightHint = 30;
        this.actionPathDescription.setText(this.DEFAULT_DESCRIPTION);
        this.actionPathDescription.setLayoutData((Object)data);
        this.actionPathPreview = new Label((Composite)this.actionPathGroup, 0);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.actionPathPreview.setText(this.DEFAULT_EXAMPLE);
        this.actionPathPreview.setLayoutData((Object)data);
        this.actionPathLabel = new Label((Composite)this.actionPathGroup, 0);
        this.actionPathLabel.setText(ResourceHandler.action_selection_dialog_wildcard_path_label);
        data = new GridData(1, 2, false, false);
        data.horizontalSpan = 1;
        this.actionPathLabel.setLayoutData((Object)data);
        this.actionPathText = new Text((Composite)this.actionPathGroup, 2048);
        data = new GridData(4, 2, true, false);
        data.horizontalSpan = 1;
        this.actionPathText.setLayoutData((Object)data);
        this.actionPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectActionDialog.this.getOkButton().setEnabled(SelectActionDialog.this.isOKEnabled());
            }
        });
    }

    public String getIgnoreModule() {
        return this.ignoreModule;
    }

    public String getShowOnlyModule() {
        return this.showOnlyModule;
    }

    private void handleDoubleClick() {
        if (this.isOKEnabled()) {
            this.okPressed();
        }
    }

    private void handleNewActionButtonSelected() {
        IVirtualComponent component = Model2Util.findComponent((IResource)this.project);
        AddActionMappingAction action = null;
        if (this.getShowOnlyModule() != null) {
            action = new AddActionMappingAction("", false, false);
            action.setModule(this.getShowOnlyModule());
        } else {
            action = new AddActionMappingAction("", true, false);
        }
        action.setShell(this.getShell());
        if (this.lastSelectedModule != null) {
            action.setUseAllConfigFiles(false);
            action.setModule(this.lastSelectedModule);
        }
        action.setComponent(component);
        action.run();
        final ActionMapping mapping = action.getResult();
        String fileName = action.getConfigFileName();
        if (mapping != null) {
            String module = this.getShowOnlyModule();
            if (module == null) {
                String string = module = this.lastSelectedModule != null ? this.lastSelectedModule : null;
                if (module == null) {
                    module = "";
                }
            }
            if (fileName != null) {
                IContainer container = WebEEUtil.getDocumentRootContainer((IResource)this.project);
                IPath strutsFilePath = container.getFullPath().append(fileName);
                final IFile strutsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(strutsFilePath);
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                            String module = StrutsSearchUtil.getModuleForIFile((IFile)strutsFile, (IProgressMonitor)sub.newChild(1));
                            ReferenceManager.getReferenceManager().requestAnalysis((IResource)strutsFile);
                            ILink actionLink = StrutsSearchUtil.getActionMappingLink((IProject)SelectActionDialog.this.project, (String)mapping.getPath(), (String)module, (IProgressMonitor)sub.newChild(1));
                            final StructuredSelection sel = new StructuredSelection((Object)new ActionDialogElement(actionLink));
                            if (SelectActionDialog.this.getShell() != null && !SelectActionDialog.this.getShell().isDisposed() && SelectActionDialog.this.getShell().getDisplay() != null && !SelectActionDialog.this.getShell().getDisplay().isDisposed()) {
                                SelectActionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!SelectActionDialog.this.treeViewer.getControl().isDisposed()) {
                                            SelectActionDialog.this.treeViewer.refresh();
                                            SelectActionDialog.this.treeViewer.setSelection((ISelection)sel, true);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleNewModuleButtonSelected() {
        OpenNewModuleWizardAction action = new OpenNewModuleWizardAction("", this.getShell());
        IVirtualComponent component = Model2Util.findComponent((IResource)this.project);
        action.setComponent(component);
        action.setShell(this.getShell());
        action.run();
        String module = action.getResult();
        if (module != null) {
            final StructuredSelection sel = new StructuredSelection((Object)module);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SelectActionDialog.this.treeViewer.refresh();
                    SelectActionDialog.this.treeViewer.setSelection((ISelection)sel, true);
                }
            });
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof ActionDialogElement) {
                this.actionMappingResult = (ActionDialogElement)object;
                this.lastSelectedModule = this.actionMappingResult.getModule();
            } else if (object instanceof String) {
                this.lastSelectedModule = (String)object;
                this.actionMappingResult = null;
            }
        }
        this.setResult(Collections.singletonList(this.actionMappingResult));
        Button okButton = this.getOkButton();
        this.setActionPathEntryEnabled(this.actionMappingResult != null && !this.actionMappingResult.isConcrete());
        okButton.setEnabled(this.isOKEnabled());
    }

    private boolean isOKEnabled() {
        boolean enabled = false;
        if (this.actionMappingResult != null) {
            if (this.actionMappingResult.isConcrete()) {
                enabled = true;
            } else {
                ActionMappingWildcardUtil util = this.actionMappingResult.getActionMappingWildcardUtil();
                enabled = util.actionPathMatchesPattern(this.actionPathText.getText());
            }
        }
        return enabled;
    }

    protected void okPressed() {
        if (this.actionMappingResult != null && !this.actionMappingResult.isConcrete()) {
            this.actionMappingResult.setPath(this.actionPathText.getText());
        }
        super.okPressed();
    }

    private void setActionPathEntryEnabled(boolean enabled) {
        this.actionPathGroup.setEnabled(enabled);
        this.actionPathDescription.setEnabled(enabled);
        this.actionPathPreview.setEnabled(enabled);
        this.actionPathLabel.setEnabled(enabled);
        this.actionPathText.setEnabled(enabled);
        if (enabled && this.actionMappingResult != null) {
            this.actionPathDescription.setText(NLS.bind((String)ResourceHandler.action_selection_dialog_wildcard_path_description, (Object)this.actionMappingResult.getPath()));
            this.actionPathPreview.setText(NLS.bind((String)ResourceHandler.action_selection_dialog_wildcard_path_example_label, (Object)this.actionMappingResult.getActionMappingWildcardUtil().getExampleRuntimePath()));
        } else {
            this.actionPathDescription.setText(this.DEFAULT_DESCRIPTION);
            this.actionPathPreview.setText(this.DEFAULT_EXAMPLE);
            this.actionPathText.setText("");
        }
    }

    public void setIgnoreModule(String ignoreModule) {
        this.ignoreModule = ignoreModule;
    }

    public void setShowOnlyModule(String showOnlyModule) {
        this.showOnlyModule = showOnlyModule;
    }

    protected void updateViewer() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectActionDialog.this.treeViewer.refresh();
            }
        });
    }
}

