/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.beantags;

import com.ibm.etools.struts.jspeditor.vct.ErrorOpenResourceBundleException;
import com.ibm.etools.struts.jspeditor.vct.StrutsVisualizer;
import com.ibm.etools.struts.jspeditor.vct.StrutsVisualizerUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrutsBeanMessageTagVisualizer
extends StrutsVisualizer {
    public boolean isReadOnlyVisual() {
        return true;
    }

    public VisualizerReturnCode doStart(Context context) {
        String message = StrutsBeanMessageTagVisualizer.getMessage(context, context.getSelf(), this, true);
        if (message != null) {
            context.putVisual(message);
        }
        return VisualizerReturnCode.OK;
    }

    public static String getMessage(Context context, Node node, StrutsBeanMessageTagVisualizer visualizer, boolean displayError) {
        Element element = (Element)node;
        String message = null;
        String key = element.getAttribute("key");
        if (key != null) {
            message = StrutsBeanMessageTagVisualizer.getKeyStringFromBundle(context, key, visualizer);
            if (message == null) {
                message = NLS.bind((String)ResourceHandler.StrutsVCT_messagetag_error_missing_message, (Object)key);
                StrutsBeanMessageTagVisualizer.displayErrorMsg(context, message, visualizer, displayError);
            }
        } else if (StrutsVisualizerUtil.getStrutsVersion(context) >= 1) {
            String name = visualizer.getBeanName(context, node);
            if (name != null) {
                String property = element.getAttribute("property");
                StringBuffer msgBuffer = new StringBuffer("message");
                msgBuffer.append(' ');
                msgBuffer.append(name);
                if (property != null) {
                    msgBuffer.append('.');
                    msgBuffer.append(property);
                }
                message = msgBuffer.toString();
            } else {
                message = NLS.bind((String)ResourceHandler.StrutsVCT_common_error_missing_attribute, (Object[])new String[]{"key", "name", ""});
                StrutsBeanMessageTagVisualizer.displayErrorMsg(context, message, visualizer, displayError);
            }
        } else {
            message = NLS.bind((String)ResourceHandler.StrutsVCT_common_error_missing_attribute, (Object[])new String[]{"key", "", ""});
            StrutsBeanMessageTagVisualizer.displayErrorMsg(context, message, visualizer, displayError);
        }
        return message;
    }

    public static String getMessage(Context context, Node node, StrutsBeanMessageTagVisualizer visualizer) {
        return StrutsBeanMessageTagVisualizer.getMessage(context, node, visualizer, false);
    }

    private static String getKeyStringFromBundle(Context context, String key, StrutsBeanMessageTagVisualizer visualizer) {
        if (key != null) {
            try {
                return StrutsVisualizerUtil.getString(context, key, visualizer);
            }
            catch (ErrorOpenResourceBundleException e) {
                StrutsVisualizerUtil.displayErrorMessage(context, e.getMessage(), visualizer);
            }
        }
        return null;
    }

    private static void displayErrorMsg(Context context, String errorMsg, StrutsBeanMessageTagVisualizer visualizer, boolean displayError) {
        if (displayError) {
            StrutsVisualizerUtil.displayErrorMessageString(context, errorMsg, visualizer);
        }
    }

    public String getBeanName(Context context, Node node) {
        return ((Element)node).getAttribute("name");
    }
}

