/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview.data;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.PropertyDataUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.AttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.IAttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.IIntegerData;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class IntegerData
extends AttributeData
implements IIntegerData {
    private int integer;

    public IntegerData(String attributeName) {
        super(attributeName);
    }

    @Override
    public boolean compare(IAttributeData data) {
        if (data instanceof IIntegerData) {
            return PropertyDataUtil.compare(this, (IIntegerData)data);
        }
        return false;
    }

    @Override
    public int getInteger() {
        return this.integer;
    }

    public static int parseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.integer = 0;
    }

    public void setInteger(int integer) {
        this.setValue("" + integer);
        this.integer = integer;
    }

    public void setValue(IIntegerData data) {
        if (data.isSpecified()) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        this.integer = IntegerData.parseInteger(value);
    }

    private void setValue(Attr attr) {
        if (attr != null) {
            this.setValue(PropertyDataUtil.getAttributeValue(attr));
        } else {
            this.reset();
        }
    }

    @Override
    public void update(NodeList nodeList) {
        this.nodeList = nodeList;
        this.reset();
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Attr attr = this.getAttributeNode(nodeList.item(i));
                if (i == 0) {
                    this.setValue(attr);
                } else {
                    if (attr != null) {
                        this.setAmbiguous(!this.specified || !StringUtil.compareIgnoreCase((String)this.getValue(), (String)PropertyDataUtil.getAttributeValue(attr)));
                    } else {
                        this.setAmbiguous(this.specified);
                    }
                    if (this.isAmbiguous()) break;
                }
                ++i;
            }
        }
    }
}

