/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview.data;

import com.ibm.etools.struts.jspeditor.vct.attrview.data.IAttributeData;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AttributeData {
    protected String attributeName;
    protected String value;
    protected boolean specified;
    protected boolean ambiguous;
    protected NodeList nodeList;

    public AttributeData(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Attr getAttributeNode(Node node) {
        return AttributeData.getAttributeNode(node, this.attributeName);
    }

    private static Attr getAttributeNode(Node node, String name) {
        if (node != null && node.getNodeType() == 1) {
            return ((Element)node).getAttributeNode(name);
        }
        return null;
    }

    public NodeList getNodeList() {
        return this.nodeList;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public void reset() {
        this.value = null;
        this.ambiguous = false;
        this.specified = false;
    }

    protected void setAmbiguous(boolean ambiguous) {
        this.ambiguous = ambiguous;
    }

    protected void setSpecified(boolean specified) {
        this.specified = specified;
    }

    public void setValue(String value) {
        this.specified = true;
        this.value = value;
    }

    public void setValue(IAttributeData data) {
        if (data.isSpecified()) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    public abstract void update(NodeList var1);
}

