/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview;

import com.ibm.etools.attrview.utils.StringUtil;
import java.util.Vector;

public class SelectionTable {
    private Vector items;
    private boolean ignoreCase = true;

    public SelectionTable() {
        this(null, null, true);
    }

    public SelectionTable(boolean ignoreCase) {
        this(null, null, ignoreCase);
    }

    public SelectionTable(String[] values) {
        this(values, values, true);
    }

    public SelectionTable(String[] values, boolean ignoreCase) {
        this(values, values, ignoreCase);
    }

    public SelectionTable(String[] values, String[] titles) {
        this(values, titles, true);
    }

    public SelectionTable(String[] values, String[] titles, boolean ignoreCase) {
        this.setIgnoreCase(ignoreCase);
        if (values != null) {
            this.setItems(values, titles);
        }
    }

    public void add(SelectionTable table) {
        if (table != null) {
            int i = 0;
            while (i < table.getItemCount()) {
                this.addItem((Item)table.items.get(i));
                ++i;
            }
        }
    }

    private void addItem(Item item) {
        this.addItem(item.getValue(), item.getTitle());
    }

    public void addItem(String value) {
        this.addItem(value, value);
    }

    public void addItem(String value, String title) {
        if (title == null && (title = value) == null) {
            title = "";
        }
        if (this.items == null) {
            this.items = new Vector();
        } else if (this.getItemIndexByValue(value) != -1) {
            return;
        }
        this.items.add(new Item(value, title));
    }

    public Item getItem(int index) {
        if (this.items != null && index >= 0 && index < this.items.size()) {
            return (Item)this.items.get(index);
        }
        return null;
    }

    public Item getItemByTitle(String title) {
        return this.getItem(this.getItemIndexByTitle(title));
    }

    public Item getItemByValue(String value) {
        return this.getItem(this.getItemIndexByValue(value));
    }

    public int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    public int getItemIndexByTitle(String title) {
        if (this.items != null && title != null) {
            int i = 0;
            while (i < this.items.size()) {
                Item item = (Item)this.items.get(i);
                if (this.ignoreCase ? StringUtil.compareIgnoreCase((String)item.getTitle(), (String)title) : StringUtil.compare((String)item.getTitle(), (String)title)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getItemIndexByValue(String value) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.size()) {
                Item item = (Item)this.items.get(i);
                if (this.ignoreCase ? StringUtil.compareIgnoreCase((String)item.getValue(), (String)value) : StringUtil.compare((String)item.getValue(), (String)value)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getTitle(int index) {
        Item item = this.getItem(index);
        if (item != null) {
            return item.getTitle();
        }
        return null;
    }

    public String getTitle(String value) {
        Item item = this.getItemByValue(value);
        if (item != null) {
            return item.getTitle();
        }
        return null;
    }

    public String[] getTitles() {
        int count = this.getItemCount();
        if (count > 0) {
            String[] titles = new String[count];
            int i = 0;
            while (i < count) {
                titles[i] = ((Item)this.items.get(i)).getTitle();
                ++i;
            }
            return titles;
        }
        return null;
    }

    public String getValue(int index) {
        Item item = this.getItem(index);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public String getValue(String title) {
        Item item = this.getItemByTitle(title);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public String[] getValues() {
        int count = this.getItemCount();
        if (count > 0) {
            String[] values = new String[count];
            int i = 0;
            while (i < count) {
                values[i] = ((Item)this.items.get(i)).getValue();
                ++i;
            }
            return values;
        }
        return null;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void reset() {
        this.items = null;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setItems(String[] values) {
        this.setItems(values, values);
    }

    public void setItems(String[] values, String[] titles) {
        this.reset();
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.addItem(values[i], titles != null && i < titles.length ? titles[i] : values[i]);
                ++i;
            }
        }
    }

    public class Item {
        private String value;
        private String title;

        public Item(String value, String title) {
            this.value = value;
            this.title = title;
        }

        public String getValue() {
            return this.value;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

