/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.struts.jspeditor.vct.NodeListImpl;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FindNodeUtil {
    public static String getTagName(Node node) {
        String name = node.getNodeName();
        int i = name.indexOf(58);
        if (i > 0) {
            return name.substring(i + 1);
        }
        return name;
    }

    public static Node findAncestor(Node node, String[] targets, String[] blocks) {
        while (node != null) {
            if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])targets)) {
                return node;
            }
            if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])blocks)) {
                return null;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static NodeList findAncestors(Node node, String[] targets, String[] blocks) {
        if (node == null) {
            return null;
        }
        if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])blocks)) {
            return null;
        }
        NodeListImpl list = new NodeListImpl();
        if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])targets)) {
            list.add(node);
        }
        Node parent = node.getParentNode();
        list.add(FindNodeUtil.findAncestors(parent, targets, blocks));
        return list.getLength() > 0 ? list : null;
    }

    public static NodeList findChildren(Node node, String[] targets) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        NodeListImpl targetChildren = new NodeListImpl();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(child), (String[])targets)) {
                targetChildren.add(child);
            }
            ++i;
        }
        return targetChildren.getLength() > 0 ? targetChildren : null;
    }

    public static NodeList findChildren(Node node, String target) {
        return FindNodeUtil.findChildren(node, new String[]{target});
    }

    public static NodeList findDescendant(Node node, String[] targets) {
        if (node == null) {
            return null;
        }
        if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])targets)) {
            return new NodeListImpl(node);
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        NodeListImpl descendant = new NodeListImpl();
        int i = 0;
        while (i < children.getLength()) {
            NodeList d = FindNodeUtil.findDescendant(children.item(i), targets);
            if (d != null) {
                descendant.add(d);
            }
            ++i;
        }
        return descendant.getLength() > 0 ? descendant : null;
    }

    public static NodeList findDescendant(Node node, String[] targets, String[] blocks) {
        if (node == null) {
            return null;
        }
        if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])targets)) {
            return new NodeListImpl(node);
        }
        if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])blocks)) {
            return null;
        }
        NodeList children = node.getChildNodes();
        if (children == null || children.getLength() < 1) {
            return null;
        }
        NodeListImpl descendant = new NodeListImpl();
        int i = 0;
        while (i < children.getLength()) {
            NodeList d = FindNodeUtil.findDescendant(children.item(i), targets, blocks);
            if (d != null) {
                descendant.add(d);
            }
            ++i;
        }
        return descendant.getLength() > 0 ? descendant : null;
    }

    public static NodeList findDescendants(Node node, String[] targets) {
        return FindNodeUtil.findDescendants(node, targets, null);
    }

    public static NodeList findDescendants(Node node, String[] targets, String[] blocks) {
        NodeList children;
        if (node == null) {
            return null;
        }
        NodeListImpl list = new NodeListImpl();
        if (blocks != null && StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])blocks)) {
            return null;
        }
        if (targets == null || StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])targets)) {
            list.addUnique(node);
        }
        if ((children = node.getChildNodes()) == null || children.getLength() < 1) {
            return list;
        }
        int i = 0;
        while (i < children.getLength()) {
            list.addUnique(FindNodeUtil.findDescendants(children.item(i), targets, blocks));
            ++i;
        }
        return list.getLength() > 0 ? list : null;
    }

    public static Node findDocumentNode(Node node) {
        Node parent = null;
        while (node != null) {
            if (node.getNodeType() == 9) {
                return node;
            }
            parent = node;
            node = node.getParentNode();
        }
        return parent;
    }

    public static NodeList findSiblings(NodeList nodes, String[] names) {
        NodeListImpl targets = new NodeListImpl();
        Node node = null;
        if (nodes != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                if (StringUtil.belongsToIgnoreCase((String)FindNodeUtil.getTagName(node), (String[])names)) {
                    targets.addUnique(node);
                }
                ++i;
            }
        }
        return targets.getLength() > 0 ? targets : null;
    }

    public static NodeList findSiblings(NodeList nodes, String name) {
        return FindNodeUtil.findSiblings(nodes, new String[]{name});
    }

    public static Node findValidatorNode(Node node, String validatorName) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (StringUtil.compareIgnoreCase((String)validatorName, (String)FindNodeUtil.getTagName(children.item(i)))) {
                    return children.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static NodeList findChildren(Node parent) {
        NodeListImpl kids = new NodeListImpl();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                kids.add(children.item(i));
            }
            ++i;
        }
        return kids;
    }

    public static Node findFacet(NodeList facets, String facetName) {
        if (facets == null || facetName == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < facets.getLength()) {
                Node facet = facets.item(i);
                if (facetName.equalsIgnoreCase(FindNodeUtil.findNodeAttribute(facet, "name"))) {
                    return facet;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String findNodeAttribute(Node node, String attributeName) {
        Node attribute;
        if (node == null || attributeName == null) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (attribute = attributes.getNamedItem(attributeName)) != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public static String[] findBundleList(NodeList nodeList) {
        if (nodeList != null) {
            Node ancestor = FindNodeUtil.findAncestor(nodeList.item(0), new String[]{"HTML"}, null);
            NodeList descendents = FindNodeUtil.findDescendants(ancestor, new String[]{"setBundle"});
            ArrayList<String> items = new ArrayList<String>();
            int i = 0;
            while (descendents != null && i < descendents.getLength()) {
                String var;
                Node attribute;
                NamedNodeMap attributes = descendents.item(i).getAttributes();
                if (attributes != null && (attribute = attributes.getNamedItem("var")) != null && (var = attribute.getNodeValue()) != null && !var.equals("")) {
                    items.add(var);
                }
                ++i;
            }
            Object[] availablePages = items.toArray();
            String[] strArray = new String[availablePages.length];
            System.arraycopy(availablePages, 0, strArray, 0, availablePages.length);
            return strArray;
        }
        return new String[0];
    }

    public static String[] getKeysFromBundle(NodeList nodeList, String bundleStr) {
        Vector<String> vector = new Vector<String>();
        if (nodeList != null) {
            Node ancestor = FindNodeUtil.findAncestor(nodeList.item(0), new String[]{"HTML"}, null);
            NodeList descendents = FindNodeUtil.findDescendants(ancestor, new String[]{"setBundle"});
            String basename = null;
            int i = 0;
            while (descendents != null && i < descendents.getLength()) {
                Node basenameAttr;
                String var;
                Node attribute;
                NamedNodeMap attributes = descendents.item(i).getAttributes();
                if (attributes != null && (attribute = attributes.getNamedItem("var")) != null && (var = attribute.getNodeValue()) != null && var.equals(bundleStr) && (basenameAttr = attributes.getNamedItem("basename")) != null) {
                    basename = basenameAttr.getNodeValue();
                }
                ++i;
            }
            if (basename != null) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(basename);
                    Enumeration<String> keys = resourceBundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        vector.add(key);
                    }
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        Object[] o = vector.toArray();
        String[] p = new String[o.length];
        int i = 0;
        while (i < o.length) {
            p[i] = (String)o[i];
            ++i;
        }
        return p;
    }

    public static interface Tester {
        public boolean isTarget(Node var1);

        public boolean isEnd(Node var1);
    }
}

