/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.attrview;

import com.ibm.etools.attrview.AVContents;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.sdk.AVFolder;
import com.ibm.etools.struts.jspeditor.attrview.StrutsAttributesViewFactory;
import com.ibm.etools.struts.jspeditor.attrview.StrutsAttributesViewSpecification;
import com.ibm.etools.struts.jspeditor.attrview.folders.StrutsFolder;
import com.ibm.etools.webedit.common.attrview.HTMLFolderDescriptor;
import com.ibm.etools.webedit.common.attrview.HTMLPageDescriptor;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class StrutsAttributesViewManager {
    private AttributesView view;
    private static final int CACHE_SIZE = 4;
    private AVFolder nowFolder;
    private List folders = new ArrayList();

    public StrutsAttributesViewManager(AttributesView view) {
        this.view = view;
    }

    public void dispose() {
        if (this.folders != null) {
            this.disposeFolders();
            this.folders.clear();
            this.folders = null;
        }
        this.view = null;
    }

    public AVContents getContentsFor(AVEditorContextProvider provider) {
        AVSelection selection = provider.getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof NodeSelection)) {
            return null;
        }
        NodeSelection domselection = (NodeSelection)selection;
        NodeList nodeList = domselection.getNodeList();
        if (nodeList == null) {
            return null;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            AVContents folder;
            Node node = nodeList.item(i);
            while (node != null) {
                if (node.getNodeType() == 1 || node.getNodeType() == 8) break;
                node = node.getParentNode();
            }
            if (node == null) {
                return null;
            }
            if ((node.getNodeType() == 1 || node.getNodeType() == 8) && (folder = this.findFolder(node)) != null) {
                return folder;
            }
            ++i;
        }
        return null;
    }

    private void disposeFolders() {
        if (this.folders == null) {
            return;
        }
        int size = this.folders.size();
        int i = 0;
        while (i < size) {
            AVContents folder = (AVContents)this.folders.get(i);
            if (folder != null && folder instanceof AVFolder) {
                ((AVFolder)folder).dispose();
            }
            ++i;
        }
    }

    private AVContents findFolder(Node node) {
        HTMLFolderDescriptor folderDesc;
        if (this.folders == null || node == null) {
            return null;
        }
        HTMLPageDescriptor pageDesc = StrutsAttributesViewSpecification.findPage(node);
        if (pageDesc == null) {
            return null;
        }
        if (pageDesc != null && (folderDesc = pageDesc.getFolder()) != null) {
            StrutsFolder folder = null;
            int size = this.folders.size();
            int i = 0;
            while (i < size) {
                HTMLFolderDescriptor desc;
                AVContents content = (AVContents)this.folders.get(i);
                if (content != null && content instanceof StrutsFolder && (desc = (folder = (StrutsFolder)content).getFolderDescriptor()) == folderDesc) {
                    if (folder != this.nowFolder) {
                        folder.setPageDescriptor(pageDesc);
                        this.nowFolder = folder;
                    }
                    return folder;
                }
                ++i;
            }
            folder = StrutsAttributesViewFactory.createFolder(folderDesc);
            if (folder != null) {
                folder.setFolderDescriptor(folderDesc);
                folder.setPageDescriptor(pageDesc);
                folder.setView(this.view);
                folder.createContents();
                this.putFolder((AVContents)folder);
                this.nowFolder = folder;
                return folder;
            }
        }
        return null;
    }

    private void putFolder(AVContents folder) {
        if (this.folders == null || folder == null) {
            return;
        }
        int size = this.folders.size();
        if (4 <= size) {
            int i = size - 1;
            while (4 <= i) {
                AVContents content = (AVContents)this.folders.get(i);
                if (content != null && content instanceof AVFolder) {
                    ((AVFolder)content).dispose();
                }
                this.folders.remove(i);
                --i;
            }
        }
        this.folders.add(0, folder);
    }
}

