/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.facet;

import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.facet.IStrutsFacetDataModelProperties;
import com.ibm.etools.struts.facet.RuntimeChecker;
import com.ibm.etools.struts.facet.StrutsFacetDelegate;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.preference.StrutsPreferences;
import com.ibm.etools.struts.projnavigator.StrutsProjNavUtil;
import com.ibm.etools.struts.strutsconfig.StrutsConfigFileCreator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspFactory;
import org.eclipse.jst.j2ee.jsp.JspPackage;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.osgi.framework.Bundle;

public class StrutsFacetInstallDelegate
extends StrutsFacetDelegate
implements IStrutsFacetDataModelProperties {
    private static final String STRUTS_CONFIG_FILE = "struts-config.xml";
    private static final String SERVLET_NAME = "action";
    private static final int ACTION_SERVLET_LOAD_ON_STARTUP = 2;
    private static final String CONFIG_INITPARAM_NAME = "config";
    private static final String APPLICATION_INITPARAM_NAME = "application";
    private static final String DEBUG_INITPARAM_NAME = "debug";
    private static final String DEBUG_INITPARAM_DEFAULT_VALUE = "2";
    private static final String DETAIL_INITPARAM_NAME = "detail";
    private static final String DETAIL_INITPARAM_DEFAULT_VALUE = "2";
    private static final String VALIDATE_INITPARAM_NAME = "validate";
    private static final String VALIDATE_INITPARAM_DEFAULT_VALUE = "true";
    private static final String URL_PATTERN = "*.do";
    private static final String DEFAULT_RESOURCE_BUNDLE_FILE = "templates/ApplicationResources.properties";
    private static final String PORTLET_PROJECT_NATURE_ID = "com.ibm.etools.portal.tools.PortletProjectNature";

    @Override
    protected void execute() throws CoreException {
        if (this.hasPortletNature(this.project)) {
            this.error(ResourceHandler.facet_install_error_portlet_project, new String[0]);
        }
        this.updateProject();
        if (this.model.getBooleanProperty("IStrutsFacetDataModelProperties.PSEUDO_INSTALL")) {
            return;
        }
        this.checkInstallVersion();
        this.validateEdit();
        Model2ProjectPropertyUtils.setPackagePrefix((IProject)this.component.getProject(), (String)this.model.getStringProperty("IStrutsFacetDataModelProperties.DEFAULT_PACKAGE_PREFIX"));
        this.copyJarFiles();
        this.createStrutsConfigFile();
        this.createResourceBundleFile();
        this.updateWebXML();
        this.updatePreferences();
        new RuntimeChecker().checkProject(this.project, false, true, this.monitor);
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        final ITriggerPoint point = support.getTriggerPointManager().getTriggerPoint("org.eclipse.ui.ide.natures");
        if (point != null) {
            UIJob job = new UIJob(ResourceHandler.StrutsFacetInstallDelegate_EnableStrutsCapability){

                public IStatus runInUIThread(IProgressMonitor jobMonitor) {
                    WorkbenchActivityHelper.allowUseOf((ITriggerPoint)point, (Object)new IPluginContribution(){

                        public String getPluginId() {
                            return StrutsPlugin.getPluginId();
                        }

                        public String getLocalId() {
                            return StrutsPlugin.getPluginId();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        try {
            IDataModelOperation operation = (IDataModelOperation)this.model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION");
            operation.execute(this.monitor, null);
        }
        catch (Exception execption) {
            StrutsPlugin.getLogger().log((Throwable)execption);
        }
        StrutsProjNavUtil.forceProjectNavigatorRefresh();
    }

    private void updateProject() {
        StrutsProjectUtil.addFeature(this.project, "com.ibm.etools.struts.wizards.project.feature");
        StrutsProjectUtil.addNature(this.project, "com.ibm.etools.struts.StrutsNature");
    }

    private boolean hasPortletNature(IProject aProject) {
        try {
            return aProject.getDescription().hasNature(PORTLET_PROJECT_NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected IPath getWEBINFPath() {
        return this.component.getProject().getFullPath().append(Model2Util.getWEBINFPath((IVirtualComponent)this.component));
    }

    private void createStrutsConfigFile() {
        IFile strutsConfigFile = this.getStrutsConfigFile();
        if (strutsConfigFile != null) {
            String resourceBundle = null;
            if (this.getVersionInt() >= 1 && this.model.getBooleanProperty("IStrutsFacetDataModelProperties.CREATE_RESOURCE_BUNDLE")) {
                resourceBundle = this.getFullResourceBundleName();
            }
            try {
                StrutsConfigFileCreator scfCreator = new StrutsConfigFileCreator(this.getVersionInt(), resourceBundle);
                scfCreator.writeTo(strutsConfigFile, this.monitor);
            }
            catch (Exception e) {
                StrutsPlugin.getLogger().log((Throwable)e);
            }
        }
    }

    private String getFullResourceBundleName() {
        String resourceBundlePackage = this.model.getStringProperty("IStrutsFacetDataModelProperties.RESOURCE_BUNDLE_PACKAGE");
        String resourceBundleName = this.model.getStringProperty("IStrutsFacetDataModelProperties.RESOURCE_BUNDLE_NAME");
        if (resourceBundlePackage.length() > 0) {
            return String.valueOf(resourceBundlePackage) + "." + resourceBundleName;
        }
        return resourceBundleName;
    }

    private IFile getStrutsConfigFile() {
        IFile file = this.component.getRootFolder().getFolder("WEB-INF").getFile(STRUTS_CONFIG_FILE).getUnderlyingFile();
        return file.exists() ? null : file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createResourceBundleFile() {
        IFile resourceBundleFile = this.getResourceBundleFile();
        if (resourceBundleFile == null) return;
        String packageName = this.model.getStringProperty("IStrutsFacetDataModelProperties.RESOURCE_BUNDLE_PACKAGE");
        String propertiesFilename = String.valueOf(this.model.getStringProperty("IStrutsFacetDataModelProperties.RESOURCE_BUNDLE_NAME")) + ".properties";
        IPackageFragment targetPackage = this.getResourceBundlePackage(packageName);
        if (targetPackage != null) {
            IFolder packageFolder;
            try {
                packageFolder = (IFolder)targetPackage.getUnderlyingResource();
            }
            catch (JavaModelException exception) {
                StrutsPlugin.getLogger().log("Cannot locate package for resource bundle file", (Throwable)exception);
                return;
            }
            IFile propertiesFile = packageFolder.getFile(propertiesFilename);
            if (propertiesFile.exists()) {
                if (propertiesFile.getType() != 1) {
                    StrutsPlugin.getLogger().trace(StrutsPlugin.getPluginId(), "Cannot locate source file");
                    return;
                } else {
                    StrutsPlugin.getLogger().trace(StrutsPlugin.getPluginId(), "Resource Bundle already exists");
                }
                return;
            }
            InputStream stream = null;
            try {
                try {
                    Bundle bundle = StrutsPlugin.getDefault().getBundle();
                    stream = new BufferedInputStream(FileLocator.openStream((Bundle)bundle, (IPath)new Path(DEFAULT_RESOURCE_BUNDLE_FILE), (boolean)false));
                    propertiesFile.create(stream, false, this.monitor);
                    return;
                }
                catch (IOException exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                    if (stream == null) return;
                    try {
                        try {
                            stream.close();
                            return;
                        }
                        catch (IOException ignored) {
                            StrutsPlugin.getLogger().log((Throwable)ignored);
                            stream = null;
                        }
                        return;
                    }
                    finally {
                        stream = null;
                    }
                }
                catch (CoreException exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                    if (stream == null) return;
                    try {
                        try {
                            stream.close();
                            return;
                        }
                        catch (IOException ignored) {
                            StrutsPlugin.getLogger().log((Throwable)ignored);
                            stream = null;
                        }
                        return;
                    }
                    finally {
                        stream = null;
                    }
                }
            }
            finally {
                block33: {
                    if (stream != null) {
                        try {
                            try {
                                stream.close();
                            }
                            catch (IOException ignored) {
                                StrutsPlugin.getLogger().log((Throwable)ignored);
                                stream = null;
                                break block33;
                            }
                        }
                        catch (Throwable throwable) {
                            stream = null;
                            throw throwable;
                        }
                        stream = null;
                    }
                }
            }
        }
        StrutsPlugin.getLogger().log("Package for resource bundle cannot be created");
    }

    private IFile getResourceBundleFile() {
        IFolder sourceFolder;
        if (!this.model.getBooleanProperty("IStrutsFacetDataModelProperties.CREATE_RESOURCE_BUNDLE")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.component.getProject());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)(sourceFolder = Model2Util.getSourceFolder((IVirtualComponent)this.component)));
        IPackageFragment targetPackage = root.getPackageFragment(this.model.getStringProperty("IStrutsFacetDataModelProperties.RESOURCE_BUNDLE_PACKAGE"));
        IPath resourceBundlePath = targetPackage.getPath().append(String.valueOf(this.model.getStringProperty("IStrutsFacetDataModelProperties.RESOURCE_BUNDLE_NAME")) + ".properties");
        IFile resourceBundleFile = this.getFile(resourceBundlePath);
        return resourceBundleFile.exists() ? null : resourceBundleFile;
    }

    private IPackageFragment getResourceBundlePackage(String packageName) {
        try {
            IPackageFragmentRoot root;
            IPackageFragment targetPackage;
            IJavaProject javaProject = JavaCore.create((IProject)this.component.getProject());
            IFolder srcDirFolder = Model2Util.getSourceFolder((IVirtualComponent)this.component);
            if (!srcDirFolder.exists()) {
                StrutsPlugin.getLogger().trace(StrutsPlugin.getPluginId(), "Source Folder does not exist, creating it");
                srcDirFolder.create(true, true, this.monitor);
            }
            if (!(targetPackage = (root = javaProject.getPackageFragmentRoot((IResource)srcDirFolder)).getPackageFragment(packageName)).exists()) {
                StrutsPlugin.getLogger().trace(StrutsPlugin.getPluginId(), "Package does not exist, creating it");
                root.createPackageFragment(packageName, false, this.monitor);
            }
            return targetPackage;
        }
        catch (Exception e) {
            StrutsPlugin.getLogger().log("Problem getting or creating package " + packageName, (Throwable)e);
            return null;
        }
    }

    @Override
    protected void createUpdateWebEditModelCommands(List<Command> commands, WebArtifactEdit webEditModel) {
        Servlet servlet = this.createAddServletCommands(commands, webEditModel);
        this.createAddServletMappingCommand(commands, webEditModel, servlet);
    }

    private Servlet createAddServletCommands(List commands, WebArtifactEdit webEditModel) {
        Servlet servlet = (Servlet)ConfigFileIdentifierQuizMaster.getStrutsActionServlet(this.component);
        if (servlet == null) {
            WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
            ServletType servletType = factory.createServletType();
            servletType.setClassName("org.apache.struts.action.ActionServlet");
            servlet = factory.createServlet();
            servlet.setServletName(SERVLET_NAME);
            servlet.setWebType((WebType)servletType);
            servlet.setLoadOnStartup(new Integer(2));
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webEditModel.getWebApp(), (Object)WebapplicationPackage.eINSTANCE.getWebApp_Servlets(), (Object)servlet));
        }
        this.createAddInitParamCommand(commands, webEditModel, servlet, CONFIG_INITPARAM_NAME, "/WEB-INF/struts-config.xml");
        this.createAddInitParamCommand(commands, webEditModel, servlet, DEBUG_INITPARAM_NAME, "2");
        this.createAddInitParamCommand(commands, webEditModel, servlet, DETAIL_INITPARAM_NAME, "2");
        this.createAddInitParamCommand(commands, webEditModel, servlet, VALIDATE_INITPARAM_NAME, VALIDATE_INITPARAM_DEFAULT_VALUE);
        if (this.getVersionInt() < 1 && this.model.getBooleanProperty("IStrutsFacetDataModelProperties.CREATE_RESOURCE_BUNDLE")) {
            this.createAddInitParamCommand(commands, webEditModel, servlet, APPLICATION_INITPARAM_NAME, this.getFullResourceBundleName());
        }
        return servlet;
    }

    private void createAddInitParamCommand(List commands, WebArtifactEdit webEditModel, Servlet servlet, String paramName, String paramValue) {
        int j2eeVersionId = webEditModel.getWebApp().getJ2EEVersionID();
        if (j2eeVersionId == 12 || j2eeVersionId == 13) {
            for (InitParam initParam : servlet.getParams()) {
                if (!paramName.equals(initParam.getParamName())) continue;
                return;
            }
            WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
            InitParam initParam = factory.createInitParam();
            initParam.setParamName(paramName);
            initParam.setParamValue(paramValue);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_Params(), (Object)initParam));
        } else {
            ParamValue initParam2;
            for (ParamValue initParam2 : servlet.getInitParams()) {
                if (!paramName.equals(initParam2.getName())) continue;
                return;
            }
            initParam2 = CommonFactory.eINSTANCE.createParamValue();
            initParam2.setName(paramName);
            initParam2.setValue(paramValue);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_InitParams(), (Object)initParam2));
        }
    }

    private void createAddServletMappingCommand(List commands, WebArtifactEdit webEditModel, Servlet servlet) {
        WebApp webApp = webEditModel.getWebApp();
        EList servletMappings = webApp.getServletMappings();
        for (ServletMapping servletMapping : servletMappings) {
            Servlet curServlet = servletMapping.getServlet();
            if (!servlet.equals(curServlet)) continue;
            return;
        }
        WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
        ServletMapping servletMapping = factory.createServletMapping();
        servletMapping.setServlet(servlet);
        servletMapping.setUrlPattern(URL_PATTERN);
        commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_ServletMappings(), (Object)servletMapping));
    }

    protected void createAddTaglibEntriesCommands(List commands, WebArtifactEdit webEditModel) {
        ArrayList<String> taglibs = new ArrayList<String>();
        String[] tldFiles = this.getTLDFiles(this.getVersionInt(), false);
        int i = 0;
        while (i < tldFiles.length) {
            taglibs.add("/WEB-INF/" + tldFiles[i]);
            ++i;
        }
        int j2eeVersion = webEditModel.getWebApp().getJ2EEVersionID();
        switch (j2eeVersion) {
            case 12: 
            case 13: {
                this.createAddPre1_4TaglibEntriesCommands(commands, webEditModel, taglibs);
                break;
            }
            default: {
                this.createAdd1_4TaglibEntriesCommands(commands, webEditModel, taglibs);
            }
        }
    }

    private void createAddPre1_4TaglibEntriesCommands(List commands, WebArtifactEdit webEditModel, List taglibs) {
        WebApp webApp = webEditModel.getWebApp();
        EList existingTaglibs = webApp.getTagLibs();
        WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
        for (String taglibLocation : taglibs) {
            boolean containsTaglib = false;
            for (TagLibRef curTagLib : existingTaglibs) {
                if (!taglibLocation.equals(curTagLib.getTaglibLocation())) continue;
                containsTaglib = true;
                break;
            }
            if (containsTaglib) continue;
            TagLibRef taglib = factory.createTagLibRef();
            taglib.setTaglibLocation(taglibLocation);
            taglib.setTaglibURI(taglibLocation);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_TagLibs(), (Object)taglib));
        }
    }

    private void createAdd1_4TaglibEntriesCommands(List commands, WebArtifactEdit webEditModel, List taglibs) {
        WebApp webApp = webEditModel.getWebApp();
        JSPConfig jspConfig = webApp.getJspConfig();
        if (jspConfig == null) {
            jspConfig = JspFactory.eINSTANCE.createJSPConfig();
            commands.add(SetCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)webApp, (Object)WebapplicationPackage.eINSTANCE.getWebApp_JspConfig(), (Object)jspConfig));
        }
        EList existingTaglibs = jspConfig.getTagLibs();
        for (String taglibLocation : taglibs) {
            boolean containsTaglib = false;
            for (TagLibRefType curTagLib : existingTaglibs) {
                if (!taglibLocation.equals(curTagLib.getTaglibLocation())) continue;
                containsTaglib = true;
                break;
            }
            if (containsTaglib) continue;
            TagLibRefType taglib = JspFactory.eINSTANCE.createTagLibRefType();
            taglib.setTaglibLocation(taglibLocation);
            taglib.setTaglibURI(taglibLocation);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(webEditModel), (Object)jspConfig, (Object)JspPackage.eINSTANCE.getJSPConfig_TagLibs(), (Object)taglib));
        }
    }

    protected EditingDomain getEditingDomain(WebArtifactEdit webEditModel) {
        return new AdapterFactoryEditingDomain(new AdapterFactory(){

            public boolean isFactoryForType(Object type) {
                return false;
            }

            public Object adapt(Object object, Object type) {
                return null;
            }

            public Adapter adapt(Notifier target, Object type) {
                return null;
            }

            public Adapter adaptNew(Notifier target, Object type) {
                return null;
            }

            public void adaptAllNew(Notifier notifier) {
            }
        }, this.getCommandStack(webEditModel));
    }

    private void updatePreferences() {
        StrutsPreferences preferences = StrutsPlugin.getDefault().getStrutsPreferences();
        preferences.setDefaultStrutsVersion(this.version.getVersionString());
    }
}

