/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.facet;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.facet.NoRuntimesWarningDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class RuntimeChecker {
    public void checkProject(IProject project, boolean autoAdd, boolean force, IProgressMonitor monitor) {
        this.checkProjects(Collections.singletonList(project), autoAdd, force, monitor);
    }

    public void checkProjects(Collection projects, boolean autoAdd, boolean force, IProgressMonitor monitor) {
        ArrayList unrunnableProjectNames = new ArrayList();
        try {
            for (IProject project : projects) {
                IFacetedProject facetedProject;
                if (!project.exists() || (facetedProject = this.getFacetedProject(project)) == null) continue;
                Set facetVersions = facetedProject.getProjectFacets();
                if (!force && !this.containsFacet(facetVersions, "web.struts")) continue;
                this.checkProject(facetedProject, facetVersions, autoAdd, unrunnableProjectNames);
            }
        }
        finally {
            if (!unrunnableProjectNames.isEmpty()) {
                this.informNoRuntimes(unrunnableProjectNames);
            }
        }
    }

    private IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private boolean containsFacet(Set facetVersions, String facetId) {
        for (IProjectFacetVersion facetVersion : facetVersions) {
            if (!facetVersion.getProjectFacet().getId().equals(facetId)) continue;
            return true;
        }
        return false;
    }

    private void checkProject(IFacetedProject facetedProject, Set facetVersions, boolean autoAdd, List unrunnableProjectNames) {
        IRuntime primaryRuntime = facetedProject.getPrimaryRuntime();
        if (primaryRuntime == null || !this.supports(primaryRuntime, facetVersions)) {
            if (autoAdd) {
                IRuntime runtime = this.getTargetedRuntime(facetedProject, facetVersions);
                if (runtime != null) {
                    this.setPrimaryRuntime(facetedProject, runtime);
                } else {
                    Set runtimes = RuntimeManager.getRuntimes((Set)facetVersions);
                    if (!runtimes.isEmpty()) {
                        this.setTargetedRuntimes(facetedProject, runtimes);
                    } else {
                        unrunnableProjectNames.add(facetedProject.getProject().getName());
                    }
                }
            } else {
                unrunnableProjectNames.add(facetedProject.getProject().getName());
            }
        }
    }

    private void informNoRuntimes(List unrunnableProjectNames) {
        final String[] projectNames = unrunnableProjectNames.toArray(new String[unrunnableProjectNames.size()]);
        if (ErrorDialog.AUTOMATED_MODE) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NoRuntimesWarningDialog.open(Display.getDefault().getActiveShell(), projectNames);
            }
        });
    }

    private boolean supports(IRuntime runtime, Set facetVersions) {
        for (IProjectFacetVersion facetVersion : facetVersions) {
            if (runtime.supports(facetVersion)) continue;
            return false;
        }
        return true;
    }

    private IRuntime getTargetedRuntime(IFacetedProject facetedProject, Set facetVersions) {
        for (IRuntime runtime : facetedProject.getTargetedRuntimes()) {
            if (!this.supports(runtime, facetVersions)) continue;
            return runtime;
        }
        return null;
    }

    private void setPrimaryRuntime(final IFacetedProject facetedProject, final IRuntime runtime) {
        Job job = new Job("Set primary runtime"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    facetedProject.setPrimaryRuntime(runtime, monitor);
                }
                catch (CoreException exception) {
                    return new Status(4, StrutsPlugin.getPluginId(), 0, null, (Throwable)exception);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    private void setTargetedRuntimes(final IFacetedProject facetedProject, final Set runtimes) {
        Job job = new Job("Set targeted runtimes"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    facetedProject.setTargetedRuntimes(runtimes, monitor);
                }
                catch (CoreException exception) {
                    return new Status(4, StrutsPlugin.getPluginId(), 0, null, (Throwable)exception);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }
}

