/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.facet;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.projnavigator.StrutsProjNavUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JspPackage;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class AbstractStrutsFacetUninstallDelegate
implements IDelegate {
    private IProject project;
    private IProjectFacetVersion version;
    private IVirtualComponent component;
    private IProgressMonitor monitor;

    public IProjectFacetVersion getVersion() {
        return this.version;
    }

    public IProject getProject() {
        return this.project;
    }

    public IVirtualComponent getComponent() {
        if (this.component == null) {
            this.component = Model2Util.findComponent((IResource)this.project);
        }
        return this.component;
    }

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.project = project;
        this.version = fv;
        this.monitor = monitor;
        try {
            this.updateConfigFiles(monitor);
            this.removeFiles(this.getFilesToBeRemove(), monitor);
            this.updateProject();
        }
        finally {
            this.dispose();
        }
        StrutsProjNavUtil.forceProjectNavigatorRefresh();
    }

    protected void removeFiles(ArrayList fileList, IProgressMonitor monitor) throws CoreException {
        if (fileList == null || fileList.size() == 0) {
            return;
        }
        IFile file2 = null;
        try {
            for (IFile file2 : fileList) {
                StrutsPlugin.getLogger().trace(StrutsPlugin.getPluginId(), "Removing " + file2.getFullPath());
                file2.delete(false, monitor);
            }
        }
        catch (CoreException ce) {
            StrutsPlugin.getLogger().log((Throwable)ce);
            IPath path = null;
            if (file2 != null) {
                path = file2.getFullPath();
            }
            throw new CoreException((IStatus)new Status(4, StrutsPlugin.getPluginId(), 4, NLS.bind((String)ResourceHandler.facet_uninstall_error_file_delete, (Object)path), null));
        }
        catch (OperationCanceledException oce) {
            StrutsPlugin.getLogger().log((Throwable)oce);
        }
    }

    private ArrayList getFilesToBeRemove() {
        ArrayList list = new ArrayList();
        this.updateRemovableFileList(list, this.getJarFiles(), this.getComponent().getRootFolder().getFolder("WEB-INF/lib"));
        this.updateRemovableFileList(list, this.getTLDFiles(), this.getComponent().getRootFolder().getFolder("WEB-INF"));
        return list;
    }

    private void updateRemovableFileList(ArrayList list, String[] filesToRemove, IVirtualFolder folder) {
        if (folder != null && filesToRemove != null) {
            int i = 0;
            while (i < filesToRemove.length) {
                IFile targetFile = folder.getFile(filesToRemove[i]).getUnderlyingFile();
                if (targetFile.exists() && targetFile.isAccessible() && !targetFile.isReadOnly()) {
                    list.add(targetFile);
                }
                ++i;
            }
        }
    }

    public abstract String[] getJarFiles();

    public abstract String[] getTLDFiles();

    public void updateConfigFiles(IProgressMonitor monitor) {
        this.updateWebXML(monitor);
    }

    protected final void updateWebXML(IProgressMonitor monitor) {
        WebArtifactEdit webEditModel = Model2Util.getWebArtifactEdit((IVirtualComponent)this.getComponent(), (boolean)false);
        if (webEditModel != null) {
            try {
                try {
                    Command command = this.createUpdateWebEditModelCommand(webEditModel);
                    if (command != null) {
                        this.getCommandStack((EnterpriseArtifactEdit)webEditModel).execute(command);
                    }
                    webEditModel.saveIfNecessary(monitor);
                }
                catch (Exception exception) {
                    StrutsPlugin.getLogger().log("Exception during update of web.xml", (Throwable)exception);
                    webEditModel.dispose();
                }
            }
            finally {
                webEditModel.dispose();
            }
        }
    }

    private final Command createUpdateWebEditModelCommand(WebArtifactEdit webEditModel) {
        ArrayList commands = new ArrayList();
        this.createUpdateWebEditModelCommands(commands, webEditModel);
        switch (commands.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Command)commands.get(0);
            }
        }
        return new CompoundCommand(commands);
    }

    public abstract void createUpdateWebEditModelCommands(List var1, WebArtifactEdit var2);

    protected final void createRemoveStrutsServletCommands(List commands, WebArtifactEdit webEditModel) {
        if (webEditModel == null) {
            return;
        }
        WebApp webApp = webEditModel.getWebApp();
        if (webApp == null) {
            return;
        }
        Servlet servlet = (Servlet)ConfigFileIdentifierQuizMaster.getStrutsActionServlet(this.getComponent());
        if (servlet == null) {
            return;
        }
        WebapplicationPackage pkg = WebapplicationPackage.eINSTANCE;
        ServletMapping mapping = webApp.getServletMapping(servlet);
        if (mapping != null) {
            commands.add(RemoveCommand.create((EditingDomain)this.getEditingDomain((EnterpriseArtifactEdit)webEditModel), (Object)webApp, (Object)pkg.getWebApp_ServletMappings(), (Object)mapping));
        }
        commands.add(RemoveCommand.create((EditingDomain)this.getEditingDomain((EnterpriseArtifactEdit)webEditModel), (Object)webApp, (Object)pkg.getWebApp_Servlets(), (Object)servlet));
    }

    protected final void createRemoveTaglibEntriesCommand(List commands, WebArtifactEdit webEditModel) {
        HashSet<String> taglibsToRemove = new HashSet<String>();
        String[] tldFiles = this.getTLDFiles();
        if (tldFiles == null) {
            return;
        }
        int i = 0;
        while (i < tldFiles.length) {
            taglibsToRemove.add("/WEB-INF/" + tldFiles[i]);
            ++i;
        }
        WebApp webApp = webEditModel.getWebApp();
        if (webApp == null) {
            return;
        }
        int j2eeVersion = webApp.getJ2EEVersionID();
        Command command = null;
        switch (j2eeVersion) {
            case 12: 
            case 13: {
                command = this.getPre1_4ListToRemoveCommand(webEditModel, webApp, taglibsToRemove);
                break;
            }
            default: {
                command = this.get1_4ListToRemoveCommand(webEditModel, webApp, taglibsToRemove);
            }
        }
        if (command != null) {
            commands.add(command);
        }
    }

    private Command getPre1_4ListToRemoveCommand(WebArtifactEdit webEditModel, WebApp webApp, HashSet taglibsToRemove) {
        EList existingTaglibs = webApp.getTagLibs();
        if (existingTaglibs == null) {
            return null;
        }
        ArrayList<TagLibRef> actualRemovalList = new ArrayList<TagLibRef>();
        for (TagLibRef taglib : existingTaglibs) {
            String location = taglib.getTaglibLocation();
            if (!taglibsToRemove.contains(location)) continue;
            actualRemovalList.add(taglib);
        }
        if (!actualRemovalList.isEmpty()) {
            WebapplicationPackage pkg = WebapplicationPackage.eINSTANCE;
            return RemoveCommand.create((EditingDomain)this.getEditingDomain((EnterpriseArtifactEdit)webEditModel), (Object)webApp, (Object)pkg.getWebApp_TagLibs(), actualRemovalList);
        }
        return null;
    }

    private Command get1_4ListToRemoveCommand(WebArtifactEdit webEditModel, WebApp webApp, HashSet taglibsToRemove) {
        JSPConfig jspConfig = webApp.getJspConfig();
        if (jspConfig == null) {
            return null;
        }
        EList existingTaglibs = jspConfig.getTagLibs();
        if (existingTaglibs == null) {
            return null;
        }
        ArrayList<TagLibRefType> actualRemovalList = new ArrayList<TagLibRefType>();
        for (TagLibRefType taglib : existingTaglibs) {
            String location = taglib.getTaglibLocation();
            if (!taglibsToRemove.contains(location)) continue;
            actualRemovalList.add(taglib);
        }
        if (!actualRemovalList.isEmpty()) {
            JspPackage pkg = JspPackage.eINSTANCE;
            return RemoveCommand.create((EditingDomain)this.getEditingDomain((EnterpriseArtifactEdit)webEditModel), (Object)jspConfig, (Object)pkg.getJSPConfig_TagLibs(), actualRemovalList);
        }
        return null;
    }

    protected EditingDomain getEditingDomain(EnterpriseArtifactEdit editModel) {
        return new AdapterFactoryEditingDomain(new AdapterFactory(){

            public boolean isFactoryForType(Object type) {
                return false;
            }

            public Object adapt(Object object, Object type) {
                return null;
            }

            public Adapter adapt(Notifier target, Object type) {
                return null;
            }

            public Adapter adaptNew(Notifier target, Object type) {
                return null;
            }

            public void adaptAllNew(Notifier notifier) {
            }
        }, this.getCommandStack(editModel));
    }

    protected CommandStack getCommandStack(EnterpriseArtifactEdit artifactEdit) {
        return artifactEdit.getCommandStack();
    }

    protected void dispose() {
        if (this.monitor != null) {
            this.monitor.done();
            this.monitor = null;
        }
        this.component = null;
        this.version = null;
        this.project = null;
    }

    private final void updateProject() {
        String natureId;
        String featureId = this.getPreV7FeatureId();
        if (featureId != null) {
            StrutsProjectUtil.removeFeature(this.project, featureId);
        }
        if ((natureId = this.getPreV7NatureId()) != null) {
            StrutsProjectUtil.removeNature(this.project, natureId);
        }
    }

    protected String getPreV7FeatureId() {
        return "com.ibm.etools.struts.wizards.project.feature";
    }

    protected String getPreV7NatureId() {
        return "com.ibm.etools.struts.StrutsNature";
    }
}

