/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.emf.strutsconfig;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RequestScope implements Enumerator
{
    REQUEST_LITERAL(0, "request", "request"),
    SESSION_LITERAL(1, "session", "session");

    public static final int REQUEST = 0;
    public static final int SESSION = 1;
    private static final RequestScope[] VALUES_ARRAY;
    public static final List<RequestScope> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequestScope[]{REQUEST_LITERAL, SESSION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequestScope get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequestScope result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequestScope getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequestScope result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequestScope get(int value) {
        switch (value) {
            case 0: {
                return REQUEST_LITERAL;
            }
            case 1: {
                return SESSION_LITERAL;
            }
        }
        return null;
    }

    private RequestScope(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

