/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.dialog;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.ResourceChange;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.Images;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.wizards.formbeans.FormBeanWizard;
import com.ibm.etools.struts.wizards.formbeans.IFormBeanRegionData;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FormBeanSelectionDialog
extends SelectionDialog
implements IReferenceListener {
    private TreeViewer listViewer;
    private IProject project;
    private ILink formBeanHandle;
    private final String module;

    public FormBeanSelectionDialog(Shell shell, IProject project, String module) {
        super(shell);
        this.project = project;
        this.module = module;
        this.setTitle(ResourceHandler.FormBeanSelection);
        this.setShellStyle(this.getShellStyle() | 0x10);
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
    }

    public boolean close() {
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout gl = new GridLayout();
        gl.marginWidth = 8;
        gl.marginHeight = 8;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 16384);
        label.setText(ResourceHandler.SelectAFormBean);
        Composite col2 = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        col2.setLayout((Layout)gl);
        col2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.listViewer = new TreeViewer(col2, 2816);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new FormBeanLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)new FormBeanContentProvider(this.module));
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FormBeanSelectionDialog.this.handleDoubleClick();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FormBeanSelectionDialog.this.handleSelectionChanged(event);
            }
        });
        this.listViewer.getTree().setLayoutData((Object)new GridData(1808));
        Composite buttonBar = new Composite(col2, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        buttonBar.setLayoutData((Object)new GridData(2));
        Button newAction = new Button(buttonBar, 0);
        newAction.setText(ResourceHandler.New);
        newAction.setLayoutData((Object)new GridData(1, 1, false, false));
        newAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormBeanWizard wizard = new FormBeanWizard();
                IFormBeanRegionData regionData = (IFormBeanRegionData)wizard.getRegionData();
                regionData.setOpenEditorOnFinish(false);
                regionData.setModuleName(FormBeanSelectionDialog.this.module);
                String packageName = WizardUtils.getDefaultJavaPackageFragmentName(regionData);
                StructuredSelection ss = new StructuredSelection();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
                regionData.setGenerateBacking();
                IVirtualComponent component = Model2Util.findComponent((IResource)FormBeanSelectionDialog.this.project);
                regionData.setComponent(component);
                if (StrutsProjectUtil.getStrutsVersion((IProject)FormBeanSelectionDialog.this.project) >= 1) {
                    Set scLinks;
                    try {
                        scLinks = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)FormBeanSelectionDialog.this.module, null);
                    }
                    catch (ReferenceException ee) {
                        ee.printStackTrace();
                        scLinks = Collections.emptySet();
                    }
                    Collection configFileNames = StrutsSearchUtil.convertPathsToStrings((Collection)StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles((Collection)scLinks)));
                    ArrayList<String> listCnfig = new ArrayList<String>(configFileNames);
                    regionData.setStrutsConfigFileNames(listCnfig);
                    if (!configFileNames.isEmpty()) {
                        String scfn = (String)listCnfig.get(0);
                        WizardUtils.setStrutsConfigFileName(regionData, scfn);
                    }
                }
                regionData.setJavaPackageName(packageName);
                WizardDialog dialog = new WizardDialog(FormBeanSelectionDialog.this.getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    final String formBeanName = wizard.getActionFormRegionData().getFormBeanName();
                    FormBeanSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Set moduleConfigLinks = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)FormBeanSelectionDialog.this.project, (String)FormBeanSelectionDialog.this.module, null);
                            for (ILink configLink : moduleConfigLinks) {
                                ReferenceManager.getReferenceManager().requestChangeAnalysis(new ResourceChange(configLink.getContainer().getResource(), 4), null);
                            }
                            ILink formBeanLink = StrutsSearchUtil.getFormBeanLink((IProject)FormBeanSelectionDialog.this.project, (String)formBeanName, (String)FormBeanSelectionDialog.this.module, null);
                            StructuredSelection sel = new StructuredSelection((Object)formBeanLink);
                            FormBeanSelectionDialog.this.listViewer.refresh();
                            FormBeanSelectionDialog.this.listViewer.setSelection((ISelection)sel, true);
                        }
                    });
                }
            }
        });
        newAction.setLayoutData((Object)new GridData(768));
        this.listViewer.setInput((Object)this.project);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getOkButton().setEnabled(false);
        return control;
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        Object object;
        ISelection selection = event.getSelection();
        ILink newSelected = null;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof ILink) {
            newSelected = (ILink)object;
        }
        this.setResult(Collections.singletonList(newSelected));
        this.formBeanHandle = newSelected;
        Button okButton = this.getOkButton();
        okButton.setEnabled(this.formBeanHandle != null);
    }

    private void handleDoubleClick() {
        if (this.formBeanHandle != null) {
            this.okPressed();
        }
    }

    protected void updateViewer() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FormBeanSelectionDialog.this.listViewer.refresh();
            }
        });
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        for (ReferenceEvent referenceEvent : events) {
            ILink link;
            if (referenceEvent.getReferenceElement().getElementType() != IReferenceElement.ElementType.LINK || !"struts.formbean.link".equals((link = (ILink)referenceEvent.getReferenceElement()).getSpecializedType().getId())) continue;
            this.updateViewer();
            break;
        }
    }

    private static class FormBeanContentProvider
    implements ITreeContentProvider {
        private String mod;

        public FormBeanContentProvider(String module) {
            this.mod = module;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject) {
                IProject project = (IProject)inputElement;
                Set links = Collections.emptySet();
                try {
                    SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)project, (String)this.mod, null);
                    links = StrutsSearchUtil.getAllFormBeans((SearchScope)scope, null);
                }
                catch (ReferenceException referenceException) {
                    links = Collections.emptySet();
                }
                return links.toArray(new ILink[links.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private static class FormBeanLabelProvider
    implements ILabelProvider {
        private FormBeanLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ILink) {
                return Images.getFormBean16();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ILink) {
                return ((ILink)element).getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

