/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.config.file.identifiers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;

public class StrutsActionServletList {
    private ActionServletDataInfo[] actionServletInfos = null;

    public StrutsActionServletList(ActionServletDataInfo[] infoList) {
        this.actionServletInfos = infoList;
    }

    public ActionServletDataInfo getMatchingServletDataInfo(Servlet servlet) {
        if (servlet == null) {
            return null;
        }
        WebType webType = servlet.getWebType();
        if (webType.isServletType()) {
            ServletType servletType = (ServletType)webType;
            String servletClassName = servletType.getClassName();
            if (servletClassName == null) {
                return null;
            }
            ActionServletDataInfo info = this.getExactMatchingServletDataInfo(servlet, servletClassName);
            if (info == null) {
                info = this.getSubclassMatchingServletDataInfoJava(servlet, servletClassName);
            }
            return info;
        }
        return null;
    }

    private ActionServletDataInfo getExactMatchingServletDataInfo(Servlet servlet, String servletClassName) {
        int i = 0;
        while (i < this.actionServletInfos.length) {
            ActionServletDataInfo info = this.actionServletInfos[i];
            if (servletClassName.equals(info.getServletClass())) {
                if (!info.isWrappedServlet()) {
                    return info;
                }
                String initParamWrappedServletValue = this.getParamValue(servlet, info.getInitParamWrappedServlet());
                if (initParamWrappedServletValue != null && initParamWrappedServletValue.equals(info.getWrappedServletClass())) {
                    return info;
                }
            }
            ++i;
        }
        return null;
    }

    private ActionServletDataInfo getSubclassMatchingServletDataInfoJava(Servlet servlet, String servletClassName) {
        JavaClass servletClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(servletClassName, (EObject)servlet);
        if (servletClass == null) {
            return null;
        }
        int i = 0;
        while (i < this.actionServletInfos.length) {
            ActionServletDataInfo info = this.actionServletInfos[i];
            JavaClass actionServletInfoClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(info.getServletClass(), (EObject)servlet);
            if (actionServletInfoClass != null && servletClass.inheritsFrom(actionServletInfoClass)) {
                if (!info.isWrappedServlet()) {
                    return info;
                }
                String initParamWrappedServletValue = this.getParamValue(servlet, info.getInitParamWrappedServlet());
                if (initParamWrappedServletValue != null) {
                    if (initParamWrappedServletValue.equals(info.getWrappedServletClass())) {
                        return info;
                    }
                    JavaClass wrappedParamValueClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(initParamWrappedServletValue, (EObject)servlet);
                    if (wrappedParamValueClass != null && servletClass.inheritsFrom(wrappedParamValueClass)) {
                        return info;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private String getParamValue(Servlet servlet, String paramName) {
        return servlet.getParamsAsProperties().getProperty(paramName);
    }

    public static class ActionServletDataInfo {
        public String servletClass;
        public String initParamServletMapping;
        public String wrappedServletClass;
        public String initParamWrappedServlet;

        public ActionServletDataInfo(String servletClass, String initParamServletMapping, String wrappedServletClass, String initParamWrappedServlet) {
            this.servletClass = servletClass;
            this.initParamServletMapping = initParamServletMapping;
            this.wrappedServletClass = wrappedServletClass;
            this.initParamWrappedServlet = initParamWrappedServlet;
        }

        public boolean isWrappedServlet() {
            return this.wrappedServletClass != null;
        }

        public String getServletClass() {
            return this.servletClass;
        }

        public String getInitParamServletMapping() {
            return this.initParamServletMapping;
        }

        public String getWrappedServletClass() {
            return this.wrappedServletClass;
        }

        public String getInitParamWrappedServlet() {
            return this.initParamWrappedServlet;
        }
    }
}

