/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.cache;

import com.ibm.etools.struts.StrutsPlugin;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SubClassLookupCache {
    private static HashMap<IVirtualComponent, SubClassLookupCache> cacheManagers = new HashMap();
    private boolean completeCache = false;
    private HashSet<String> allCache = null;
    private HashMap<String, HashSet<String>> isSubclassCache = null;
    private HashMap<String, HashSet<String>> notSubclassCache = null;
    private IVirtualComponent component = null;

    public static SubClassLookupCache getSubClassLookupCache(IVirtualComponent component, boolean create) {
        SubClassLookupCache cache = cacheManagers.get(component);
        if (cache == null && create) {
            cache = new SubClassLookupCache(component);
            cacheManagers.put(component, cache);
        }
        return cache;
    }

    public static boolean isSubclass(IVirtualComponent component, String class1, String parentClass) {
        SubClassLookupCache cache = SubClassLookupCache.getSubClassLookupCache(component, true);
        if (cache == null) {
            return true;
        }
        return cache.isSubclass(class1, parentClass);
    }

    public static boolean isCachValid(IVirtualComponent component) {
        SubClassLookupCache cache = cacheManagers.get(component);
        if (cache == null) {
            return false;
        }
        return cache.completeCache;
    }

    public static boolean isReferencedClass(IVirtualComponent component, String className) {
        SubClassLookupCache cache = cacheManagers.get(component);
        if (cache != null && cache.allCache != null) {
            return cache.allCache.contains(className);
        }
        return false;
    }

    private SubClassLookupCache(IVirtualComponent component) {
        this.component = component;
    }

    public boolean isSubclass(String class1, String parentClass) {
        if (class1 == null || parentClass == null) {
            return true;
        }
        if (this.allCache == null) {
            this.allCache = new HashSet();
        }
        this.allCache.add(class1);
        if (this.isContained(this.isSubclassCache, class1, parentClass)) {
            return true;
        }
        if (this.isContained(this.notSubclassCache, class1, parentClass)) {
            return false;
        }
        if (this.isValidSubClass(class1, parentClass)) {
            this.isSubclassCache = this.addToCache(this.isSubclassCache, class1, parentClass);
            return true;
        }
        this.notSubclassCache = this.addToCache(this.notSubclassCache, class1, parentClass);
        return false;
    }

    private boolean isValidSubClass(String class1, String parentClass) {
        block7: {
            IJavaProject javaProject;
            if (parentClass == null || parentClass.length() == 0) {
                return true;
            }
            if (parentClass.equals(class1)) {
                return true;
            }
            IProject project = this.component.getProject();
            if (this.isValidProject(project) && (javaProject = JavaCore.create((IProject)project)) != null) {
                IType targetClassType;
                block6: {
                    targetClassType = javaProject.findType(class1);
                    if (targetClassType != null) break block6;
                    return true;
                }
                try {
                    return this.isExtenderOf(targetClassType, parentClass);
                }
                catch (JavaModelException jme) {
                    if (!this.isValidProject(project)) break block7;
                    StrutsPlugin.getLogger().log((Throwable)jme);
                }
            }
        }
        return true;
    }

    private boolean isValidProject(IProject project) {
        return project != null && project.exists() && project.isAccessible();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExtenderOf(IType targetClass, String parentClass) {
        if (targetClass.getFullyQualifiedName().equals(parentClass)) {
            return true;
        }
        try {
            ITypeHierarchy hierarchy = targetClass.newSupertypeHierarchy(null);
            IType[] superclasses = hierarchy.getAllSuperclasses(targetClass);
            int i = 0;
            while (true) {
                if (i >= superclasses.length) {
                    return false;
                }
                if (superclasses[i].getFullyQualifiedName().equals(parentClass)) {
                    this.addTypeHierarchy(i, superclasses);
                    return true;
                }
                if (superclasses[i].getUnderlyingResource() != null && superclasses[i].getUnderlyingResource().getFileExtension().equals(".java")) {
                    this.allCache.add(superclasses[i].getFullyQualifiedName());
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            StrutsPlugin.getLogger().log((Throwable)jme);
        }
        return false;
    }

    private void addTypeHierarchy(int i, IType[] superclasses) {
        int j = 0;
        while (j < i) {
            this.allCache.add(superclasses[i].getFullyQualifiedName());
            ++j;
        }
    }

    public void markValidateAll() {
        this.isSubclassCache = null;
        this.notSubclassCache = null;
        this.completeCache = true;
    }

    public void dispose() {
        this.isSubclassCache = null;
        this.notSubclassCache = null;
        this.allCache = null;
        this.completeCache = false;
    }

    private boolean isContained(HashMap<String, HashSet<String>> cache, String class1, String parentClass) {
        HashSet<String> cachedSubclass;
        if (cache != null && (cachedSubclass = cache.get(parentClass)) != null) {
            return cachedSubclass.contains(class1);
        }
        return false;
    }

    private HashMap<String, HashSet<String>> addToCache(HashMap<String, HashSet<String>> cache, String class1, String parentClass) {
        HashSet<String> cachedSubclass;
        if (cache == null) {
            cache = new HashMap();
        }
        if ((cachedSubclass = cache.get(parentClass)) == null) {
            cachedSubclass = new HashSet();
            cache.put(parentClass, cachedSubclass);
        }
        cachedSubclass.add(class1);
        return cache;
    }
}

