/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.security.internal.resource.provider;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.IStrutsConstants;
import com.ibm.etools.struts.Images;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.security.internal.nodes.StrutsActionNode;
import com.ibm.etools.struts.security.internal.nodes.StrutsModuleNode;
import com.ibm.etools.struts.security.internal.nodes.StrutsResourceNode;
import com.ibm.etools.struts.security.internal.nodes.StrutsSubParentNode;
import com.ibm.etools.struts.security.internal.wrappers.StrutsActionWrapper;
import com.ibm.etools.struts.security.internal.wrappers.StrutsModuleWrapper;
import com.ibm.etools.struts.security.internal.wrappers.StrutsSecurityWrapper;
import com.ibm.etools.struts.security.internal.wrappers.StrutsSubParentWrapper;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ISecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.resource.providers.ResourceNode;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceProvider;
import com.ibm.etools.webtools.security.base.internal.resource.providers.SecurityResourceWrapper;
import com.ibm.etools.webtools.security.base.internal.util.SecurityUtilities;
import com.ibm.etools.webtools.security.web.internal.resource.provider.WebModuleResourceWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsSecurityResourceProvider
extends SecurityResourceProvider {
    public List getAllChildResourcesFor(SecurityResourceWrapper resourceWrapper) {
        if (!(resourceWrapper instanceof WebModuleResourceWrapper)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WebModuleResourceWrapper> result = new ArrayList<WebModuleResourceWrapper>();
        WebModuleResourceWrapper parent = (WebModuleResourceWrapper)resourceWrapper;
        ISecurityResourceWrapper seed = this.findSeed((ISecurityResourceWrapper)parent);
        if (!(seed instanceof WebModuleResourceWrapper)) {
            return Collections.EMPTY_LIST;
        }
        IModelProvider webEdit = ((WebModuleResourceWrapper)seed).getWebEdit();
        if (resourceWrapper == seed) {
            IVirtualComponent virtualComponent = ComponentCore.createComponent((IProject)ProjectUtilities.getProject((Object)webEdit.getModelObject()));
            Servlet servlet = (Servlet)ConfigFileIdentifierQuizMaster.getStrutsActionServlet((IVirtualComponent)virtualComponent);
            StrutsSubParentWrapper wrapper = new StrutsSubParentWrapper(servlet, null, webEdit);
            wrapper.setLabel(ResourceHandler.Category_StrutsGroup_Label);
            wrapper.setImage(Images.getActionMapping16());
            wrapper.setParent((ISecurityResourceWrapper)parent);
            result.add(wrapper);
        } else if (resourceWrapper instanceof StrutsSubParentWrapper) {
            try {
                Set modules = StrutsSearchUtil.getModulesForProject((IProject)ProjectUtilities.getProject((Object)webEdit.getModelObject()), null);
                for (String moduleName : modules) {
                    Set links = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)ProjectUtilities.getProject((Object)webEdit.getModelObject()), (String)moduleName, null);
                    String label = moduleName;
                    if (label == null) {
                        label = "";
                    }
                    if (label.length() == 0) {
                        label = IStrutsConstants.DEFAULTMODULE;
                    }
                    StrutsModuleWrapper moduleWrapper = new StrutsModuleWrapper(moduleName, moduleName, parent.getWebEdit(), links);
                    moduleWrapper.setLabel(label);
                    moduleWrapper.setImage(Images.getModule16());
                    moduleWrapper.setParent((ISecurityResourceWrapper)parent);
                    result.add(moduleWrapper);
                }
            }
            catch (ReferenceException e) {
                e.printStackTrace();
            }
        } else if (resourceWrapper instanceof StrutsModuleWrapper) {
            Set<ILink> actionMappingHandles = ((StrutsModuleWrapper)resourceWrapper).getActionsHandles();
            for (ILink amh : actionMappingHandles) {
                StrutsActionWrapper actionWrapper = new StrutsActionWrapper(amh, amh.getName(), parent.getWebEdit());
                actionWrapper.setLabel(amh.getName());
                actionWrapper.setImage(Images.getActionMapping16());
                actionWrapper.setParent((ISecurityResourceWrapper)parent);
                result.add(actionWrapper);
            }
        }
        return result;
    }

    public ResourceNode generateNodeForWrapper(SecurityResourceWrapper wrapper, IProject project) {
        StrutsResourceNode result = null;
        if (wrapper instanceof StrutsSubParentWrapper) {
            result = new StrutsSubParentNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project);
        } else if (wrapper instanceof StrutsModuleWrapper) {
            result = new StrutsModuleNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project);
        } else if (wrapper instanceof StrutsActionWrapper) {
            result = new StrutsActionNode(wrapper.getImage(), wrapper.getLabel(), wrapper, project);
        }
        return result;
    }

    public boolean patternMatch(String pattern, SecurityResourceWrapper target) {
        return this.patternMatch(pattern, target);
    }

    public boolean patternMatch(Object pattern, SecurityResourceWrapper target) {
        String stringPattern = null;
        if (pattern instanceof String) {
            stringPattern = (String)pattern;
        } else if (pattern instanceof UrlPatternType) {
            stringPattern = ((UrlPatternType)pattern).getValue();
        }
        boolean match = false;
        if (target instanceof StrutsModuleWrapper || target instanceof StrutsSecurityWrapper) {
            List urlPatterns = target.getURLPatterns();
            Iterator iter = urlPatterns.iterator();
            while (iter.hasNext() && !match) {
                String urlPattern = (String)iter.next();
                if (stringPattern.toUpperCase().equals(urlPattern.toUpperCase())) {
                    match = true;
                    continue;
                }
                if (!SecurityUtilities.isValidWildCard((String)stringPattern)) continue;
                int index = stringPattern.indexOf("*");
                String pre = null;
                if (index > 0) {
                    pre = stringPattern.substring(0, index);
                }
                String post = null;
                if (index + 1 < stringPattern.length()) {
                    post = stringPattern.substring(index + 1, stringPattern.length());
                }
                if (target instanceof StrutsModuleWrapper) {
                    if (pre != null && !urlPattern.equals(pre) || post != null && !urlPattern.endsWith(post)) continue;
                    match = true;
                    continue;
                }
                String[] split = urlPattern.split("/");
                String before = "";
                int i = 0;
                while (i < split.length) {
                    String string = split[i];
                    int pos = string.indexOf(".do");
                    if (pos == -1) {
                        before = String.valueOf(before) + string + "/";
                    }
                    ++i;
                }
                if (!stringPattern.startsWith(before) && !stringPattern.startsWith("*") || pre != null && !urlPattern.startsWith(pre) || post != null && !urlPattern.endsWith(post)) continue;
                match = true;
            }
        }
        return match;
    }
}

