/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.runtimes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Runtimes
extends Plugin {
    private static final String RuntimesFolder = "runtimes";
    private static final String DigestsFolder = "digests";
    private static final String OverrideFolder = "override";
    private static final String MD5Extension = ".MD5";
    private static final String VersionsProperties = "runtimes/versions.properties";
    private static Runtimes Instance;
    private Map<String, String> versionMap;
    private List<String> versions;
    private Map<IPath, byte[]> md5Cache = new HashMap<IPath, byte[]>();
    private static final byte[] NullDigest;

    static {
        NullDigest = new byte[0];
    }

    public static Runtimes getDefault() {
        return Instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        Instance = null;
        super.stop(context);
    }

    public InputStream openStream(String basicVersion, String fileName) throws IOException {
        InputStream stream = null;
        IPath filePath = this.getPath(RuntimesFolder, true, basicVersion, fileName);
        if (filePath != null) {
            try {
                stream = FileLocator.openStream((Bundle)this.getBundle(), (IPath)filePath, (boolean)false);
            }
            catch (IOException iOException) {}
        }
        if (stream == null && (filePath = this.getPath(RuntimesFolder, false, basicVersion, fileName)) != null) {
            stream = FileLocator.openStream((Bundle)this.getBundle(), (IPath)filePath, (boolean)false);
        }
        return stream;
    }

    private IPath getPath(String folder, boolean override, String basicVersion, String fileName) {
        String resolvedVersion = this.getResolvedVersion(basicVersion);
        if (resolvedVersion != null) {
            Path path = Path.EMPTY;
            if (folder != null) {
                path = path.append(folder);
            }
            path = path.append(resolvedVersion);
            if (override) {
                path = path.append(OverrideFolder);
            }
            return path.append(fileName);
        }
        return null;
    }

    public byte[] getDigest(boolean override, String basicVersion, String fileName) throws IOException {
        IPath path = this.getPath(null, override, basicVersion, fileName);
        byte[] value = this.md5Cache.get(path);
        if (value == null) {
            value = this.readDigest(override, basicVersion, fileName);
            this.md5Cache.put(path, value);
        }
        if (value == NullDigest) {
            value = null;
        }
        return value;
    }

    private byte[] readDigest(boolean override, String basicVersion, String fileName) throws IOException {
        IPath path = this.getPath(DigestsFolder, override, basicVersion, String.valueOf(fileName) + MD5Extension);
        InputStream stream = null;
        try {
            stream = FileLocator.openStream((Bundle)this.getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            return NullDigest;
        }
        try {
            InputStreamReader reader = new InputStreamReader(stream);
            byte[] digest = new byte[16];
            int i = 0;
            while (i < digest.length) {
                int c1 = ((Reader)reader).read();
                int c0 = ((Reader)reader).read();
                if (c1 == -1 || c0 == -1) {
                    return null;
                }
                int d1 = Character.digit(c1, 16);
                int d0 = Character.digit(c0, 16);
                if (d1 == -1 || d0 == -1) {
                    return null;
                }
                digest[i] = (byte)(d1 << 4 | d0);
                ++i;
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    private String getResolvedVersion(String basicVersion) {
        return this.getVersionMap().get(basicVersion);
    }

    public List<String> getVersions() {
        if (this.versions == null) {
            Set<String> set = this.getVersionMap().keySet();
            ArrayList<String> list = new ArrayList<String>(set);
            Collections.sort(list);
            this.versions = Collections.unmodifiableList(list);
        }
        return this.versions;
    }

    private Map<String, String> getVersionMap() {
        if (this.versionMap == null) {
            this.versionMap = new HashMap<String, String>();
            InputStream stream = null;
            try {
                try {
                    stream = FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path(VersionsProperties), (boolean)false);
                    PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
                    Enumeration<String> keys = ((ResourceBundle)bundle).getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        this.versionMap.put(key, bundle.getString(key));
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.versionMap;
    }
}

