/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model.command;

import com.ibm.etools.siteedit.internal.core.util.SiteModelResUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteValidateEditUtil;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelManager;
import com.ibm.etools.siteedit.site.model.command.SiteCommandStack;
import com.ibm.etools.siteedit.site.model.command.SiteCommandUtil;
import com.ibm.etools.siteedit.site.model.command.SiteCommandValidator;
import com.ibm.etools.siteedit.site.model.command.SiteValidateEditCommand;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;

class SiteValidateEditCommandValidator
implements SiteCommandValidator {
    SiteValidateEditCommandValidator() {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean validate(Command command, final int state) {
        final DataImpl result = new DataImpl();
        SiteCommandUtil.accept(command, new SiteCommandUtil.Visitor(){

            @Override
            public boolean visit(Command command) {
                if (command instanceof SiteValidateEditCommand) {
                    ((SiteValidateEditCommand)command).notifyCollectingValidateEditData(result, state);
                }
                return true;
            }
        });
        ArrayList resources = result.getResources();
        if (resources.isEmpty()) {
            return true;
        }
        Collections.sort(resources, new Comparator(){
            private Collator collator = Collator.getInstance();

            public int compare(Object o1, Object o2) {
                return this.collator.compare(((IFile)o1).getFullPath().toString(), ((IFile)o2).getFullPath().toString());
            }
        });
        if (SiteCommandStack._isTracing()) {
            SiteCommandStack._trace("Validate Edit Target Resources: " + resources);
        }
        return SiteValidateEditUtil.handleValidateReadOnly((IFile[])resources.toArray(new IFile[resources.size()]));
    }

    class DataImpl
    implements SiteValidateEditCommand.Data {
        private final HashSet data = new HashSet(2);
        private final HashSet siteModel = new HashSet(2);

        DataImpl() {
        }

        @Override
        public void addAsSiteNavigation(SiteComponent sc) {
            if (sc == null) {
                return;
            }
            this.siteModel.add(sc.getSiteModel());
        }

        @Override
        public void addAsResrouce(SiteComponent sc) {
            IFile file = SiteModelResUtil.getIFile(sc, false);
            if (file != null) {
                this.data.add(file);
            }
        }

        public ArrayList getResources() {
            ArrayList<IFile> result = new ArrayList<IFile>(this.data);
            for (SiteModel site : this.siteModel) {
                SiteModelContainer smc = SiteModelManager.getDefault().findModelContainerForTemp(site);
                if (smc == null || result.contains(smc.getFile())) continue;
                result.add(smc.getFile());
            }
            return result;
        }
    }
}

