/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model.command;

import com.ibm.etools.siteedit.internal.core.util.SiteSubProjectUtil2;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.command.SiteSubProjectUtil;
import com.ibm.etools.siteedit.site.model.command.SiteValidateEditCommand;
import org.eclipse.gef.commands.Command;

abstract class AbstractModifySiteTreeCommand
extends Command
implements SiteValidateEditCommand {
    public AbstractModifySiteTreeCommand() {
    }

    public AbstractModifySiteTreeCommand(String label) {
        super(label);
    }

    protected void addCore(SiteComponent target, SiteComponent[] ins, int direction) {
        if (direction == 0) {
            int i = 0;
            while (i < ins.length) {
                target.appendChild(ins[i]);
                ++i;
            }
        } else if (direction == 1) {
            int i = 0;
            while (i < ins.length) {
                target.getParent().addChildBefore(target, ins[i]);
                ++i;
            }
        } else if (direction == 2) {
            int i = ins.length - 1;
            while (i >= 0) {
                target.getParent().addChildAfter(target, ins[i]);
                --i;
            }
        }
        this.getSubProjectUtil().modifyReferencesToAdd(target, ins);
    }

    protected RemoveOps removeCore(SiteComponent[] remove) {
        RemoveOps ro = new RemoveOps(remove);
        if (remove != null && remove.length > 0) {
            this.getSubProjectUtil().modifyReferencesToRemove(remove[0], remove);
            ro.remove();
        }
        return ro;
    }

    protected void undoRemoveCore(RemoveOps ro) {
        SiteComponent[] ins = ro.getSiteComponents();
        if (ins.length > 0) {
            ro.undo();
            this.getSubProjectUtil().modifyReferencesToAdd(ro.getSiteModel(), ins);
        }
    }

    protected SiteSubProjectUtil getSubProjectUtil() {
        return new SiteSubProjectUtil2();
    }

    private static class RemoveOp {
        private final SiteComponent removed;
        private SiteComponent parent;
        private SiteComponent nextTo;

        RemoveOp(SiteComponent removeThis) {
            this.removed = removeThis;
            this.parent = removeThis.getParent();
            int index = this.parent.indexOf(removeThis);
            this.nextTo = index <= 0 ? null : this.parent.getChildAt(index - 1);
        }

        void remove() {
            this.parent = this.removed.getParent();
            if (this.parent == null) {
                return;
            }
            int index = this.parent.indexOf(this.removed);
            this.nextTo = index <= 0 ? null : this.parent.getChildAt(index - 1);
            this.parent.removeChildAt(index);
        }

        void undo() {
            if (this.parent == null) {
                return;
            }
            if (this.nextTo == null) {
                this.parent.addChildAt(0, this.removed);
            } else {
                this.parent.addChildAfter(this.nextTo, this.removed);
            }
        }

        SiteComponent getSiteComponent() {
            return this.removed;
        }
    }

    protected static class RemoveOps {
        private final RemoveOp[] removeOps;

        RemoveOps(SiteComponent[] sc) {
            if (sc != null) {
                this.removeOps = new RemoveOp[sc.length];
                int i = 0;
                while (i < sc.length) {
                    this.removeOps[i] = new RemoveOp(sc[i]);
                    ++i;
                }
            } else {
                this.removeOps = new RemoveOp[0];
            }
        }

        void remove() {
            int i = 0;
            while (i < this.removeOps.length) {
                this.removeOps[i].remove();
                ++i;
            }
        }

        void undo() {
            int i = this.removeOps.length - 1;
            while (i >= 0) {
                this.removeOps[i].undo();
                --i;
            }
        }

        public SiteComponent[] getSiteComponents() {
            SiteComponent[] result = new SiteComponent[this.removeOps.length];
            int i = 0;
            while (i < this.removeOps.length) {
                result[i] = this.removeOps[i].getSiteComponent();
                ++i;
            }
            return result;
        }

        public SiteComponent getSiteModel() {
            return this.removeOps == null || this.removeOps.length == 0 ? null : this.removeOps[0].parent.getSiteModel();
        }
    }
}

