/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model.command;

import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModelConstraint;
import com.ibm.etools.siteedit.site.model.SiteModelUtil2;
import com.ibm.etools.siteedit.site.model.command.AbstractModifySiteTreeCommand;
import com.ibm.etools.siteedit.site.model.command.SiteInteractiveCommand;
import com.ibm.etools.siteedit.site.model.command.SiteValidateEditCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractDeleteSiteComponentCommand
extends AbstractModifySiteTreeCommand
implements SiteInteractiveCommand {
    private AbstractModifySiteTreeCommand.RemoveOps done;

    public AbstractDeleteSiteComponentCommand() {
    }

    public AbstractDeleteSiteComponentCommand(String label) {
        super(label);
    }

    protected abstract SiteComponent[] getDeletionComponents();

    public boolean canExecute() {
        SiteComponent[] remove = this.getDeletionRoots();
        if (remove == null) {
            return false;
        }
        int i = 0;
        while (i < remove.length) {
            SiteComponent c = remove[i];
            if (c == null) {
                return false;
            }
            if (!SiteModelConstraint.canDelete(c)) {
                return false;
            }
            ++i;
        }
        return super.canExecute();
    }

    public void execute() {
        this.done = this.removeCore(this.getDeletionRoots());
    }

    public void undo() {
        this.undoRemoveCore(this.done);
    }

    public void redo() {
        this.done = this.removeCore(this.done.getSiteComponents());
    }

    @Override
    public boolean confirmExec(int state, Object shell) {
        if (state == 1 || state == 3) {
            SiteComponent[] del = null;
            if (state == 1) {
                del = this.getDeletionRoots();
            }
            if (state == 3) {
                del = this.done.getSiteComponents();
            }
            if (del == null) {
                return false;
            }
            return del.length > 0 && this.getSubProjectUtil().confirmToRemove(del[0], del, shell);
        }
        if (state == 2) {
            SiteComponent[] add = this.done.getSiteComponents();
            return add.length > 0 && this.getSubProjectUtil().confirmToAdd(add[0], add, shell);
        }
        return false;
    }

    public SiteComponent[] getDeletionRoots() {
        if (this.done == null) {
            SiteComponent[] remove = this.getDeletionComponents();
            if (!SiteModelUtil2.isValidComponentArray(remove)) {
                return null;
            }
            ArrayList<SiteComponent> ar = new ArrayList<SiteComponent>(Arrays.asList(remove));
            List result = SiteModelUtil2.calcurateRootsForRemove(ar);
            return result.toArray(new SiteComponent[result.size()]);
        }
        return this.done.getSiteComponents();
    }

    @Override
    public boolean notifyCollectingValidateEditData(SiteValidateEditCommand.Data data, int state) {
        if (state == 1 || state == 3) {
            SiteComponent[] del = null;
            if (state == 1) {
                del = this.getDeletionRoots();
            }
            if (state == 3) {
                del = this.done.getSiteComponents();
            }
            if (del == null) {
                return false;
            }
            if (del.length > 0) {
                data.addAsSiteNavigation(del[0]);
            }
            return true;
        }
        if (state == 2) {
            SiteComponent[] add = this.done.getSiteComponents();
            if (add.length > 0) {
                data.addAsSiteNavigation(add[0]);
            }
            return true;
        }
        return false;
    }
}

