/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.ParsingException;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelContainerListener;
import com.ibm.etools.siteedit.site.model.SiteModelDumper;
import com.ibm.etools.siteedit.site.model.SiteModelListener;
import com.ibm.etools.siteedit.site.model.SiteModelLoader;
import com.ibm.etools.siteedit.site.model.SiteXmlStrings;
import com.ibm.etools.siteedit.site.model.command.SiteCommandStack;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class SiteModelManager
implements SiteXmlStrings,
IResourceChangeListener {
    private static final String TRACE_KEY = "model/manager";
    private ArrayList modelContainers = new ArrayList(5);

    public SiteModelManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public SiteModelContainer getModelContainerForTemp(IVirtualComponent component) {
        IFile siteXml = WebComponentUtil.getActiveWebSiteConfigFile(component);
        return this.getBasicModelContainer(siteXml, false);
    }

    public SiteModelContainer getModelContainerForEdit(IFile file) {
        BaseSiteModelContainer basicContainer = this.getBasicModelContainer(file, true);
        if (basicContainer != null) {
            return new SiteModelContainerDelegate(basicContainer, true);
        }
        return null;
    }

    public SiteModelContainer getModelContainerForEdit(IVirtualComponent component) {
        IFile siteXml = WebComponentUtil.getWebSiteConfigFile(component);
        return this.getModelContainerForEdit(siteXml);
    }

    public SiteModelContainer getModelContainerForRead(IFile file) {
        BaseSiteModelContainer basicContainer = this.getBasicModelContainer(file, true);
        if (basicContainer != null) {
            return new SiteModelContainerDelegate(basicContainer, false);
        }
        return null;
    }

    public SiteModelContainer getModelContainerForRead(IVirtualComponent component) {
        IFile siteXml = WebComponentUtil.getActiveWebSiteConfigFile(component);
        return this.getModelContainerForRead(siteXml);
    }

    public SiteModelContainer findModelContainerForRead(SiteModel siteModel) {
        BaseSiteModelContainer basicContainer = this.findBasicModelContainer(siteModel);
        if (basicContainer != null) {
            return new SiteModelContainerDelegate(basicContainer, false);
        }
        return null;
    }

    public SiteModelContainer findModelContainerForTemp(SiteModel siteModel) {
        return this.findBasicModelContainer(siteModel);
    }

    protected synchronized BaseSiteModelContainer getBasicModelContainer(IFile file, boolean bCreate) {
        if (file == null) {
            return null;
        }
        for (BaseSiteModelContainer e : this.modelContainers) {
            if (!e.siteXml.equals((Object)file)) continue;
            return e;
        }
        if (bCreate) {
            IVirtualComponent component = WebComponentUtil.findComponentFromWebSiteConfig((IResource)file);
            BaseSiteModelContainer result = new BaseSiteModelContainer(component, file);
            this.modelContainers.add(result);
            if (SiteModelManager._isTracing()) {
                SiteModelManager._trace("SiteModelManager: new model container for " + file + " is created.");
            }
            return result;
        }
        return null;
    }

    protected synchronized void releaseModelContainer(BaseSiteModelContainer container) {
        if (SiteModelManager._isTracing()) {
            SiteModelManager._trace("SiteModelManager: release container for " + container.getFile() + ".");
        }
        this.modelContainers.remove(container);
    }

    protected synchronized BaseSiteModelContainer findBasicModelContainer(SiteModel siteModel) {
        for (BaseSiteModelContainer e : this.modelContainers) {
            if (e.getSiteModel() != siteModel) continue;
            return e;
        }
        return null;
    }

    public void dispose() {
    }

    public static SiteModelManager getDefault() {
        return SiteCorePlugin.getDefault().getSiteModelManager();
    }

    static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    static boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getResource() instanceof IProject && event.getType() == 4) {
            SiteModelManager siteModelManager = this;
            synchronized (siteModelManager) {
                IProject project = (IProject)event.getResource();
                IFile file = project.getFile(".website-config");
                BaseSiteModelContainer baseCont = this.getBasicModelContainer(file, false);
                if (baseCont != null) {
                    baseCont.referenceCountForEdit = 0;
                    baseCont.referenceCountForRead = 0;
                    baseCont.internalRelease();
                }
            }
        }
    }

    protected class BaseSiteModelContainer
    implements SiteModelContainer {
        protected SiteModel model;
        protected CommandStack commandStack = new SiteCommandStack();
        protected IFile siteXml;
        protected IVirtualComponent component;
        protected long modificationStamp;
        protected boolean isSaving;
        protected int referenceCountForEdit;
        protected int referenceCountForRead;
        protected HashMap adapterFactoriesManager = new HashMap();
        protected HashMap adapterFactories = new HashMap();
        protected HashSet containerListeners = new HashSet();
        protected HashSet modelListeners = new HashSet();
        protected static final int PRE_REPLACED = 1;
        protected static final int POST_REPLACED = 2;
        protected static final int PRE_SAVE = 3;
        protected static final int POST_SAVE = 4;
        protected static final int PRE_DISPOSE = 5;

        public BaseSiteModelContainer(IVirtualComponent component, IFile siteXml) {
            this.siteXml = siteXml;
            this.component = component;
            if (siteXml.exists()) {
                try {
                    this.model = SiteModelLoader.createSite(siteXml.getLocation().toOSString());
                }
                catch (ParsingException e) {
                    Logger.log(e);
                    throw new IllegalArgumentException();
                }
            }
            if (this.model == null) {
                this.model = new SiteModel();
            }
            this.resetSynchronizationStamp();
            if (!Logger.isDebugging()) {
                final SiteModelContainerDelegate aa = new SiteModelContainerDelegate(this, false);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            1.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                        aa.release();
                    }
                }.start();
            }
        }

        @Override
        public SiteModel getSiteModel() {
            return this.model;
        }

        @Override
        public CommandStack getCommandStack() {
            return this.commandStack;
        }

        @Override
        public boolean isDirty() {
            return this.commandStack != null && this.commandStack.isDirty();
        }

        @Override
        public boolean isSharedForEdit() {
            return this.referenceCountForEdit > 1;
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean save(IProgressMonitor monitor) {
            block11: {
                if (this.isSaving) {
                    return false;
                }
                this.notifyListeners(3);
                try {
                    this.isSaving = true;
                    this.getCommandStack().markSaveLocation();
                    IDOMModel xml = this.getXMLModelToDump();
                    try {
                        SiteModelDumper dumper = SiteModelDumper.create((Document)xml.getDocument(), "700");
                        this.getSiteModel().accept(dumper);
                        SiteXmlDocumentUtil.saveDocument((Document)xml.getDocument(), this.siteXml, monitor);
                        return true;
                    }
                    catch (Exception e) {
                        Logger.log(e);
                        if (monitor != null) {
                            monitor.setCanceled(true);
                        }
                        break block11;
                    }
                    finally {
                        xml.releaseFromEdit();
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.notifyListeners(4);
                    this.isSaving = false;
                }
            }
            return false;
        }

        private IDOMModel getXMLModelToDump() {
            IModelManager mm = SiteModelUtil.getModelManager();
            IStructuredModel result = null;
            try {
                result = mm.getModelForEdit(this.getFile());
            }
            catch (IOException e) {
                Logger.log(e);
            }
            catch (CoreException e) {
                Logger.log(e);
            }
            if (result == null) {
                try {
                    result = mm.getNewModelForEdit(this.getFile(), true);
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
            return (IDOMModel)result;
        }

        @Override
        public void installAdapterFactory(Class adapterFactory) {
            if (!IAdapterFactory.class.isAssignableFrom(adapterFactory)) {
                throw new IllegalArgumentException();
            }
            if (!this.adapterFactories.containsKey(adapterFactory)) {
                IAdapterFactory factory = null;
                try {
                    Constructor c = adapterFactory.getConstructor(SiteModelContainer.class);
                    factory = (IAdapterFactory)c.newInstance(this);
                }
                catch (Exception exception) {
                    try {
                        Constructor c = adapterFactory.getConstructor(new Class[0]);
                        factory = (IAdapterFactory)c.newInstance(this);
                    }
                    catch (Exception exception2) {}
                }
                if (factory == null) {
                    throw new IllegalArgumentException("Cannot create an instance for " + adapterFactory);
                }
                this.adapterFactories.put(adapterFactory, factory);
                this.adapterFactoriesManager.put(adapterFactory, new Integer(0));
            }
            Integer prevRef = (Integer)this.adapterFactoriesManager.get(adapterFactory);
            this.adapterFactoriesManager.put(adapterFactory, new Integer(prevRef + 1));
        }

        public void uninstallAdapterFactory(Class adapterFactory) {
            if (!IAdapterFactory.class.isAssignableFrom(adapterFactory)) {
                throw new IllegalArgumentException();
            }
            if (!this.adapterFactoriesManager.containsKey(adapterFactory)) {
                throw new IllegalArgumentException();
            }
            Integer prevRef = (Integer)this.adapterFactoriesManager.get(adapterFactory);
            this.adapterFactoriesManager.put(adapterFactory, new Integer(prevRef - 1));
            if (prevRef <= 1) {
                this.adapterFactoriesManager.remove(adapterFactory);
            }
        }

        @Override
        public void release() {
        }

        public synchronized void getForEdit() {
            ++this.referenceCountForEdit;
            if (SiteModelManager._isTracing()) {
                SiteModelManager._trace("SiteModelManager: EDIT reference INCreased: " + this);
            }
        }

        public synchronized void relaseFromEdit() {
            --this.referenceCountForEdit;
            this.internalRelease();
            if (SiteModelManager._isTracing()) {
                SiteModelManager._trace("SiteModelManager: EDIT reference DECleased: " + this);
            }
        }

        public synchronized void getForRead() {
            ++this.referenceCountForRead;
            if (SiteModelManager._isTracing()) {
                SiteModelManager._trace("SiteModelManager: READ reference INCreased: " + this);
            }
        }

        public synchronized void releaseFromRead() {
            --this.referenceCountForRead;
            this.internalRelease();
            if (SiteModelManager._isTracing()) {
                SiteModelManager._trace("SiteModelManager: READ reference DECreased: " + this);
            }
        }

        private void internalRelease() {
            if (this.referenceCountForEdit > 0 || this.referenceCountForRead > 0) {
                return;
            }
            if (this.commandStack != null) {
                this.getCommandStack().dispose();
                this.commandStack = null;
            }
            if (!this.adapterFactories.isEmpty()) {
                Logger.log("Following adapter factories are not released: " + this.adapterFactoriesManager.toString());
                Iterator it = this.adapterFactories.values().iterator();
                while (it.hasNext()) {
                }
            }
            SiteModelManager.this.releaseModelContainer(this);
        }

        @Override
        public IVirtualComponent getComponent() {
            return this.component;
        }

        @Override
        public IFile getFile() {
            return this.siteXml;
        }

        private long calcurateSynchronizationStamp() {
            long a = this.siteXml.getLocalTimeStamp();
            long b = this.siteXml.getModificationStamp();
            return a ^ b;
        }

        @Override
        public void resetSynchronizationStamp() {
            this.modificationStamp = this.calcurateSynchronizationStamp();
        }

        @Override
        public boolean isSynchronizationStampUpdated() {
            return this.calcurateSynchronizationStamp() != this.modificationStamp;
        }

        @Override
        public void reload() {
            this.notifyListeners(1);
            if (this.model != null) {
                this.model.addSiteModelListener(this.modelListeners);
            }
            try {
                try {
                    this.resetSynchronizationStamp();
                    this.model = SiteModelLoader.createSite(this.siteXml.getLocation().toOSString());
                }
                catch (ParsingException e) {
                    Logger.log(e);
                    this.getCommandStack().flush();
                    if (this.model != null) {
                        this.model.addSiteModelListener(this.modelListeners);
                    }
                    this.notifyListeners(2);
                }
            }
            finally {
                this.getCommandStack().flush();
                if (this.model != null) {
                    this.model.addSiteModelListener(this.modelListeners);
                }
                this.notifyListeners(2);
            }
        }

        @Override
        public void addListener(SiteModelContainerListener listener) {
            if (!this.containerListeners.contains(listener)) {
                this.containerListeners.add(listener);
            }
        }

        @Override
        public void removeListener(SiteModelContainerListener listener) {
            this.containerListeners.remove(listener);
        }

        protected void notifyListeners(int kind) {
            SiteModelContainerListener[] listeners = this.containerListeners.toArray(new SiteModelContainerListener[this.containerListeners.size()]);
            int i = 0;
            int n = listeners.length;
            while (i < n) {
                switch (kind) {
                    case 1: {
                        listeners[i].preModelReplaced(this);
                        break;
                    }
                    case 2: {
                        listeners[i].postModelReplaced(this);
                        break;
                    }
                    case 3: {
                        listeners[i].preSave(this);
                        break;
                    }
                    case 4: {
                        listeners[i].postSave(this);
                        break;
                    }
                    case 5: {
                        listeners[i].preDisposed(this);
                    }
                }
                ++i;
            }
        }

        public String toString() {
            return "BaseModelContainer[" + this.getFile() + ",edit/read=" + this.referenceCountForEdit + "/" + this.referenceCountForRead + "]";
        }

        @Override
        public void addListener(SiteModelListener listener) {
            this.modelListeners.add(listener);
            if (this.getSiteModel() != null) {
                this.getSiteModel().addSiteModelListener(listener);
            }
        }

        @Override
        public void removeListener(SiteModelListener listener) {
            this.modelListeners.remove(listener);
            if (this.getSiteModel() != null) {
                this.getSiteModel().removeSiteModelListener(listener);
            }
        }
    }

    protected static class SiteModelContainerDelegate
    implements SiteModelContainer {
        protected final BaseSiteModelContainer parent;
        protected final boolean forEdit;
        protected final HashSet installedAdapterFactories = new HashSet();
        protected final HashSet addedContainerListeners = new HashSet();
        protected final HashSet addedModelListeners = new HashSet();

        public SiteModelContainerDelegate(BaseSiteModelContainer parent, boolean forEdit) {
            this.parent = parent;
            this.forEdit = forEdit;
            if (forEdit) {
                parent.getForEdit();
            } else {
                parent.getForRead();
            }
        }

        @Override
        public void release() {
            for (Class clazz : this.installedAdapterFactories) {
                this.parent.uninstallAdapterFactory(clazz);
            }
            if (this.forEdit) {
                this.parent.relaseFromEdit();
            } else {
                this.parent.releaseFromRead();
            }
            for (Object listener : this.addedContainerListeners) {
                this.parent.removeListener((SiteModelContainerListener)listener);
            }
            for (Object listener : this.addedModelListeners) {
                this.parent.removeListener((SiteModelListener)listener);
            }
        }

        @Override
        public void installAdapterFactory(Class adapterFactory) {
            if (!this.installedAdapterFactories.contains(adapterFactory)) {
                this.parent.installAdapterFactory(adapterFactory);
                this.installedAdapterFactories.add(adapterFactory);
            }
        }

        @Override
        public CommandStack getCommandStack() {
            return this.parent.getCommandStack();
        }

        @Override
        public SiteModel getSiteModel() {
            return this.parent.getSiteModel();
        }

        @Override
        public boolean isDirty() {
            return this.parent.isDirty();
        }

        @Override
        public boolean isSharedForEdit() {
            return this.parent.isSharedForEdit();
        }

        @Override
        public boolean save(IProgressMonitor monitor) {
            return this.parent.save(monitor);
        }

        @Override
        public IVirtualComponent getComponent() {
            return this.parent.getComponent();
        }

        @Override
        public IFile getFile() {
            return this.parent.getFile();
        }

        @Override
        public void resetSynchronizationStamp() {
            this.parent.resetSynchronizationStamp();
        }

        @Override
        public boolean isSynchronizationStampUpdated() {
            return this.parent.isSynchronizationStampUpdated();
        }

        @Override
        public void reload() {
            this.parent.reload();
        }

        @Override
        public void addListener(SiteModelContainerListener listener) {
            this.parent.addListener(listener);
            this.addedContainerListeners.add(listener);
        }

        @Override
        public void removeListener(SiteModelContainerListener listener) {
            if (this.addedContainerListeners.remove(listener)) {
                this.parent.removeListener(listener);
            }
        }

        @Override
        public void addListener(SiteModelListener listener) {
            if (this.parent.modelListeners.contains(listener)) {
                if (SiteModelManager._isTracing()) {
                    SiteModelManager._trace("Trying to add existing SiteModelListener: " + listener);
                }
                return;
            }
            this.parent.addListener(listener);
            this.addedModelListeners.add(listener);
        }

        @Override
        public void removeListener(SiteModelListener listener) {
            if (this.addedModelListeners.remove(listener)) {
                this.parent.removeListener(listener);
            }
        }
    }
}

