/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.LinkModel;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentTreeVisitor;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteXmlDefaultValues;
import com.ibm.etools.siteedit.site.model.SiteXmlStrings;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SiteModelDumper
implements SiteComponentTreeVisitor,
SiteXmlStrings,
SiteXmlDefaultValues {
    private static final String TRACE_KEY = "model/dumper";
    protected final Document doc;
    protected Node parent;
    protected Element current;

    public static SiteModelDumper create(Document doc, String version) {
        return new SiteModelDumper(doc, version);
    }

    protected SiteModelDumper(Document doc, String version) {
        this.doc = doc;
        while (doc.getFirstChild() != null) {
            doc.removeChild(doc.getLastChild());
        }
        Element website = doc.createElement("website");
        website.setAttribute("version", version);
        doc.appendChild(website);
        this.parent = website;
    }

    @Override
    public boolean visit(SiteComponent component) {
        this.current = this.createElement(component);
        this.parent.appendChild(this.current);
        return true;
    }

    @Override
    public void enter(SiteComponent sc) {
        this.parent = this.current;
    }

    @Override
    public void leave(SiteComponent sc) {
        this.parent = this.parent.getParentNode();
    }

    protected Element createElement(SiteComponent sc) {
        Element result = null;
        SiteComponentType type = sc.getType();
        if (type == SiteComponentType.PAGE) {
            result = this.createPageElement((PageModel)sc);
        } else if (type == SiteComponentType.SHAREDPAGE) {
            result = this.createSharedPageElement((SharedPageModel)sc);
        } else if (type == SiteComponentType.GROUP) {
            result = this.createGroupElement((GroupModel)sc);
        } else if (type == SiteComponentType.LINK) {
            result = this.createLinkElement((LinkModel)sc);
        } else if (type == SiteComponentType.SITE) {
            if (this._isTracing()) {
                this._trace("SiteModelDumper starts model dump.");
            }
            result = this.createSiteElement((SiteModel)sc);
        } else if (type == SiteComponentType.WEBPROJECT) {
            result = this.createProjectElement((WebprojectModel)sc);
        }
        return result;
    }

    protected Element createSiteElement(SiteModel site) {
        Element result = this.doc.createElement("structure");
        this.setStringAttr(result, "nid", site.getNodeId());
        this.setStringAttr(result, "template", site.getTemplate());
        this.addTextAsElement(result, "description", site.getDescription());
        this.addTextAsElement(result, "author", site.getAuthor());
        return result;
    }

    protected Element createPageElement(PageModel page) {
        Element result = this.doc.createElement("page");
        this.setStringAttr(result, "nid", page.getNodeId());
        this.addTextAsElement(result, "title", page.getTitle());
        this.setStringAttr(result, "src", page.getSRC());
        this.setStringAttr(result, "template", page.getTemplate());
        this.setStringAttr(result, "servleturl", page.getServletUrl());
        this.setBooleanAttr(result, "navigation", page.getNavigation(), true);
        this.setBooleanAttr(result, "sitemap", page.getSiteMap(), true);
        this.setBooleanAttr(result, "navroot", page.getNavroot(), false);
        this.setStringAttr(result, "status", page.getDocStatus());
        this.setStringAttr(result, "author", page.getAuthor());
        this.setStringAttr(result, "id", page.getId());
        return result;
    }

    protected Element createSharedPageElement(SharedPageModel spage) {
        Element result = this.doc.createElement("pagelink");
        this.setStringAttr(result, "nid", spage.getNodeId());
        if (!spage.getSyncLabel()) {
            this.addTextAsElement(result, "title", spage.getTitle());
        }
        String ref = spage.getTargetPage().getNodeId();
        this.setStringAttr(result, "ref", ref);
        if (this._isTracing()) {
            System.out.println("Putting id: " + ref + " to reference: " + spage);
        }
        this.setBooleanAttr(result, "navigation", spage.getNavigation(), true);
        this.setBooleanAttr(result, "sitemap", spage.getSiteMap(), true);
        this.setBooleanAttr(result, "synclabel", spage.getSyncLabel(), true);
        this.setStringAttr(result, "id", spage.getId());
        return result;
    }

    protected Element createLinkElement(LinkModel link) {
        Element result = this.doc.createElement("link");
        this.setStringAttr(result, "nid", link.getNodeId());
        this.addTextAsElement(result, "title", link.getTitle());
        this.setStringAttr(result, "src", link.getSRC());
        this.setBooleanAttr(result, "navigation", link.getNavigation(), true);
        this.setBooleanAttr(result, "sitemap", link.getSiteMap(), true);
        return result;
    }

    protected Element createGroupElement(GroupModel group) {
        Element result = this.doc.createElement("group");
        this.setStringAttr(result, "nid", group.getNodeId());
        this.addTextAsElement(result, "title", group.getTitle());
        this.setStringAttr(result, "gid", group.getGourpId());
        this.setIntegerAttr(result, "depth", group.getDepth(), 0);
        this.setBooleanAttr(result, "navigation", group.getNavigation(), true);
        this.setBooleanAttr(result, "sitemap", group.getSiteMap(), true);
        this.setStringAttr(result, "color", group.getColor());
        this.setStringAttr(result, "id", group.getId());
        return result;
    }

    protected Element createProjectElement(WebprojectModel project) {
        Element result = this.doc.createElement("webproject");
        this.setStringAttr(result, "nid", project.getNodeId());
        this.setStringAttr(result, "src", project.getSRC());
        return result;
    }

    protected void setStringAttr(Element e, String name, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        e.setAttribute(name, value);
    }

    protected void setBooleanAttr(Element e, String name, boolean f, boolean defValue) {
        if (f == defValue) {
            return;
        }
        e.setAttribute(name, Boolean.toString(f));
    }

    protected void setIntegerAttr(Element e, String name, int value, int defValue) {
        if (value == defValue) {
            return;
        }
        e.setAttribute(name, Integer.toString(value));
    }

    protected void addTextAsElement(Element target, String elementName, String text) {
        Element e = this.doc.createElement(elementName);
        e.appendChild(this.doc.createTextNode(text));
        target.appendChild(e);
    }

    private void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    private boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }
}

