/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;

public final class SiteModelConstraint {
    private SiteModelConstraint() {
    }

    public static boolean canAddChild(SiteComponent target, SiteComponentType childType) {
        return SiteModelConstraint.canAddChild(target, null, childType, null);
    }

    public static boolean canAddChild(SiteComponent target, SiteComponentType childType, SiteComponent displayedTop) {
        return SiteModelConstraint.canAddChild(target, null, childType, displayedTop);
    }

    public static boolean canAddChild(SiteComponentType type, SiteComponentType childType) {
        return SiteModelConstraint.canAddChild(null, type, childType, null);
    }

    public static boolean canAddChild(SiteComponentType type, SiteComponentType childType, SiteComponent displayedTop) {
        return SiteModelConstraint.canAddChild(null, type, childType, displayedTop);
    }

    private static boolean canAddChild(SiteComponent target, SiteComponentType type, SiteComponentType childType, SiteComponent displayedTop) {
        if (type == null) {
            if (target == null) {
                return false;
            }
            type = target.getType();
        }
        if (type == SiteComponentType.WEBPROJECT) {
            if (target == null) {
                return false;
            }
            SiteComponent parent = target.getParent();
            if (parent == null) {
                return false;
            }
            if (parent.getType() != SiteComponentType.SITE) {
                return false;
            }
            if (childType != SiteComponentType.PAGE) {
                return false;
            }
            if (target.numberOfChildren() > 0) {
                return false;
            }
        } else if (type == SiteComponentType.PAGE || type == SiteComponentType.GROUP) {
            if (type == SiteComponentType.GROUP && childType == SiteComponentType.GROUP) {
                return false;
            }
            if (childType == SiteComponentType.ROOT) {
                return false;
            }
            if (childType == SiteComponentType.SITE) {
                return false;
            }
            if (childType == SiteComponentType.STEPUP_ICON) {
                return false;
            }
        } else if (type == SiteComponentType.SITE) {
            if (target != null && target.numberOfChildren() > 0 && target.getChildAt(0).getType() == SiteComponentType.STEPUP_ICON) {
                return false;
            }
            if (childType == SiteComponentType.LINK) {
                return false;
            }
            if (childType == SiteComponentType.ROOT) {
                return false;
            }
            if (childType == SiteComponentType.SITE) {
                return false;
            }
            if (childType == SiteComponentType.STEPUP_ICON) {
                return false;
            }
            if (childType == SiteComponentType.WEBPROJECT) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean canDelete(SiteComponent model) {
        if (model == null || model.getParentForEditing() == null) {
            return false;
        }
        if (model.getParent() != model.getParentForEditing()) {
            return false;
        }
        SiteComponentType parentType = model.getParentForEditing().getType();
        return parentType != SiteComponentType.ROOT && parentType != SiteComponentType.STEPUP_ICON;
    }

    public static boolean canMove(SiteComponent obj, SiteComponent dst) {
        if (obj == null || dst == null) {
            return false;
        }
        if (obj.getParentForEditing() == dst) {
            return true;
        }
        if (!SiteModelConstraint.canDelete(obj)) {
            return false;
        }
        if (!SiteModelConstraint.canAddChild(dst, obj.getType())) {
            return false;
        }
        if (obj.getType() == SiteComponentType.WEBPROJECT) {
            SiteComponent p = obj.getParentForEditing();
            return p != null && (p.getType() == SiteComponentType.PAGE || p.getType() == SiteComponentType.GROUP);
        }
        SiteComponent sc = dst;
        while (sc != null) {
            if (sc == obj) {
                return false;
            }
            sc = sc.getParent();
        }
        return true;
    }
}

