/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponentIterator;
import com.ibm.etools.siteedit.site.model.SiteComponentTreeVisitor;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelProperty;
import com.ibm.etools.siteedit.site.model.SiteNotifyItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.eclipse.swt.widgets.Display;

public abstract class SiteComponent
extends Observable {
    protected SiteModel site;
    private String nodeId = "";
    private Object data;
    private SiteComponent parent = null;
    private ArrayList children = new ArrayList();
    private SiteComponent parentForEdit = null;

    public abstract SiteComponentType getType();

    SiteComponent(SiteModel siteModel) {
        this.site = siteModel;
    }

    private void PerformDeferredNotify(Object obj, boolean bClearChanged) {
        this.setChanged();
        this.notifyObservers(obj);
        if (bClearChanged) {
            this.clearChanged();
        }
    }

    public void DeferredNotify(Object arg, boolean bClearChanged) {
        Display.getDefault().asyncExec((Runnable)new NotifyRequest(arg, bClearChanged));
    }

    protected void setChangedAndNotify() {
        this.setChanged();
        this.notifyObservers();
    }

    protected void setChangedAndNotify(Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    public void setParent(SiteComponent parent) {
        this.parent = parent;
    }

    public SiteComponent getParent() {
        return this.parent;
    }

    public GroupModel getParentGroup() {
        int depth = 0;
        SiteComponent parent = this;
        while (parent != null) {
            if ((parent = parent.getParent()) instanceof GroupModel) {
                GroupModel groupModel = (GroupModel)parent;
                if (depth >= groupModel.getDepth() && groupModel.getDepth() > 0) continue;
                return groupModel;
            }
            ++depth;
        }
        return null;
    }

    public int numberOfChildren() {
        return this.children.size();
    }

    public int indexOf(SiteComponent child) {
        return this.children.indexOf(child);
    }

    public void appendChild(SiteComponent child) {
        this.appendChild(child, true);
    }

    public void appendChild(SiteComponent child, boolean usePagesAddPane) {
        this.children.add(child);
        child.setParent(this);
        this.notifyAfterAddition(child, usePagesAddPane);
    }

    public void addChildAt(int index, SiteComponent child) {
        this.addChildAt(index, child, true);
    }

    public void addChildAt(int index, SiteComponent child, boolean usePagesAddPane) {
        this.children.add(index, child);
        child.setParent(this);
        this.notifyAfterAddition(child, usePagesAddPane);
    }

    private void notifyAfterAddition(SiteComponent child, boolean usePagesAddPane) {
        if (this.getSiteModel() != null) {
            this.getSiteModel().notifyPostChildAddition(child);
        }
        SiteNotifyItem notifyObject = null;
        if (usePagesAddPane && child instanceof PageModel) {
            notifyObject = new SiteNotifyItem(child, 101);
        }
        this.setChangedAndNotify(notifyObject);
    }

    public void addChildBefore(SiteComponent target, SiteComponent child) {
        this.addChildAt(this.indexOf(target), child);
    }

    public void addChildAfter(SiteComponent target, SiteComponent child) {
        int index = this.indexOf(target);
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.addChildAt(this.indexOf(target) + 1, child);
    }

    public SiteComponent getChildAt(int index) {
        return (SiteComponent)this.children.get(index);
    }

    public SiteComponent[] getChildren() {
        int childSize = this.numberOfChildren();
        return this.children.toArray(new SiteComponent[childSize]);
    }

    public SiteComponent removeChildAt(int index) {
        SiteComponent child = this.getChildAt(index);
        if (this.getSiteModel() != null) {
            this.getSiteModel().notifyPreChildRemoval(child);
        }
        child.setParent(null);
        this.children.remove(index);
        if (child instanceof PageModel) {
            SiteNotifyItem notifyObject = new SiteNotifyItem(child, 102);
            this.setChangedAndNotify(notifyObject);
        } else {
            this.setChangedAndNotify();
        }
        return child;
    }

    public Iterator iterator() {
        return new SiteComponentIterator(this);
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        return "SiteComp(" + this.getType().toString() + ", Nchild=" + this.numberOfChildren() + ")";
    }

    public final void accept(SiteComponentTreeVisitor v) {
        this.acceptCore(v);
    }

    public final void accept(final SiteComponentVisitor v) {
        this.acceptCore(new SiteComponentTreeVisitor(){

            @Override
            public void enter(SiteComponent sc) {
            }

            @Override
            public void leave(SiteComponent sc) {
            }

            @Override
            public boolean visit(SiteComponent component) {
                return v.visit(component);
            }
        });
    }

    protected boolean acceptCore(SiteComponentTreeVisitor v) {
        if (!v.visit(this)) {
            return false;
        }
        SiteComponentIterator it = (SiteComponentIterator)this.iterator();
        v.enter(this);
        while (it.hasNext()) {
            SiteComponent element = (SiteComponent)it.next();
            if (element.acceptCore(v)) continue;
            return false;
        }
        v.leave(this);
        return true;
    }

    public List getAllChildren() {
        return this.children;
    }

    public SiteComponent getParentForEditing() {
        return this.parentForEdit != null ? this.parentForEdit : this.getParent();
    }

    public void setParentForEditing(SiteComponent sc) {
        this.parentForEdit = sc;
    }

    boolean isOrphan() {
        SiteComponent current = this;
        while (current != null) {
            if (current == this.getSiteModel()) {
                return false;
            }
            current = current.getParent();
        }
        return true;
    }

    public SiteModel getSiteModel() {
        return this.site;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public boolean hasProperty(SiteModelProperty prop) {
        return prop.isPropertyFor(this);
    }

    public boolean isEditableProperty(SiteModelProperty prop) {
        return prop.isEditablePropertyFor(this);
    }

    public String getStringProperty(SiteModelProperty prop) {
        return (String)prop.getProperty(this);
    }

    public void setStringProperty(SiteModelProperty prop, String s) {
        prop.setProperty(this, s);
    }

    public boolean getBooleanProperty(SiteModelProperty prop) {
        return (Boolean)prop.getProperty(this);
    }

    public void setBooleanProperty(SiteModelProperty prop, boolean s) {
        prop.setProperty(this, s);
    }

    public int getIntProperty(SiteModelProperty prop) {
        return (Integer)prop.getProperty(this);
    }

    public void setIntProperty(SiteModelProperty prop, int s) {
        prop.setProperty(this, new Integer(s));
    }

    public Object getProperty(SiteModelProperty prop) {
        return prop.getProperty(this);
    }

    public void setProperty(SiteModelProperty prop, Object v) {
        prop.setProperty(this, v);
    }

    public void copyProperties(SiteComponent other) {
    }

    protected class NotifyRequest
    implements Runnable {
        Object arg;
        boolean bClearChanged;

        public NotifyRequest(Object arg, boolean bClearChanged) {
            this.arg = arg;
            this.bClearChanged = bClearChanged;
        }

        @Override
        public void run() {
            SiteComponent.this.PerformDeferredNotify(this.arg, this.bClearChanged);
        }
    }
}

