/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.NavItemSiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelListener;
import com.ibm.etools.siteedit.site.model.SiteModelProperty;
import com.ibm.etools.siteedit.site.model.SiteNotifyItem;

public class PageModel
extends NavItemSiteComponent {
    private String src = "";
    private boolean isNew = false;
    private String docStatus = "";
    private String author = "";
    private boolean navroot = false;
    private String servleturl = "";
    private String template = "";
    private boolean realized = false;
    private boolean hasNav;

    PageModel(SiteModel site) {
        super(site);
    }

    @Override
    public SiteComponentType getType() {
        return SiteComponentType.PAGE;
    }

    public void setSRC(String src) {
        SiteModelListener.SiteComponentEvent e = new SiteModelListener.SiteComponentEvent(this, SiteModelProperty.SRC, this.src);
        this.src = src;
        if (this.getSiteModel() != null) {
            this.getSiteModel().notifyPostPropertyChanged(e);
        }
        this.setChangedAndNotify();
    }

    public void setSRCWithNotify(String src) {
        PageModel oldModel = this.getCopy();
        this.setSRC(src);
        if (this.getParent() != null) {
            SiteNotifyItem notifyObject;
            if (oldModel.src != null && oldModel.src.length() > 0) {
                notifyObject = new SiteNotifyItem(oldModel, 102);
                this.setChangedAndNotify(notifyObject);
            }
            if (this.src != null && this.src.length() > 0) {
                notifyObject = new SiteNotifyItem(this, 101);
                this.setChangedAndNotify(notifyObject);
            }
        }
    }

    public String getSRC() {
        return this.src;
    }

    public String getDocStatus() {
        return this.docStatus;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getServletUrl() {
        return this.servleturl;
    }

    @Override
    public String getTitle() {
        String title = super.getTitle();
        if (title == null || title.length() == 0) {
            title = this.getSRC();
            int idx = title.lastIndexOf("/");
            if (idx >= 0) {
                title = title.substring(++idx);
            }
            if ((idx = title.indexOf(".")) >= 0) {
                title = title.substring(0, idx);
            }
        }
        return title;
    }

    public void setTemplate(String template) {
        if (template == null) {
            template = "";
        }
        this.template = template;
        this.setChangedAndNotify();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateFile() {
        String strTemplate = "";
        strTemplate = this.getTemplate();
        if (strTemplate != null && strTemplate.length() > 0) {
            return strTemplate;
        }
        return this.getSiteModel().getTemplate();
    }

    public String getSiteTemplate() {
        return this.getSiteModel().getTemplate();
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public void setDocStatus(String status) {
        this.docStatus = status;
        this.setChangedAndNotify();
    }

    public void setAuthor(String author) {
        this.author = author;
        this.setChangedAndNotify();
    }

    public void setNavroot(boolean navroot) {
        this.navroot = navroot;
        this.setChangedAndNotify();
    }

    public boolean getNavroot() {
        return this.navroot;
    }

    public void setServletUrl(String servleturl) {
        this.servleturl = servleturl;
        this.setChangedAndNotify();
    }

    public PageModel getCopy() {
        PageModel copy = this.getCopy(this);
        return copy;
    }

    private PageModel getCopy(PageModel src) {
        PageModel copy = new PageModel(this.site);
        copy.setSRC(src.getSRC());
        copy.setRealized(src.getRealized());
        copy.setTemplate(src.getTemplate());
        copy.setTitle(src.getTitle());
        copy.setAuthor(src.getAuthor());
        copy.setDocStatus(src.getDocStatus());
        copy.setNavigation(src.getNavigation());
        copy.setSiteMap(src.getSiteMap());
        copy.setNavroot(src.getNavroot());
        copy.setId(src.getId());
        copy.setServletUrl(src.getServletUrl());
        copy.setNodeId(src.getNodeId());
        return copy;
    }

    @Override
    public void copyProperties(SiteComponent target) {
        super.copyProperties(target);
        PageModel copy = (PageModel)target;
        copy.setAuthor(this.getAuthor());
        copy.setDocStatus(this.getDocStatus());
        copy.setHasNav(this.hasNav());
        copy.setNavroot(this.getNavroot());
        copy.setRealized(this.getRealized());
        copy.setServletUrl(this.getServletUrl());
        copy.setSRC(this.getSRC());
        copy.setTemplate(this.getTemplate());
    }

    @Override
    public String toString() {
        return "SiteP(" + this.getSRC() + ", Nchild=" + this.numberOfChildren() + ")";
    }

    public void setRealized(boolean realized) {
        this.realized = realized;
        this.setChangedAndNotify();
    }

    public boolean getRealized() {
        return this.realized;
    }

    public void setHasNav(boolean hasNav) {
        this.hasNav = hasNav;
        this.setChangedAndNotify();
    }

    public boolean hasNav() {
        return this.hasNav;
    }
}

