/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.navigator;

import com.ibm.etools.siteedit.internal.builder.ISiteCoreConstants;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.nature.WebSiteNatureRuntime;
import com.ibm.etools.siteedit.navigator.WebSiteNavigationElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;

class WebSiteNavigationOpenAction
extends SelectionListenerAction
implements ISiteCoreConstants {
    protected WebSiteNavigationOpenAction(String text) {
        super(text);
    }

    public void run(ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() == 1 && ss.getFirstElement() instanceof WebSiteNavigationElement) {
            WebSiteNavigationElement element = (WebSiteNavigationElement)ss.getFirstElement();
            boolean status = WebComponentUtil.hasWebSiteFeature(element.getComponent());
            WebComponentUtil.ensureWebSiteFeature(element.getComponent(), null);
            final IFile file = (IFile)element.getAdapter(IFile.class);
            if (!status) {
                WebSiteNatureRuntime.removeWebSiteNature(element.getComponent().getProject());
            }
            final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            final IEditorDescriptor editor = PlatformUI.getWorkbench().getEditorRegistry().findEditor("com.ibm.etools.siteedit.site.editor.WebSiteDesigner");
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Web Site Designer failed to open"){

                public void run() throws Exception {
                    if (editor != null) {
                        IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (String)"com.ibm.etools.siteedit.site.editor.WebSiteDesigner");
                    } else {
                        IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file);
                    }
                }
            });
        }
    }
}

