/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.nature;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.ISiteCoreConstants;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WebSiteNatureRuntime
implements IProjectNature,
ISiteCoreConstants {
    private IProject project;

    public void configure() throws CoreException {
        this.installSiteNavBuilder();
        this.installSiteUpdateBuilder();
    }

    public void deconfigure() throws CoreException {
        this.deinstallSiteNavBuilder();
        this.deinstallSiteUpdateBuilder();
    }

    public boolean reconfigure() throws CoreException {
        int iPostSd;
        if (!this.hasBuilder("com.ibm.etools.siteedit.SiteNavBuilder")) {
            return false;
        }
        if (!this.hasBuilder("com.ibm.etools.siteedit.SiteUpdateBuilder")) {
            return false;
        }
        int iLinksBuilder = this.getBuilderOrder("com.ibm.etools.links.management.linksbuilder");
        int iTemplateBuilder = this.getBuilderOrder("com.ibm.etools.webpage.template.templatebuilder");
        int iSiteNavBuilder = this.getBuilderOrder("com.ibm.etools.siteedit.SiteNavBuilder");
        int iSiteUpdateBuilder = this.getBuilderOrder("com.ibm.etools.siteedit.SiteUpdateBuilder");
        int iValidationBuilder = this.getBuilderOrder("org.eclipse.wst.validation.validationbuilder");
        int iPreSd = Math.max(iLinksBuilder, iTemplateBuilder);
        int n = iPostSd = iValidationBuilder < 0 ? Integer.MAX_VALUE : iValidationBuilder;
        if (iPreSd < iSiteNavBuilder && iSiteNavBuilder < iPostSd && iPreSd < iSiteUpdateBuilder && iSiteUpdateBuilder < iPostSd) {
            return false;
        }
        IProjectDescription description = this.project.getDescription();
        ArrayList<ICommand> buildSpecs = new ArrayList<ICommand>(Arrays.asList(description.getBuildSpec()));
        ICommand siteNavBuilder = buildSpecs.get(iSiteNavBuilder);
        ICommand siteUpdateBuilder = buildSpecs.get(iSiteUpdateBuilder);
        buildSpecs.remove(siteNavBuilder);
        buildSpecs.remove(siteUpdateBuilder);
        iLinksBuilder = this.getBuilderOrder("com.ibm.etools.links.management.linksbuilder");
        iTemplateBuilder = this.getBuilderOrder("com.ibm.etools.webpage.template.templatebuilder");
        iValidationBuilder = this.getBuilderOrder("org.eclipse.wst.validation.validationbuilder");
        iPreSd = Math.max(iLinksBuilder, iTemplateBuilder);
        buildSpecs.add(iPreSd + 1, siteUpdateBuilder);
        buildSpecs.add(iPreSd + 1, siteNavBuilder);
        description.setBuildSpec(buildSpecs.toArray(new ICommand[buildSpecs.size()]));
        this.project.setDescription(description, null);
        return true;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static boolean hasWebSiteNatureRuntime(IProject project) {
        return project != null && project.exists() && WebSiteNatureRuntime.hasProjectNature("com.ibm.etools.siteedit.WebSiteNature", project);
    }

    public static void ensureWebSiteNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!WebSiteNatureRuntime.hasWebSiteNatureRuntime(project)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.ibm.etools.siteedit.WebSiteNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static void removeWebSiteNature(IProject project) {
        if (WebSiteNatureRuntime.hasWebSiteNatureRuntime(project)) {
            try {
                IProjectDescription description = project.getDescription();
                String[] prevNatures = description.getNatureIds();
                String[] newNatures = new String[prevNatures.length - 1];
                int j = 0;
                int i = 0;
                while (i < prevNatures.length) {
                    if (!prevNatures[i].equals("com.ibm.etools.siteedit.WebSiteNature")) {
                        newNatures[j] = prevNatures[i];
                        ++j;
                    }
                    ++i;
                }
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
            catch (CoreException ce) {
                Logger.log(ce);
            }
        }
    }

    private static boolean hasProjectNature(String nature, IProject project) {
        if (nature == null || project == null) {
            return false;
        }
        try {
            return project.hasNature(nature);
        }
        catch (CoreException ignored) {
            Logger.log(ignored);
            return false;
        }
    }

    private boolean hasBuilder(String builder_id) {
        boolean found = false;
        try {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(builder_id)) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Logger.log(ex);
        }
        return found;
    }

    private void installSiteNavBuilder() throws CoreException {
        this.addToBuildSpec("com.ibm.etools.siteedit.SiteNavBuilder");
    }

    private void deinstallSiteNavBuilder() throws CoreException {
        this.removeFromBuildSpec("com.ibm.etools.siteedit.SiteNavBuilder");
    }

    private void installSiteUpdateBuilder() throws CoreException {
        this.addToBuildSpec("com.ibm.etools.siteedit.SiteUpdateBuilder");
    }

    private void deinstallSiteUpdateBuilder() throws CoreException {
        this.removeFromBuildSpec("com.ibm.etools.siteedit.SiteUpdateBuilder");
    }

    private void addToBuildSpec(String builder) throws CoreException {
        if (!this.hasBuilder(builder)) {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            ICommand command = description.newCommand();
            command.setBuilderName(builder);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            if (this.hasBuilder("org.eclipse.wst.validation.validationbuilder")) {
                int order = this.getBuilderOrder("org.eclipse.wst.validation.validationbuilder");
                if (order == -1) {
                    order = 0;
                }
                System.arraycopy(commands, 0, newCommands, 0, order);
                newCommands[order] = command;
                System.arraycopy(commands, order, newCommands, order + 1, commands.length - order);
            } else {
                System.arraycopy(commands, 0, newCommands, 0, commands.length);
                newCommands[newCommands.length - 1] = command;
            }
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
        }
    }

    private void removeFromBuildSpec(String builder) throws CoreException {
        if (this.hasBuilder(builder)) {
            IProjectDescription description = this.project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[commands.length - 1];
            int newCount = 0;
            int i = 0;
            while (i < commands.length) {
                if (!commands[i].getBuilderName().equals(builder)) {
                    newCommands[newCount] = commands[i];
                    ++newCount;
                }
                ++i;
            }
            description.setBuildSpec(newCommands);
            this.project.setDescription(description, null);
        }
    }

    private int getBuilderOrder(String builderId) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

