/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.links.internal.providers;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.javaee.taglib.HTMLTaglibDirectiveUtil;
import com.ibm.etools.references.web.javaee.taglib.TaglibDirective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class SiteDesginerLinkDetectorProvider
extends AbstractWebProvider
implements ILinkDetectorProvider {
    static final String SITEEDIT_TAGLIB = "http://www.ibm.com/siteedit/sitelib";
    static final String SITENAV_TAG_NAVBAR = "siteedit:navbar";
    static final String SITENAV_TAG_NAVTRAIL = "siteedit:navtrail";
    static final String SITENAV_TAG_SITEMAP = "siteedit:sitemap";
    static final String SITENAV_TAG_NAVTAB = "siteedit:navtab";
    static final String SITENAV_ATTRIB_SPEC = "spec";
    static final String SITENAV_ATTRIB_IMG = "img";
    private boolean isTaglibDirectivePresent = false;
    private String prefixInTaglib = null;
    private static HashMap<String, String[]> nameAttributeMap = new HashMap();

    static {
        nameAttributeMap.put(SITENAV_TAG_NAVBAR, new String[]{SITENAV_ATTRIB_SPEC});
        nameAttributeMap.put(SITENAV_TAG_NAVTRAIL, new String[]{SITENAV_ATTRIB_SPEC});
        nameAttributeMap.put(SITENAV_TAG_SITEMAP, new String[]{SITENAV_ATTRIB_SPEC});
        nameAttributeMap.put(SITENAV_TAG_NAVTAB, new String[]{SITENAV_ATTRIB_SPEC, SITENAV_ATTRIB_IMG});
    }

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        IDOMModel model = null;
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            model = (IDOMModel)sharedModel.getSharedModel();
        }
        this.isTaglibDirectivePresent = false;
        if (model != null) {
            this.parseTagLib(model);
        }
        if (this.isTaglibDirectivePresent) {
            return this.detectLinksWithTaglib(factory, sharedModel, incomingReferences);
        }
        return this.detectLinksWithoutTaglib(factory, sharedModel, incomingReferences);
    }

    private List<ILink> detectLinksWithoutTaglib(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IDOMDocument document = model.getDocument();
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                String[] attributes;
                String nName = n.getNodeName();
                if (nName != null && (attributes = nameAttributeMap.get(nName)) != null) {
                    IDOMElement domElement = (IDOMElement)n;
                    if (attributes.length != 0) {
                        NamedNodeMap attributeNodes = n.getAttributes();
                        int length = attributeNodes.getLength();
                        int i = 0;
                        while (i < length) {
                            Node item = attributeNodes.item(i);
                            String name = null;
                            String attName = item.getNodeName();
                            String[] stringArray = attributes;
                            int n2 = attributes.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String attribute = stringArray[n3];
                                if (attName.compareToIgnoreCase(attribute) == 0) {
                                    String linkType = this.getLinkType(nName, attName);
                                    IDOMAttr attr = (IDOMAttr)item;
                                    ILink webLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)attr, (String)linkType, name);
                                    if (attribute.equals(SITENAV_ATTRIB_SPEC)) {
                                        factory.addParam(webLink, "subparse", "true");
                                        factory.addParam(webLink, "isSiteLink", "true");
                                    }
                                    links.add(webLink);
                                    break;
                                }
                                ++n3;
                            }
                            ++i;
                        }
                    }
                }
                n = iter.nextNode();
            }
        }
        return links;
    }

    private List<ILink> detectLinksWithTaglib(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        String siteDesignerPrefix = null;
        if (this.prefixInTaglib != null) {
            siteDesignerPrefix = this.prefixInTaglib;
        }
        IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
        IDOMDocument document = model.getDocument();
        NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
        Node n = iter.nextNode();
        while (n != null) {
            String nodeName = n.getNodeName();
            if (nodeName != null) {
                IDOMElement domElement = (IDOMElement)n;
                if ((String.valueOf(siteDesignerPrefix) + "navbar").equals(nodeName) || (String.valueOf(siteDesignerPrefix) + "navtrail").equals(nodeName) || (String.valueOf(siteDesignerPrefix) + "sitemap").equals(nodeName)) {
                    IDOMAttr value = (IDOMAttr)domElement.getAttributeNode(SITENAV_ATTRIB_SPEC);
                    if (value != null) {
                        ILink siteLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)value, (String)"web.commonlink", (String)nodeName);
                        factory.addParam(siteLink, "subparse", "true");
                        factory.addParam(siteLink, "isSiteLink", "true");
                        links.add(siteLink);
                    }
                } else if ((String.valueOf(siteDesignerPrefix) + "navtab").equals(nodeName)) {
                    String valueName;
                    IDOMAttr img = (IDOMAttr)domElement.getAttributeNode(SITENAV_ATTRIB_IMG);
                    IDOMAttr spec = (IDOMAttr)domElement.getAttributeNode(SITENAV_ATTRIB_SPEC);
                    if (img != null && ((valueName = img.getValue()).endsWith(".jsp") || valueName.endsWith(".jspf") || valueName.endsWith(".jsf"))) {
                        ILink siteLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)img, (String)"web.commonlink", (String)nodeName);
                        links.add(siteLink);
                    }
                    if (spec != null) {
                        ILink siteLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IDOMElement)domElement, (IDOMAttr)spec, (String)"web.commonlink", (String)nodeName);
                        factory.addParam(siteLink, "subparse", "true");
                        factory.addParam(siteLink, "isSiteLink", "true");
                        links.add(siteLink);
                    }
                }
            }
            n = iter.nextNode();
        }
        return links;
    }

    private void parseTagLib(IDOMModel model) {
        List tagLibDirectiveEx = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
        for (TaglibDirective taglibDirective : tagLibDirectiveEx) {
            if (!SITEEDIT_TAGLIB.equals(taglibDirective.getURI())) continue;
            this.prefixInTaglib = taglibDirective.getPrefix().concat(":");
            this.isTaglibDirectivePresent = true;
        }
    }

    private String getLinkType(String nodeName, String attName) {
        return "web.commonlink";
    }
}

