/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.util.BuildUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteFileTypeUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplRefNode;
import com.ibm.etools.webpage.template.model.TplReference;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class SiteTemplateUtil {
    private static final String TRACE_KEY = "templateutil";
    static boolean _isTracing = Logger.isTracing("templateutil");

    public static TemplateData getRawTemplate(IStructuredDocument document, IPath location) {
        TemplateData data = SiteTemplateUtil.getTemplateOfStaticPageTemplate(document, location);
        if (data == null && SiteTemplateUtil.needToParseDynamicTemplate(document, location)) {
            data = SiteTemplateUtil.getTemplateOfDynamicPageTemplate(document, location);
        }
        if (data == null) {
            data = new TemplateData();
        }
        return data;
    }

    public static TemplateData getRawTemplate(IFile file) {
        boolean isTemplate = BuildUtil.isTemplate(file);
        Object template = SiteTemplateUtil.decodeTemplateString(BuildUtil.getPageTemplate(file), WebComponentUtil.findComponent((IResource)file));
        return new TemplateData(isTemplate, template);
    }

    public static boolean isTemplate(IStructuredDocument document, IPath location) {
        return SiteTemplateUtil.getRawTemplate(document, location).isTemplate();
    }

    public static boolean isTemplate(IFile file) {
        return BuildUtil.isTemplate(file);
    }

    public static boolean isDynamicTemplate(IFile file) {
        return SiteFileTypeUtil.whatKindOfFile(file.getFullPath()) == 2 && SiteTemplateUtil.isTemplate(file);
    }

    public static boolean isDynamicTemplate(boolean isTemplate, IFile file) {
        return isTemplate && SiteFileTypeUtil.whatKindOfFile(file.getFullPath()) == 2;
    }

    public static boolean isDynamicTemplateObject(Object template) {
        return template instanceof TilesDefinitionElement;
    }

    public static boolean isFragment(IFile file) {
        if (file == null) {
            return false;
        }
        return _isTracing && file.getName().indexOf("fragment") != -1;
    }

    static IFile getTemplateFile(Object template) {
        if (template instanceof IFile) {
            return (IFile)template;
        }
        if (template instanceof TilesDefinitionElement) {
            return ((TilesDefinitionElement)template).getFile();
        }
        return null;
    }

    static IStructuredDocumentRegion[] getContentAreaRegions(IStructuredDocument flatModel, IFile file) {
        ArrayList<TplRefNode> tplRefNodes = new ArrayList<TplRefNode>(3);
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel tplModel = session.getTemplateModel(flatModel, file.getLocation().toString());
        List putNodes = TemplateModelUtil.collectPutNode((TemplateModel)tplModel);
        if (putNodes != null) {
            for (TplPut putNode : putNodes) {
                TplRefNode ref = putNode.getRefNode();
                if (ref == null) continue;
                tplRefNodes.add(ref);
            }
        }
        if (tplRefNodes.isEmpty()) {
            tplRefNodes.add(new TplRefNode(flatModel.getFirstStructuredDocumentRegion(), flatModel.getLastStructuredDocumentRegion(), tplModel));
        }
        IStructuredDocumentRegion[] nodeArray = flatModel.getStructuredDocumentRegions();
        IStructuredDocumentRegion[] result = new IStructuredDocumentRegion[nodeArray.length];
        block1: for (TplRefNode ref : tplRefNodes) {
            IStructuredDocumentRegion start = ref.getStartNode();
            IStructuredDocumentRegion end = ref.getEndNode();
            int length = nodeArray.length;
            boolean flag = false;
            int i = 0;
            while (i < length) {
                if (nodeArray[i] == start) {
                    flag = true;
                }
                if (flag) {
                    result[i] = nodeArray[i];
                }
                if (nodeArray[i] == end) continue block1;
                ++i;
            }
        }
        return result;
    }

    private static IDOMModel getDOMModel(IStructuredDocument document, IFile file) {
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel doc = mm.getExistingModelForRead((IDocument)document);
        if (doc == null) {
            if (_isTracing) {
                SiteTemplateUtil._trace("StructuredModel has been initiated to resolve tiles template for: " + file);
            }
            try {
                doc = mm.getModelForRead(file);
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        if (doc instanceof IDOMModel) {
            return (IDOMModel)doc;
        }
        if (doc != null) {
            doc.releaseFromRead();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TemplateData getTemplateOfDynamicPageTemplate(IStructuredDocument instanceModel, IPath location) {
        TemplateData result = new TemplateData();
        IFile file = SiteResourceUtil.fileForLocation(location);
        if (file == null) {
            return null;
        }
        IDOMModel model = SiteTemplateUtil.getDOMModel(instanceModel, file);
        if (model == null) {
            return null;
        }
        try {
            IVirtualComponent component = WebComponentUtil.findComponent((IResource)file);
            TilesDefinitionUtil util = null;
            try {
                String tilesType = TilesUtil.getTilesType((IDOMModel)model);
                if ("TilesTemplate".equals(tilesType)) {
                    result.setIsTemplate(true);
                    TemplateData templateData = result;
                    return templateData;
                }
                if (!"TilesInstance".equals(TilesUtil.getTilesType((IDOMModel)model))) {
                }
                String def = TilesUtil.getTemplateDefinitionValue((IDOMModel)model);
                util = new TilesDefinitionUtil(component);
                IPath tplPath = util.lookupTemplateJspFor(def);
                IFile tplFile = TilesDefinitionUtil.getWebFile((IVirtualComponent)component, (IPath)tplPath);
                if (def == null) {
                }
                if (tplFile == null) {
                }
                if (tplFile.exists()) {
                    result.setTemplate(new TilesDefinitionElement(def, tplFile));
                    TemplateData templateData = result;
                    return templateData;
                }
            }
            finally {
                if (util != null) {
                    util.dispose();
                }
            }
        }
        finally {
            model.releaseFromRead();
        }
    }

    private static TemplateData getTemplateOfStaticPageTemplate(IStructuredDocument instanceModel, IPath location) {
        TemplateModelSession session;
        TemplateModel tplModel;
        TemplateData result = new TemplateData();
        int ftype = SiteFileTypeUtil.whatKindOfFile(location);
        if (ftype == 7) {
            result.setIsTemplate(true);
        }
        if ((tplModel = (session = new TemplateModelSession()).getTemplateModel(instanceModel, location.toString())) != null) {
            TplReference tplRef = (TplReference)TemplateModelUtil.findTemplateNodeOf((TemplateModel)tplModel, (boolean)true);
            IFile tplFile = tplRef != null ? tplRef.getReferedFile() : null;
            result.setTemplate(tplFile);
        }
        if (!result.isTemplate() && result.getTemplate() == null) {
            return null;
        }
        return result;
    }

    private static boolean needToParseDynamicTemplate(IStructuredDocument instanceModel, IPath location) {
        if (SiteFileTypeUtil.whatKindOfFile(location) != 2) {
            return false;
        }
        String TILES_KEY = "tiles";
        try {
            int len = Math.min(1024, instanceModel.getLength());
            int pos = instanceModel.get(0, len).indexOf(TILES_KEY);
            if (pos != -1) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static Object decodeTemplateString(String templateString, IVirtualComponent component) {
        if (templateString == null) {
            return null;
        }
        if (templateString.startsWith("/")) {
            return SiteResourceUtil.fileForProjectRelative(component, templateString);
        }
        if (templateString.startsWith("tiles:")) {
            int indexFile = 6;
            int indexSharp = templateString.indexOf(35);
            String fileString = templateString.substring(indexFile, indexSharp);
            IFile file = SiteResourceUtil.fileForProjectRelative(component, fileString);
            String nameString = templateString.substring(indexSharp + 1);
            return new TilesDefinitionElement(nameString, file);
        }
        return null;
    }

    public static String encodeTemplateString(Object template) {
        if (template instanceof IPath) {
            template = SiteResourceUtil.fileForLocation((IPath)template);
        }
        if (template instanceof IFile) {
            IFile file = (IFile)template;
            return SiteResourceUtil.getProjectRelativePathString(file.getProject(), (IResource)file);
        }
        if (template instanceof TilesDefinitionElement) {
            TilesDefinitionElement definision = (TilesDefinitionElement)template;
            IFile file = definision.getFile();
            String result = "tiles:" + SiteResourceUtil.getProjectRelativePathString(file.getProject(), (IResource)file) + "#" + definision.getDefinitionName();
            return result;
        }
        return "";
    }

    static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    public static class TemplateData {
        private boolean isTemplate;
        private Object template;

        TemplateData(boolean isTemplate, Object template) {
            this.isTemplate = isTemplate;
            this.template = template;
        }

        TemplateData() {
        }

        public boolean isTemplate() {
            return this.isTemplate;
        }

        void setIsTemplate(boolean isTemplate) {
            this.isTemplate = isTemplate;
        }

        public Object getTemplate() {
            return this.template;
        }

        void setTemplate(Object template) {
            this.template = template;
        }

        public String getTemplateString() {
            return SiteTemplateUtil.encodeTemplateString(this.template);
        }
    }
}

