/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.webedit.util.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webedit.util.ITaglibDirective;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class SiteTaglibDirectiveReader {
    private static final String NAME_TAGLIB = "taglib";
    private static final String NAME_PREFIX = "prefix";
    private static final String NAME_URI = "uri";

    public static Map createPrefixToURIMap(IStructuredDocument flatModel) {
        return SiteTaglibDirectiveReader.createPrefixURIMap(flatModel, true);
    }

    public static Map createURIToPrefixMap(IStructuredDocument flatModel) {
        return SiteTaglibDirectiveReader.createPrefixURIMap(flatModel, false);
    }

    private static Map createPrefixURIMap(IStructuredDocument flatModel, boolean dirPrefix2URI) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        IStructuredDocumentRegion[] nodes = flatModel.getStructuredDocumentRegions();
        int nNode = nodes.length;
        int i = 0;
        while (i < nNode) {
            IStructuredDocumentRegion node = nodes[i];
            if (node.getType() == "JSP_DIRECTIVE_NAME") {
                ITextRegionList regions = node.getRegions();
                int nRegion = regions.size();
                String prefix = null;
                String uri = null;
                String attrName = null;
                int j = 0;
                while (j < nRegion) {
                    ITextRegion r = regions.get(j);
                    String type = r.getType();
                    if (type == "JSP_DIRECTIVE_NAME") {
                        if (!NAME_TAGLIB.equals(node.getText(r))) {
                            break;
                        }
                    } else if (type == "XML_TAG_ATTRIBUTE_NAME") {
                        attrName = node.getText(r);
                    } else if (type == "XML_TAG_ATTRIBUTE_VALUE") {
                        if (NAME_URI.equals(attrName)) {
                            uri = StringUtils.strip((String)node.getFullText(r));
                        } else if (NAME_PREFIX.equals(attrName)) {
                            prefix = StringUtils.strip((String)node.getFullText(r));
                        }
                        if (uri != null && prefix != null) {
                            if (dirPrefix2URI) {
                                result.put(prefix, uri);
                            } else if (!result.containsKey(uri)) {
                                result.put(uri, prefix);
                            }
                            prefix = null;
                            uri = null;
                            break;
                        }
                        attrName = null;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(result);
    }

    public static String getPrefixForUri(String uri, String defaultPrefix, IDOMModel model) {
        String prefix = defaultPrefix;
        if (uri == null) {
            return prefix;
        }
        Object[] taglibs = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
        int i = 0;
        while (i < taglibs.length) {
            ITaglibDirective tld;
            Object object = taglibs[i];
            if (object instanceof ITaglibDirective && uri.equals((tld = (ITaglibDirective)object).getURI())) {
                return tld.getPrefix();
            }
            ++i;
        }
        return prefix;
    }
}

