/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeFactory;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTemplateUtil;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelManager;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class SitePageInfoUtil
extends SiteResourceUtil {
    public static boolean getPageInfo(IStructuredDocument flatModel, IFile file, List title, List linkedCSS, List keywords, List description, List author, List abst) {
        if (flatModel == null) {
            return false;
        }
        TagNodeFactory factory = TagNodeFactory.getDefFactory(file);
        String STYLESHEET = "stylesheet";
        String KEYWORDS = "keywords";
        String DESCRIPTION = "description";
        String AUTHOR = "author";
        String ABSTRACT = "abstract";
        boolean found_title = false;
        boolean found_keywords = false;
        boolean found_description = false;
        boolean found_author = false;
        boolean found_abstract = false;
        IStructuredDocumentRegion[] nodeArray = SiteTemplateUtil.getContentAreaRegions(flatModel, file);
        int nNode = nodeArray.length;
        int i = 0;
        while (i < nNode) {
            IStructuredDocumentRegion node = nodeArray[i];
            if (node != null && node.getType() == "XML_TAG_NAME") {
                if (!found_title && SitePageInfoUtil.isSpecifiedNode(node, "title")) {
                    ITextRegion r;
                    String type;
                    Iterator it;
                    IStructuredDocumentRegion titleNode = nodeArray[i + 1];
                    if (titleNode != null && (it = titleNode.getRegions().iterator()).hasNext() && "XML_CONTENT" == (type = (r = (ITextRegion)it.next()).getType())) {
                        String strTitle = titleNode.getText(r);
                        title.add(strTitle);
                    }
                } else {
                    TagNode metaTag;
                    TagNode linkTag = TagParser.parseNormal(node, "LINK", true, factory);
                    if (linkTag != null) {
                        String value = linkTag.getAttr("rel");
                        if ((value = value.toLowerCase(Locale.US)) != null && value.length() != 0) {
                            value = StringUtils.stripQuotes((String)value);
                        }
                        if (STYLESHEET.equalsIgnoreCase(value)) {
                            String attr = linkTag.getAttr("href");
                            attr = StringUtils.stripQuotes((String)attr);
                            linkedCSS.add(attr);
                        }
                    } else if (!(found_keywords && found_description && found_author && found_abstract || (metaTag = TagParser.parseNormal(node, "META", true, factory)) == null)) {
                        String attr;
                        String value = metaTag.getAttr("name");
                        if ((value = value.toLowerCase(Locale.US)) != null && value.length() != 0) {
                            value = StringUtils.stripQuotes((String)value);
                        }
                        if (!found_keywords && KEYWORDS.equalsIgnoreCase(value)) {
                            attr = metaTag.getAttr("content");
                            attr = StringUtils.stripQuotes((String)attr);
                            keywords.add(attr);
                        }
                        if (!found_description && DESCRIPTION.equalsIgnoreCase(value)) {
                            attr = metaTag.getAttr("content");
                            attr = StringUtils.stripQuotes((String)attr);
                            description.add(attr);
                        }
                        if (!found_author && AUTHOR.equalsIgnoreCase(value)) {
                            attr = metaTag.getAttr("content");
                            attr = StringUtils.stripQuotes((String)attr);
                            author.add(attr);
                        }
                        if (!found_abstract && ABSTRACT.equalsIgnoreCase(value)) {
                            attr = metaTag.getAttr("content");
                            attr = StringUtils.stripQuotes((String)attr);
                            abst.add(attr);
                        }
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public static String getUnformatedDate(IPath fullpath) {
        String rtn = "";
        long modified = fullpath.toFile().lastModified();
        if (modified != 0L) {
            rtn = String.valueOf(modified);
        }
        return rtn;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean isSpecifiedNode(IStructuredDocumentRegion node, String tag) {
        it = node.getRegions().iterator();
        while (it.hasNext()) {
            r = (ITextRegion)it.next();
            type = r.getType();
            if ("XML_TAG_OPEN" == type || "XML_END_TAG_OPEN" == type) break;
        }
        if (it.hasNext()) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            r = (ITextRegion)it.next();
            type = r.getType();
            if ("XML_TAG_NAME" != type) continue;
            tagName = node.getText(r);
            return tagName != null && tagName.equalsIgnoreCase(tag) != false;
lbl14:
            // 2 sources

            ** while (it.hasNext())
        }
lbl15:
        // 1 sources

        return false;
    }

    public static boolean hasSiteStructure(IVirtualComponent component) {
        return SitePageInfoUtil.getSiteModel(component) != null;
    }

    public static SiteModel getSiteModel(IVirtualComponent component) {
        SiteModelContainer modelContainer = SiteModelManager.getDefault().getModelContainerForRead(component);
        if (modelContainer == null) {
            return null;
        }
        try {
            SiteModel siteModel = modelContainer.getSiteModel();
            if (siteModel.numberOfChildren() == 0) {
                return null;
            }
            SiteModel siteModel2 = siteModel;
            return siteModel2;
        }
        finally {
            modelContainer.release();
        }
    }
}

