/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.ResourceHandler;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.site.model.LinkModel;
import com.ibm.etools.siteedit.site.model.NavItemSiteComponent;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import com.ibm.etools.siteedit.util.ResizableMessageDialog;
import com.ibm.etools.webedit.viewer.utils.ModelAdapterFactoryRegistry;
import com.ibm.etools.webedit.viewer.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.readonly.ReadOnlyNodeAdapterFactoryProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryProvider;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class SiteModelUtil {
    private IModelManager modelManager = null;
    private ModelManagerUtil mmu = null;
    private Shell shell = null;
    private String _UI_Encoding_warning = ResourceHandler._UI_UTIL_Encoding_warning_1;
    private String _UI_Encoding_warning_on_file = ResourceHandler._UI_UTIL_Encoding_warning_on_saving__0__2;
    private String _UI_cannot_convert_some_characters = ResourceHandler._UI_UTIL_The_encoding___0___cannot_convert_some_characters__such_as_the_one_in_position__1____1;

    public SiteModelUtil() {
        this.getShell();
        this.modelManager = SiteModelUtil.getModelManager();
        this.mmu = new ModelManagerUtil(this.shell, "");
    }

    private Shell getShell() {
        IWorkbenchWindow ww;
        IWorkbench wb = SiteCorePlugin.getDefault().getWorkbench();
        if (wb != null && (ww = wb.getActiveWorkbenchWindow()) != null) {
            this.shell = ww.getShell();
            return this.shell;
        }
        return null;
    }

    public IStructuredModel getNewModelForEdit(IFile ifile) {
        IStructuredModel model = null;
        try {
            byte[] outputbytes = new byte[]{};
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputbytes);
            if (ifile.exists()) {
                ifile.setContents((InputStream)inputStream, true, false, null);
            } else {
                ifile.create((InputStream)inputStream, true, null);
            }
            inputStream.close();
        }
        catch (CoreException exception) {
            Logger.log(exception);
        }
        catch (IOException exception) {
            Logger.log(exception);
        }
        try {
            model = this.modelManager.getModelForEdit(ifile);
        }
        catch (CoreException exception) {
            Logger.log(exception);
        }
        catch (IOException exception) {
            Logger.log(exception);
        }
        ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)model);
        return model;
    }

    public IStructuredModel getNewModelForRead(IFile ifile) {
        IStructuredModel model = null;
        try {
            byte[] outputbytes = new byte[]{};
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputbytes);
            if (ifile.exists()) {
                ifile.setContents((InputStream)inputStream, true, false, null);
            } else {
                ifile.create((InputStream)inputStream, true, null);
            }
            inputStream.close();
        }
        catch (CoreException exception) {
            Logger.log(exception);
        }
        catch (IOException exception) {
            Logger.log(exception);
        }
        try {
            model = this.modelManager.getModelForRead(ifile);
        }
        catch (CoreException exception) {
            Logger.log(exception);
        }
        catch (IOException exception) {
            Logger.log(exception);
        }
        ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)model);
        return model;
    }

    public IDOMModel getModelForEdit(IFile input) {
        IDOMModel model = null;
        model = (IDOMModel)this._getModel(input, false);
        ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)model);
        return model;
    }

    public IDOMModel getModelForRead(IFile input, boolean bCreate) {
        IDOMModel model = null;
        model = (IDOMModel)this._getModel(input, true);
        if (model == null && bCreate && (model = (IDOMModel)this.mmu.getNewModelForRead(input)) != null) {
            this.saveModel(input, model);
        }
        ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)model);
        return model;
    }

    public IDOMModel getModelForRead(IFile input, boolean bCreate, boolean getOpenedModel) {
        IDOMModel model = null;
        if (getOpenedModel) {
            model = (IDOMModel)this.modelManager.getExistingModelForRead(input);
        }
        if (model == null) {
            model = (IDOMModel)this._getModel(input, true);
        }
        if (model == null && bCreate) {
            model = (IDOMModel)this.getNewModelForRead(input);
        }
        ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)model);
        return model;
    }

    public IDOMModel getModelForRead(IPath fullPath) {
        IDOMModel model = null;
        if (this.mmu != null) {
            model = (IDOMModel)this.mmu.getModelForRead(fullPath);
        }
        return model;
    }

    /*
     * Loose catch block
     */
    public boolean saveModel(IFile file, IDOMModel model) {
        block38: {
            OutputStream outStream = null;
            try {
                try {
                    outStream = new ByteArrayOutputStream(model.getStructuredDocument().getLength());
                    model.save(outStream);
                    byte[] outputbytes = ((ByteArrayOutputStream)outStream).toByteArray();
                    outStream.close();
                    outStream = null;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputbytes);
                    if (file.exists()) {
                        file.setContents((InputStream)inputStream, true, false, null);
                    } else {
                        file.create((InputStream)inputStream, true, null);
                    }
                    inputStream.close();
                }
                catch (CoreException exception) {
                    Logger.log(exception);
                    if (outStream == null) break block38;
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (MalformedOutputExceptionWithDetail exception) {
                    block39: {
                        block40: {
                            boolean userOK = this.openUnconvertableCharactersWarningForSave(exception, file, null);
                            if (userOK) {
                                try {
                                    try {
                                        model.save(outStream);
                                    }
                                    catch (CoreException e) {
                                        Logger.log(e);
                                    }
                                    byte[] outputbytes = ((ByteArrayOutputStream)outStream).toByteArray();
                                    outStream.close();
                                    outStream = null;
                                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputbytes);
                                    if (file.exists()) {
                                        try {
                                            file.setContents((InputStream)inputStream, true, false, null);
                                        }
                                        catch (CoreException e) {
                                            Logger.log(e);
                                        }
                                    } else {
                                        try {
                                            file.create((InputStream)inputStream, true, null);
                                        }
                                        catch (CoreException e) {
                                            Logger.log(e);
                                        }
                                    }
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    Logger.log(e);
                                }
                                break block39;
                            }
                            try {
                                if (outStream != null) {
                                    outStream.close();
                                }
                            }
                            catch (IOException e) {
                                Logger.log(e);
                            }
                            if ((outStream = null) == null) break block40;
                            try {
                                outStream.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return false;
                    }
                    if (outStream == null) break block38;
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (IOException exception) {
                    Logger.log(exception);
                    if (outStream == null) break block38;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return true;
    }

    private IStructuredModel _getModel(IFile input, boolean bReadOnly) {
        IStructuredModel model = null;
        try {
            model = bReadOnly ? this.modelManager.getModelForRead(input) : this.modelManager.getModelForEdit(input);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return model;
    }

    public static boolean addReadOnlyAdapter(IDOMModel model) {
        boolean ret = true;
        if (model == null) {
            return false;
        }
        IDOMModel smodel = model;
        SSEUIPlugin plugin = SSEUIPlugin.getDefault();
        AdapterFactoryRegistry adapterRegistry = plugin.getAdapterFactoryRegistry();
        Iterator adapterList = adapterRegistry.getAdapterFactories();
        while (adapterList.hasNext()) {
            try {
                AdapterFactoryProvider provider = (AdapterFactoryProvider)adapterList.next();
                if (!(provider instanceof ReadOnlyNodeAdapterFactoryProvider) || !provider.isFor((IDocumentTypeHandler)smodel.getModelHandler())) continue;
                provider.addAdapterFactories((IStructuredModel)smodel);
            }
            catch (Exception e) {
                Logger.log(e);
                ret = false;
            }
        }
        return ret;
    }

    private boolean openUnconvertableCharactersWarningForSave(MalformedOutputExceptionWithDetail outputException, IFile file, Shell shell) {
        String title = this._UI_Encoding_warning;
        if (file != null) {
            title = NLS.bind((String)this._UI_Encoding_warning_on_file, (Object)file.getName());
        }
        String msg = NLS.bind((String)this._UI_cannot_convert_some_characters, (Object)outputException.getAttemptedIANAEncoding(), (Object)Integer.toString(outputException.getCharPosition()));
        ResizableMessageDialog warning = new ResizableMessageDialog(shell, title, null, msg, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return warning.open() == 0;
    }

    public static String getSRC(SiteComponent model) {
        String rtn = "";
        if (model instanceof PageModel) {
            rtn = ((PageModel)model).getSRC();
        } else if (model instanceof SharedPageModel) {
            rtn = ((SharedPageModel)model).getSRC();
        } else if (model instanceof LinkModel) {
            rtn = ((LinkModel)model).getSRC();
        }
        return rtn;
    }

    public static String getId(SiteComponent model) {
        String rtn = "";
        if (model instanceof PageModel) {
            rtn = ((PageModel)model).getId();
        } else if (model instanceof LinkModel) {
            rtn = ((LinkModel)model).getId();
        } else if (model instanceof SharedPageModel) {
            rtn = ((SharedPageModel)model).getId();
        }
        return rtn;
    }

    public static String getServletUrl(SiteComponent model) {
        String rtn = "";
        if (model instanceof PageModel) {
            rtn = ((PageModel)model).getServletUrl();
        }
        return rtn;
    }

    public static boolean getNavigation(SiteComponent model) {
        boolean rtn = false;
        if (model instanceof NavItemSiteComponent) {
            rtn = ((NavItemSiteComponent)model).getNavigation();
        }
        return rtn;
    }

    public static void setNavigation(SiteComponent model, boolean set) {
        if (model instanceof NavItemSiteComponent) {
            ((NavItemSiteComponent)model).setNavigation(set);
        }
    }

    public static boolean getSiteMap(SiteComponent model) {
        boolean rtn = false;
        if (model instanceof NavItemSiteComponent) {
            rtn = ((NavItemSiteComponent)model).getSiteMap();
        }
        return rtn;
    }

    public static void setSiteMap(SiteComponent model, boolean set) {
        if (model instanceof NavItemSiteComponent) {
            ((NavItemSiteComponent)model).setSiteMap(set);
        }
    }

    public static String getTitle(SiteComponent model) {
        String rtn = "";
        if (model instanceof NavItemSiteComponent) {
            rtn = ((NavItemSiteComponent)model).getTitle();
        } else if (model instanceof WebprojectModel) {
            rtn = ((WebprojectModel)model).getSRC();
        }
        return rtn;
    }

    public static boolean hasAuthorProperty(SiteComponent model) {
        return model instanceof PageModel || model instanceof SiteModel;
    }

    public static String getAuthor(SiteComponent model) {
        String rtn = "";
        if (model instanceof PageModel) {
            rtn = ((PageModel)model).getAuthor();
        } else if (model instanceof SiteModel) {
            rtn = ((SiteModel)model).getAuthor();
        }
        return rtn;
    }

    public static String getStatus(SiteComponent model) {
        String rtn = "";
        if (model instanceof PageModel) {
            rtn = ((PageModel)model).getDocStatus();
        }
        return rtn;
    }

    public static void setId(SiteComponent model, int id) {
        if (model instanceof PageModel) {
            ((PageModel)model).setId(id);
        } else if (model instanceof LinkModel) {
            ((LinkModel)model).setId(id);
        } else if (model instanceof SharedPageModel) {
            ((SharedPageModel)model).setId(id);
        }
    }

    public static IModelManager getModelManager() {
        IModelManager mm = StructuredModelManager.getModelManager();
        return mm;
    }
}

