/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.internal.builder.util.BuildUtil;
import com.ibm.etools.siteedit.internal.core.util.EditorUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteModelResUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTemplateUtil;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModelProperty;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class SiteModelTemplateUtil {
    private EditorUtil editorUtil;

    private SiteModelTemplateUtil() {
    }

    protected EditorUtil getEditorUtil() {
        if (this.editorUtil == null) {
            this.editorUtil = new EditorUtil();
        }
        return this.editorUtil;
    }

    public static boolean updateWithoutSession(SiteComponent c) {
        SiteModelTemplateUtil u = SiteModelTemplateUtil.create();
        return u.updatePageTemplate(c);
    }

    public static void observePartWithoutSession(IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        SiteModelTemplateUtil u = SiteModelTemplateUtil.create();
        u.getEditorUtil().observePart(file);
    }

    public boolean updatePageTemplate(SiteComponent c) {
        String oldTemplateString;
        if (!(c instanceof PageModel)) {
            return false;
        }
        IFile file = SiteModelResUtil.getIFile(c);
        if (file == null || !file.exists()) {
            return false;
        }
        String newTemplateString = oldTemplateString = ((PageModel)c).getTemplate();
        IDocument activeDocument = this.getEditorUtil().getDirtyDocument(file);
        if (activeDocument != null) {
            if (activeDocument instanceof IStructuredDocument) {
                newTemplateString = SiteModelTemplateUtil.getTemplateStringOf((IStructuredDocument)activeDocument, file.getLocation());
            }
        } else {
            newTemplateString = BuildUtil.getPageTemplate(file);
            if (newTemplateString == null) {
                newTemplateString = "";
            }
        }
        if (activeDocument != null) {
            this.getEditorUtil().observePart(file, c);
        }
        if (!newTemplateString.equals(oldTemplateString)) {
            ((PageModel)c).setTemplate(newTemplateString);
            return true;
        }
        return false;
    }

    public static SiteModelTemplateUtil create() {
        return new SiteModelTemplateUtil();
    }

    public static String getTemplateStringOf(IStructuredDocument instanceModel, IPath location) {
        Object template = SiteTemplateUtil.getRawTemplate(instanceModel, location).getTemplate();
        if (template == null) {
            return "";
        }
        return SiteTemplateUtil.encodeTemplateString(template);
    }

    public static Object getTemplateObject(SiteComponent sc) {
        if (!SiteModelProperty.PAGE_TEMPLATE.isPropertyFor(sc)) {
            return null;
        }
        String template = sc.getStringProperty(SiteModelProperty.PAGE_TEMPLATE);
        if (template == null || template.length() == 0) {
            return null;
        }
        IVirtualComponent component = SiteModelResUtil.getComponent(sc);
        return SiteTemplateUtil.decodeTemplateString(template, component);
    }

    public static IFile getTemplateFile(SiteComponent sc) {
        Object template = SiteModelTemplateUtil.getTemplateObject(sc);
        return SiteTemplateUtil.getTemplateFile(template);
    }

    public static boolean isDynamicTemplateApplied(SiteComponent sc) {
        if (!SiteModelProperty.PAGE_TEMPLATE.isPropertyFor(sc)) {
            return false;
        }
        String template = sc.getStringProperty(SiteModelProperty.PAGE_TEMPLATE);
        if (template == null || template.length() == 0) {
            return false;
        }
        return template.startsWith("tiles:");
    }

    public static String getTemplateDisplayString(SiteComponent sc) {
        if (!SiteModelProperty.PAGE_TEMPLATE.isPropertyFor(sc)) {
            return "";
        }
        String template = sc.getStringProperty(SiteModelProperty.PAGE_TEMPLATE);
        if (template == null || template.length() == 0) {
            return "";
        }
        if (template.startsWith("/")) {
            return template;
        }
        if (template.startsWith("tiles:")) {
            int indexFile = 6;
            int indexSharp = template.indexOf(35);
            String nameString = template.substring(indexSharp + 1);
            if (nameString.length() > 0) {
                return nameString;
            }
            String fileString = template.substring(indexFile, indexSharp);
            return fileString;
        }
        return template;
    }

    public static String getTemplateDisplayStringShort(SiteComponent sc) {
        if (!SiteModelProperty.PAGE_TEMPLATE.isPropertyFor(sc)) {
            return "";
        }
        String template = sc.getStringProperty(SiteModelProperty.PAGE_TEMPLATE);
        if (template == null || template.length() == 0) {
            return "";
        }
        if (template.startsWith("/")) {
            return SiteResourceUtil.getFileName(template);
        }
        if (template.startsWith("tiles:")) {
            int indexFile = 6;
            int indexSharp = template.indexOf(35);
            String nameString = template.substring(indexSharp + 1);
            if (nameString.length() > 0) {
                return nameString;
            }
            String fileString = template.substring(indexFile, indexSharp);
            return SiteResourceUtil.getFileName(fileString);
        }
        return template;
    }
}

