/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.preference;

import com.ibm.etools.siteedit.core.SiteCorePlugin;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SitePreferenceManager
extends AbstractPreferenceInitializer {
    private static final String APPEARANCE = "appearance";
    public static final String DISPLAY_TITLE = "displayTitle";
    public static final String DISPLAY_ICON_TRAY = "displayIconTray";
    private static final String DISPLAY_ICON_TRAY_TYPO = "displayIconTary";
    public static final String DISPLAY_FILENAME = "displayFilename";
    public static final String DISPLAY_TEMPLATE = "displayPagetemplate";
    public static final String DISPLAY_NUMBER = "displayNumber";
    private static final String TEMPLATE_COLOR = "templateColor";
    private static final String LAYOUT_MODE = "layoutMode";
    private static final String MIX_START_LEVEL = "mixStartLevel";
    private static final String RTL_MODE = "rightToLeftMode";
    private static final String DEFAULT_PAGE = "defaultPage";
    private static final String NAV_BUILDER = "navBuilder";
    private static final String SHOW_READONLY_PROMPT = "showReadonlyPrompt";
    private static final String EXTENSION = "extension";
    private static final String UPDATE_NAVBAR = "updateNavbarOnEditing";
    public static final int LAYOUT_MIN = 1;
    public static final int LAYOUT_HORZ = 1;
    public static final int LAYOUT_VERT = 2;
    public static final int LAYOUT_MAX = 2;
    public static final String linkCrawlDefaultPage = "index.html";
    public static final String defaultTemplateColor = "#A0C8F0";

    private static final AbstractUIPlugin getPlugin() {
        return SiteCorePlugin.getDefault();
    }

    public static final void addPreferenceChangeListener(IPropertyChangeListener listener) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.addPropertyChangeListener(listener);
    }

    public static final void removePreferenceChangeListener(IPropertyChangeListener listener) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.removePropertyChangeListener(listener);
    }

    public static final void save() {
        SitePreferenceManager.getPlugin().savePluginPreferences();
    }

    public final void initializeDefaultPreferences() {
        SitePreferenceManager.setDefault(APPEARANCE, LAYOUT_MODE, 1);
        SitePreferenceManager.setDefault(APPEARANCE, MIX_START_LEVEL, 3);
        SitePreferenceManager.setDefault(APPEARANCE, DEFAULT_PAGE, linkCrawlDefaultPage);
        SitePreferenceManager.setDefault(APPEARANCE, DISPLAY_TITLE, true);
        SitePreferenceManager.setDefault(APPEARANCE, DISPLAY_ICON_TRAY, true);
        SitePreferenceManager.setDefault(APPEARANCE, DISPLAY_FILENAME, true);
        SitePreferenceManager.setDefault(APPEARANCE, DISPLAY_TEMPLATE, false);
        SitePreferenceManager.setDefault(APPEARANCE, DISPLAY_NUMBER, false);
        SitePreferenceManager.setDefault(APPEARANCE, TEMPLATE_COLOR, defaultTemplateColor);
        SitePreferenceManager.setDefault(APPEARANCE, RTL_MODE, false);
        SitePreferenceManager.setDefault(NAV_BUILDER, SHOW_READONLY_PROMPT, true);
        SitePreferenceManager.setDefault(EXTENSION, UPDATE_NAVBAR, true);
        SitePreferenceManager.migrate();
    }

    private static final void migrate() {
        File file = SitePreferenceManager.getStateLocation("com.ibm.etools.siteedit").append("siteprefs.xml").toFile();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            Node settings = document.getFirstChild();
            NodeList list = settings.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (APPEARANCE.equals(name) || NAV_BUILDER.equals(name)) {
                    NamedNodeMap attr = ((Element)node).getAttributes();
                    int j = 0;
                    while (j < attr.getLength()) {
                        String key = attr.item(j).getNodeName();
                        String value = attr.item(j).getNodeValue();
                        try {
                            if (LAYOUT_MODE.equals(key)) {
                                SitePreferenceManager.setLayoutMode(Integer.parseInt(value));
                            } else if (MIX_START_LEVEL.equals(key)) {
                                SitePreferenceManager.setMixStartLevel(Integer.parseInt(value));
                            } else if (DEFAULT_PAGE.equals(key)) {
                                SitePreferenceManager.setDefaultPage(value);
                            } else if (DISPLAY_TITLE.equals(key)) {
                                SitePreferenceManager.setDisplayTitle(SitePreferenceManager.parseBoolean(value));
                            } else if (DISPLAY_ICON_TRAY_TYPO.equals(key)) {
                                SitePreferenceManager.setDisplayIconTray(SitePreferenceManager.parseBoolean(value));
                            } else if (DISPLAY_FILENAME.equals(key)) {
                                SitePreferenceManager.setDisplayFilename(SitePreferenceManager.parseBoolean(value));
                            } else if (DISPLAY_TEMPLATE.equals(key)) {
                                SitePreferenceManager.setDisplayPagetemplate(SitePreferenceManager.parseBoolean(value));
                            } else if (DISPLAY_NUMBER.equals(key)) {
                                SitePreferenceManager.setDisplayNumber(SitePreferenceManager.parseBoolean(value));
                            } else if (TEMPLATE_COLOR.equals(key)) {
                                SitePreferenceManager.setTemplatePageColor(value);
                            } else if (RTL_MODE.equals(key)) {
                                SitePreferenceManager.setRightToLeftMode(SitePreferenceManager.parseBoolean(value));
                            } else if (SHOW_READONLY_PROMPT.equals(key)) {
                                SitePreferenceManager.setBuilderShowReadOnlyPrompt(SitePreferenceManager.parseBoolean(value));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        ++j;
                    }
                }
                ++i;
            }
            SitePreferenceManager.save();
            file.delete();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {}
    }

    private static final boolean parseBoolean(String value) {
        return Boolean.valueOf(value);
    }

    private static final IPath getStateLocation(String plugin) {
        IPath metadata = SitePreferenceManager.getPlugin().getStateLocation().removeLastSegments(1);
        return metadata.append(plugin);
    }

    public static final void setLayoutMode(int mode) {
        SitePreferenceManager.setValue(APPEARANCE, LAYOUT_MODE, mode);
    }

    public static final void setMixStartLevel(int level) {
        SitePreferenceManager.setValue(APPEARANCE, MIX_START_LEVEL, level);
    }

    public static final void setDefaultPage(String defaultPage) {
        SitePreferenceManager.setValue(APPEARANCE, DEFAULT_PAGE, defaultPage);
    }

    public static final void setDisplayTitle(boolean b) {
        SitePreferenceManager.setValue(APPEARANCE, DISPLAY_TITLE, b);
    }

    public static final void setDisplayIconTray(boolean b) {
        SitePreferenceManager.setValue(APPEARANCE, DISPLAY_ICON_TRAY, b);
    }

    public static final void setDisplayFilename(boolean b) {
        SitePreferenceManager.setValue(APPEARANCE, DISPLAY_FILENAME, b);
    }

    public static final void setDisplayPagetemplate(boolean b) {
        SitePreferenceManager.setValue(APPEARANCE, DISPLAY_TEMPLATE, b);
    }

    public static final void setDisplayNumber(boolean b) {
        SitePreferenceManager.setValue(APPEARANCE, DISPLAY_NUMBER, b);
    }

    public static final void setTemplatePageColor(String color) {
        SitePreferenceManager.setValue(APPEARANCE, TEMPLATE_COLOR, color);
    }

    public static final void setRightToLeftMode(boolean b) {
        SitePreferenceManager.setValue(APPEARANCE, RTL_MODE, b);
    }

    public static final void setBuilderShowReadOnlyPrompt(boolean b) {
        SitePreferenceManager.setValue(NAV_BUILDER, SHOW_READONLY_PROMPT, b);
    }

    public static final int layoutMode() {
        return SitePreferenceManager.getInt(APPEARANCE, LAYOUT_MODE);
    }

    public static final int mixStartLevel() {
        return SitePreferenceManager.getInt(APPEARANCE, MIX_START_LEVEL);
    }

    public static final String defaultPage() {
        return SitePreferenceManager.getString(APPEARANCE, DEFAULT_PAGE);
    }

    public static final boolean displayTitle() {
        return true;
    }

    public static final boolean displayFilename() {
        return SitePreferenceManager.getBoolean(APPEARANCE, DISPLAY_FILENAME);
    }

    public static final boolean displayIconTray() {
        return SitePreferenceManager.getBoolean(APPEARANCE, DISPLAY_ICON_TRAY);
    }

    public static final boolean displayPagetemplate() {
        return SitePreferenceManager.getBoolean(APPEARANCE, DISPLAY_TEMPLATE);
    }

    public static final boolean displayNumber() {
        return SitePreferenceManager.getBoolean(APPEARANCE, DISPLAY_NUMBER);
    }

    public static final String pageTemplateColor() {
        return SitePreferenceManager.getString(APPEARANCE, TEMPLATE_COLOR);
    }

    public static final boolean rightToLeftMode() {
        return SitePreferenceManager.getBoolean(APPEARANCE, RTL_MODE);
    }

    public static final boolean isBuilderShowReadOnlyPrompt() {
        return SitePreferenceManager.getBoolean(NAV_BUILDER, SHOW_READONLY_PROMPT);
    }

    public static final boolean updateNavbarOnEditing() {
        return SitePreferenceManager.getBoolean(EXTENSION, UPDATE_NAVBAR);
    }

    public static boolean getDisplayPreference(String preferenceKey) {
        return SitePreferenceManager.getBoolean(APPEARANCE, preferenceKey);
    }

    public static void setDisplayPreference(String preferenceKey, boolean value) {
        SitePreferenceManager.setValue(APPEARANCE, preferenceKey, value);
    }

    private static final void setDefault(String category, String name, boolean value) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.setDefault(SitePreferenceManager.key(category, name), value);
    }

    private static final void setDefault(String category, String name, int value) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.setDefault(SitePreferenceManager.key(category, name), value);
    }

    private static final void setDefault(String category, String name, String value) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.setDefault(SitePreferenceManager.key(category, name), value);
    }

    private static final void setValue(String category, String name, boolean value) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.setValue(SitePreferenceManager.key(category, name), value);
    }

    private static final void setValue(String category, String name, int value) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.setValue(SitePreferenceManager.key(category, name), value);
    }

    private static final void setValue(String category, String name, String value) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        store.setValue(SitePreferenceManager.key(category, name), value);
    }

    private static final boolean getBoolean(String category, String name) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        return store.getBoolean(SitePreferenceManager.key(category, name));
    }

    private static final int getInt(String category, String name) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        return store.getInt(SitePreferenceManager.key(category, name));
    }

    private static final String getString(String category, String name) {
        IPreferenceStore store = SitePreferenceManager.getPlugin().getPreferenceStore();
        return store.getString(SitePreferenceManager.key(category, name));
    }

    private static final String key(String category, String name) {
        return String.valueOf(category) + '.' + name;
    }
}

