/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import com.ibm.etools.siteedit.internal.builder.model.SitePageOverrideTemplateModel;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import com.ibm.etools.siteedit.internal.builder.util.FileContext;
import com.ibm.etools.siteedit.internal.core.util.SiteFileTypeUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTemplateUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class FileContextForLiveDocument
extends FileContext {
    private IStructuredDocument document;

    FileContextForLiveDocument(IFile file, IStructuredDocument document, BuildContext buildContext) {
        super(file, buildContext);
        this.document = document;
    }

    @Override
    protected SitePageModel createSitePageModel() {
        boolean isTemplate;
        SitePageModel result = super.createSitePageModel();
        if (result != null && SiteFileTypeUtil.whatKindOfFile(this.getFile().getFullPath()) == 2 && (isTemplate = SiteTemplateUtil.isTemplate(this.document, this.getFile().getLocation())) != result.isTemplate()) {
            SitePageOverrideTemplateModel m = new SitePageOverrideTemplateModel(result);
            m.setOverrideTemplate(isTemplate);
            result = m;
        }
        return result;
    }
}

