/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.GSStructure;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import org.eclipse.core.resources.IFile;

public class FileContext {
    private final IFile file;
    private final BuildContext buildContext;
    private boolean canCreateSitePageModel = true;
    private SitePageModel sitePageModel;
    private boolean canCreateGSPage = true;
    private GSPage gsPage;

    FileContext(IFile file, BuildContext buildContext) {
        this.file = file;
        this.buildContext = buildContext;
    }

    public IFile getFile() {
        return this.file;
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public SitePageModel getSitePageModel() {
        if (this.canCreateSitePageModel) {
            this.canCreateSitePageModel = false;
            this.sitePageModel = this.createSitePageModel();
        }
        return this.sitePageModel;
    }

    protected SitePageModel createSitePageModel() {
        return this.buildContext.getGlobalContext().getPageModelFactory().crate(this.file);
    }

    public GSPage getGSPage() {
        if (this.canCreateGSPage) {
            this.canCreateGSPage = false;
            GSStructure struc = this.buildContext.getGSStructure();
            this.gsPage = struc == null ? null : struc.getPage(this.file);
        }
        return this.gsPage;
    }

    public void waitForWritingFile() {
        if (this.buildContext.needWaitForWritingFile()) {
            this.buildContext.waitForWritingFile();
        }
    }

    public void dispose() {
        if (this.sitePageModel != null) {
            this.sitePageModel.dispose();
        }
    }

    public void setCannotUpdated(boolean b) {
        if (b) {
            this.getBuildContext().addReadonlyFile(this.file);
        } else {
            this.getBuildContext().removeReadonlyFile(this.file);
        }
    }
}

