/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.SitePageBuildOperator;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import com.ibm.etools.siteedit.internal.builder.util.FileContext;
import com.ibm.etools.siteedit.internal.builder.util.GlobalContext;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Element;

public final class BuildUtil {
    private BuildUtil() {
    }

    public static boolean updateNavigationBar(IFile file) {
        GlobalContext gc = GlobalContext.getInstance();
        BuildContext bc = gc.getBuildContext(WebComponentUtil.findComponent((IResource)file));
        try {
            SitePageBuildOperator so = bc.getPageBuildOperator();
            boolean result = so.build(bc.getFileContext(file));
            ArrayList<IFile> ar = new ArrayList<IFile>(1);
            ar.add(file);
            ReferenceManager.getReferenceManager().requestAnalysis((Set)((Object)ar), null);
            boolean bl = result;
            return bl;
        }
        catch (SiteNavException e) {
            Logger.log(e);
        }
        finally {
            bc.dispose();
        }
        return false;
    }

    public static String getVisual(Element elm, IFile file, Map pagedata) {
        IStructuredModel model = SiteModelUtil.getModelManager().getExistingModelForRead(file);
        try {
            GlobalContext gc = GlobalContext.getInstance();
            BuildContext bc = gc.getBuildContext(WebComponentUtil.findComponent((IResource)file));
            FileContext fc = bc.getFileContext(file, model == null ? null : model.getStructuredDocument());
            try {
                if (!elm.getPrefix().equals("siteedit")) {
                    elm.setPrefix("siteedit");
                }
                NavElement ne = NavElement.getFactory(file).create(elm);
                SitePageBuildOperator so = bc.getPageBuildOperator();
                String string = so.getVisual(fc, ne, pagedata);
                fc.dispose();
                bc.dispose();
                return string;
            }
            catch (Throwable throwable) {
                fc.dispose();
                bc.dispose();
                throw throwable;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static boolean hasNav(IFile file) {
        if (file == null) {
            return true;
        }
        return GlobalContext.getInstance().getPageModelFactory().hasNav(file);
    }

    public static String getPageTemplate(IFile file) {
        if (file == null) {
            return null;
        }
        return GlobalContext.getInstance().getPageModelFactory().internalGetPageTemplate(file);
    }

    public static boolean isTemplate(IFile file) {
        if (file == null) {
            return false;
        }
        return GlobalContext.getInstance().getPageModelFactory().internalIsTemplate(file);
    }
}

