/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavException;
import com.ibm.etools.siteedit.internal.builder.model.SitePageFlatModel;
import com.ibm.etools.siteedit.internal.builder.model.SitePageModel;
import com.ibm.etools.siteedit.internal.builder.util.BuildContext;
import com.ibm.etools.siteedit.internal.builder.util.GlobalContext;
import com.ibm.etools.siteedit.internal.builder.util.LinkRelationOperator;
import com.ibm.etools.siteedit.internal.builder.util.ui.DirtyEditorUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteFileTypeUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class BuildFileCollector {
    private final IVirtualComponent component;
    private Collection deferredTargetFiles;
    private boolean showSaveForDirtyInstance;
    private Collection buildTargetFiles;
    private Collection saveTargetFiles;
    private Collection nextTargetFiles;
    private Map labelDescription;
    private DirtyEditorUtil dirtyEditorUtil = DirtyEditorUtil.Factory.create();
    private static final String TRACE_KEY = "builder/buildfile";

    public BuildFileCollector(BuildContext bc) {
        this(bc.getComponent());
    }

    public BuildFileCollector(IVirtualComponent component) {
        this.component = component;
    }

    public void handleAll() {
        this.handleWithChangedSet(BuildFileCollector.getAllFiles(this.component, null));
    }

    public void handleDelta(IResourceDelta delta, boolean siteXmlUpdated) {
        if (siteXmlUpdated) {
            this.handleAll();
            return;
        }
        this.handleWithChangedSet(BuildFileCollector.getDeltaFiles(delta, this.component, null));
    }

    private void handleWithChangedSet(Collection handleSet) {
        List<IFile> dirtyFiles = Arrays.asList(this.dirtyEditorUtil.getAllDirtyFiles(new IVirtualComponent[]{this.component}));
        Collection dirtyFilesWithNav = this.getFilesWithNav(dirtyFiles);
        if (this.deferredTargetFiles != null) {
            handleSet.addAll(this.deferredTargetFiles);
        }
        handleSet.removeAll(dirtyFiles);
        handleSet.addAll(dirtyFilesWithNav);
        LinkRelationOperator lro = new LinkRelationOperator(handleSet, dirtyFiles, this.component, new LinkRelationOperator.PageModelProvider(){

            @Override
            public SitePageModel createPageModel(IFile file) {
                return BuildFileCollector.this.createPageModel(file);
            }
        });
        this.buildTargetFiles = lro.getRelatedFiles();
        this.buildTargetFiles.removeAll(dirtyFiles);
        this.nextTargetFiles = new HashSet(dirtyFilesWithNav);
        this.nextTargetFiles.retainAll(lro.getRelatedFiles());
        this.saveTargetFiles = new HashSet<IFile>(dirtyFiles);
        if (!this.showSaveForDirtyInstance) {
            this.saveTargetFiles.removeAll(dirtyFilesWithNav);
        }
        this.saveTargetFiles.retainAll(lro.getRelatedFiles());
        this.labelDescription = lro.getDescriptionMap();
        this.labelDescription.keySet().retainAll(this.saveTargetFiles);
        if (BuildFileCollector._isTracing()) {
            BuildFileCollector._trace("BuildFileCollector#handle*** was invoked:");
            PrintStream w = System.out;
            w.println(" changed set: " + handleSet);
            w.println(" deferrd set: " + this.deferredTargetFiles);
            w.println(" buildTarget: " + this.buildTargetFiles);
            w.println(" saveTarget : " + this.saveTargetFiles);
            w.println(" nextTarget : " + this.nextTargetFiles);
            w.println(" (dirty)    : " + dirtyFiles);
            w.println(" ( ..w/ nav): " + dirtyFilesWithNav);
        }
    }

    private Collection getFilesWithNav(Collection c) {
        ArrayList<IFile> result = new ArrayList<IFile>(c.size() / 2);
        for (IFile file : c) {
            if (!this.createPageModel(file).hasNavbar()) continue;
            result.add(file);
        }
        return result;
    }

    SitePageModel createPageModel(IFile file) {
        try {
            IDocument document = this.dirtyEditorUtil.getDirtyDocument(file);
            if (document instanceof IStructuredDocument) {
                return new SitePageFlatModel(file, (IStructuredDocument)document);
            }
            return GlobalContext.getInstance().getPageModelFactory().crate(file);
        }
        catch (SiteNavException siteNavException) {
            return null;
        }
    }

    public void scheduleDeferredDirtyFileSave() {
        if (this.saveTargetFiles.isEmpty()) {
            return;
        }
        this.dirtyEditorUtil.scheduleSaveResources(this.saveTargetFiles.toArray(new IFile[this.saveTargetFiles.size()]), null, this.labelDescription, true);
    }

    public void setDeferredTarget(Collection defferredTargets) {
        this.deferredTargetFiles = defferredTargets;
    }

    public void setShowSaveForDirtyInstance(boolean f) {
        this.showSaveForDirtyInstance = f;
    }

    public Collection getBuildTargetFiles() {
        return BuildFileCollector.removeComponentOutsideFiles(this.buildTargetFiles, this.component);
    }

    public Collection getSaveTargetFiles() {
        return this.saveTargetFiles;
    }

    public Collection getNextTarget() {
        return this.nextTargetFiles;
    }

    public static Collection getAllFiles(IVirtualComponent component, Set candidate) {
        ArrayList result = new ArrayList();
        try {
            IContainer root = WebComponentUtil.getComponentRootFolder(component);
            root.accept((IResourceVisitor)new ResVisitor(result, candidate, component));
        }
        catch (CoreException e) {
            SiteNavBuilderLogger.log(e);
        }
        return result;
    }

    static Collection getDeltaFiles(IResourceDelta delta, IVirtualComponent component, Set candidate) {
        ArrayList result = new ArrayList();
        try {
            delta.accept((IResourceDeltaVisitor)new ResVisitor(result, candidate, component));
        }
        catch (CoreException e) {
            SiteNavBuilderLogger.log(e);
        }
        return result;
    }

    public static boolean isSiteNavBuilderTargetResource(IResource resource) {
        if (resource.getType() == 1) {
            switch (SiteFileTypeUtil.whatKindOfFile(resource.getFullPath())) {
                case 0: 
                case 2: 
                case 7: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInComponentSiteFile(IFile file, IVirtualComponent component, Set allFilesInSite) {
        if (file == null || component == null || allFilesInSite == null) {
            return false;
        }
        return component.equals(WebComponentUtil.findComponent((IResource)file)) && allFilesInSite.contains(SiteResourceUtil.getProjectRelativePathString(component, (IResource)file));
    }

    static Collection removeComponentOutsideFiles(Collection c, IVirtualComponent component) {
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> result = new ArrayList<IFile>(c.size());
        for (IFile file : c) {
            if (!component.equals(WebComponentUtil.findComponent((IResource)file))) continue;
            result.add(file);
        }
        return result;
    }

    static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    static boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }

    private static class ResVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        protected final Collection result;
        protected final Collection candidate;
        protected final IVirtualComponent component;

        public ResVisitor(Collection result, Collection candidate, IVirtualComponent component) {
            this.result = result;
            this.candidate = candidate;
            this.component = component;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getKind() == 2) {
                return false;
            }
            return this.visit(delta.getResource());
        }

        public boolean visit(IResource resource) throws CoreException {
            if (BuildFileCollector.isSiteNavBuilderTargetResource(resource)) {
                String name = SiteResourceUtil.getProjectRelativePathString(this.component, resource);
                if (this.candidate == null || this.candidate.contains(name)) {
                    this.result.add(resource);
                }
            }
            return true;
        }
    }
}

