/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.model.SitePageBuildOperator;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.GSStructure;
import com.ibm.etools.siteedit.internal.builder.site.SiteModelProvider;
import com.ibm.etools.siteedit.internal.builder.site.handler.GSModelHandler;
import com.ibm.etools.siteedit.internal.builder.site.handler.NavTagHandlerFactory;
import com.ibm.etools.siteedit.internal.builder.util.BuildSiteStructureManager;
import com.ibm.etools.siteedit.internal.builder.util.FileContext;
import com.ibm.etools.siteedit.internal.builder.util.FileContextForLiveDocument;
import com.ibm.etools.siteedit.internal.builder.util.GlobalContext;
import com.ibm.etools.siteedit.internal.builder.util.VirtualComponentMap;
import com.ibm.etools.siteedit.internal.builder.util.VirtualComponentSet;
import com.ibm.etools.siteedit.internal.core.util.SiteSubProjectUtil2;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public final class BuildContext {
    private final IVirtualComponent component;
    private final IFile siteXml;
    private final GlobalContext globalContext;
    private GSStructure gsStructure;
    private SitePageBuildOperator buildOperator;
    private VirtualComponentMap component2modelContainer = new VirtualComponentMap(1);
    private ArrayList readOnlyFiles = new ArrayList();
    private Set allFilesInSite;
    private Collection relatedComponents;
    private Boolean siteStructureUpdated;
    private boolean needWaitForFs = true;

    BuildContext(IVirtualComponent component, GlobalContext globalContext) {
        this.component = component;
        this.siteXml = WebComponentUtil.getActiveWebSiteConfigFile(component);
        this.globalContext = globalContext;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public FileContext getFileContext(IFile file) {
        return new FileContext(file, this);
    }

    public FileContext getFileContext(IFile file, IStructuredDocument document) {
        if (document == null) {
            return this.getFileContext(file);
        }
        return new FileContextForLiveDocument(file, document, this);
    }

    public IFile getSiteXml() {
        return this.siteXml;
    }

    public SitePageBuildOperator getPageBuildOperator() {
        if (this.buildOperator == null) {
            this.buildOperator = new SitePageBuildOperator(new NavTagHandlerFactory(new GSModelHandler(){

                @Override
                public GSStructure getGSStructure() {
                    return BuildContext.this.getGSStructure();
                }

                @Override
                public GSPage getGSPage(IFile currentFile) {
                    return BuildContext.this.getGSStructure().getPage(currentFile);
                }
            }, this.globalContext.getNavspecProvider()));
        }
        return this.buildOperator;
    }

    public GSStructure getGSStructure() {
        if (this.gsStructure == null) {
            this.gsStructure = new GSStructure(this.component, new SiteModelProvider(){

                @Override
                public SiteModel getSiteModel(IVirtualComponent component) {
                    return BuildContext.this.getSiteModel(component);
                }

                @Override
                public long getModificationStamp(IVirtualComponent component) {
                    return BuildContext.this.getSiteModificationStamp(component);
                }
            });
        }
        return this.gsStructure;
    }

    public SiteModel getSiteModel(IVirtualComponent component) {
        SiteModelContainer result = (SiteModelContainer)this.component2modelContainer.get(component);
        if (result == null) {
            result = SiteCorePlugin.getDefault().getSiteModelManager().getModelContainerForRead(component);
            this.component2modelContainer.put(component, result);
        }
        return result == null ? null : result.getSiteModel();
    }

    public long getSiteModificationStamp(IVirtualComponent component) {
        if (this.component.equals(component) && this.isSpeculativeBuild()) {
            return -1L;
        }
        IFile siteXml = WebComponentUtil.getActiveWebSiteConfigFile(component);
        if (siteXml != null) {
            return siteXml.getModificationStamp();
        }
        return -1L;
    }

    public BuildSiteStructureManager getSiteStrucMgr() {
        return this.globalContext.getCacheMgr().getSiteStrucManager(this.component);
    }

    public boolean isSpeculativeBuild() {
        SiteModelContainer smc = SiteCorePlugin.getDefault().getSiteModelManager().getModelContainerForTemp(this.component);
        return smc != null && smc.isDirty();
    }

    public void clean() {
        this.getGlobalContext().clearCache(this.getComponent().getProject());
        this.getGlobalContext().getCacheMgr().clearSiteStrucManager(this.getComponent());
    }

    public void dispose() {
        for (IVirtualComponent component : this.component2modelContainer.keySet()) {
            SiteModelContainer smc = (SiteModelContainer)this.component2modelContainer.get(component);
            if (smc == null) continue;
            smc.release();
        }
    }

    public Set getAllFilesInSite() {
        if (this.allFilesInSite == null) {
            Set result;
            long ts = this.getSiteModificationStamp(this.component);
            if (ts != -1L && (result = this.globalContext.getAllFilesInSiteCache(this.component, ts)) != null) {
                this.allFilesInSite = result;
                return result;
            }
            result = new HashSet();
            SiteModel model = this.getSiteModel(this.getComponent());
            if (model != null) {
                model.accept(new SiteComponentVisitor((HashSet)result){
                    private final /* synthetic */ HashSet val$result;
                    {
                        this.val$result = hashSet;
                    }

                    @Override
                    public boolean visit(SiteComponent component) {
                        if (component.getType() == SiteComponentType.PAGE) {
                            this.val$result.add(((PageModel)component).getSRC());
                        }
                        return true;
                    }
                });
            }
            this.allFilesInSite = Collections.unmodifiableSet(result);
            if (ts != -1L) {
                this.globalContext.putAllFilesInSiteCache(this.component, ts, this.allFilesInSite);
            }
        }
        return this.allFilesInSite;
    }

    public void addReadonlyFile(IFile file) {
        if (!this.readOnlyFiles.contains(file)) {
            this.readOnlyFiles.add(file);
        }
    }

    public void removeReadonlyFile(IFile file) {
        this.readOnlyFiles.remove(file);
    }

    public Collection getReadOnlyFiles() {
        return this.readOnlyFiles;
    }

    public boolean isSiteXmlUpdated() throws CoreException {
        if (this.siteStructureUpdated == null) {
            boolean result = false;
            if (this.getSiteStrucMgr().isUpdated(this.getRelatedComponents())) {
                result = true;
                this.getSiteStrucMgr().update(this.getRelatedComponents());
            }
            this.siteStructureUpdated = result ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.siteStructureUpdated;
    }

    public Collection getRelatedComponents() {
        if (this.relatedComponents == null) {
            this.relatedComponents = BuildContext.createRelatedComponentSet(this.getComponent());
        }
        return this.relatedComponents;
    }

    private static Collection createRelatedComponentSet(IVirtualComponent aComponent) {
        ArrayList<IVirtualComponent> componentList = new ArrayList<IVirtualComponent>();
        componentList.add(aComponent);
        int index = 0;
        while (index < componentList.size()) {
            IVirtualComponent component = (IVirtualComponent)componentList.get(index);
            IVirtualComponent[] reffered = SiteSubProjectUtil2.getReferencedComponents(component);
            IVirtualComponent[] reffers = component.getReferencingComponents();
            IVirtualComponent[] related = new IVirtualComponent[reffered.length + reffers.length];
            System.arraycopy(reffered, 0, related, 0, reffered.length);
            System.arraycopy(reffers, 0, related, reffered.length, reffers.length);
            int i = 0;
            while (i < related.length) {
                IVirtualComponent newComponent = related[i];
                if (!componentList.contains(newComponent) && WebComponentUtil.hasWebSiteFeature(newComponent)) {
                    componentList.add(newComponent);
                }
                ++i;
            }
            ++index;
        }
        return new VirtualComponentSet(componentList);
    }

    public void waitForWritingFile() {
        if (!this.needWaitForFs) {
            return;
        }
        this.needWaitForFs = false;
        long fsTime = this.getFileSystemTime();
        long dstTime = System.currentTimeMillis() + 10L;
        while (System.currentTimeMillis() < dstTime) {
        }
        int i = 0;
        while (i < 10) {
            if (fsTime != this.getFileSystemTime()) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
    }

    private long getFileSystemTime() {
        try {
            File tmpFile = new Path(String.valueOf(SiteCorePlugin.getDefault().getStateLocation().toString()) + File.separator + "_fileSystemTrick").toFile();
            tmpFile.createNewFile();
            long result = tmpFile.lastModified();
            tmpFile.delete();
            return result;
        }
        catch (IOException e) {
            Logger.log(e);
            return 0L;
        }
    }

    public boolean needWaitForWritingFile() {
        return this.needWaitForFs;
    }
}

