/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.site.handler;

import com.ibm.etools.siteedit.internal.builder.common.StringUtil;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeLinkUtil;
import com.ibm.etools.siteedit.internal.builder.model.NavElement;
import com.ibm.etools.siteedit.internal.builder.model.NavTagHandler;
import com.ibm.etools.siteedit.internal.builder.model.SitePageContext;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecModel;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecProvider;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageAttrImpl;
import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.SiteNavMaker;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteId;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNav;
import com.ibm.etools.siteedit.internal.builder.site.handler.GSModelHandler;
import com.ibm.etools.siteedit.sitetags.model.NavModel;
import com.ibm.etools.siteedit.sitetags.model.SiteTagModelFactory;
import java.util.Map;
import org.eclipse.core.resources.IFile;

public class NavbarTagHandler
extends NavTagHandler {
    public static String PAGEDATA_ID_BEAN = "id";
    private final NavspecProvider navspecProvider;

    NavbarTagHandler(NavspecProvider navspecProvider, GSModelHandler gsModelHandler) {
        super(gsModelHandler);
        this.navspecProvider = navspecProvider;
    }

    @Override
    public String getResult(NavElement node, SitePageContext context) {
        IFile currentFile = context.getContextFile();
        GSPage gsPage = this.gsModelHandler.getGSPage(currentFile);
        NavModel navModel = (NavModel)SiteTagModelFactory.createModel(node);
        IFile navspecFile = TagNodeLinkUtil.getFileOfAttr(currentFile, node, "spec", null);
        PageAttrImpl attrs = new PageAttrImpl();
        SiteNav bean = SiteNavMaker.createNav(this.gsModelHandler.getGSStructure(), gsPage, navModel, context.isTemplate());
        if (NavbarTagHandler.isEmptyObject(bean.getItems())) {
            return "";
        }
        attrs.set("sitenav", bean);
        Object idBean = context.getPageData().get(PAGEDATA_ID_BEAN);
        if (idBean == null) {
            idBean = new SiteId();
            context.getPageData().put(PAGEDATA_ID_BEAN, idBean);
        }
        attrs.set("siteid", idBean);
        NavspecModel navspecModel = this.navspecProvider.getNavspec(navspecFile, context.getDeclaration(), context.getPublicId());
        if (navspecModel == null) {
            return null;
        }
        String result = navspecModel.eval(attrs, this.creaetTaglibPrefixResolver(context));
        return "\n" + StringUtil.removeEmptyLine(result);
    }

    private NavspecModel.TaglibPrefixResolver creaetTaglibPrefixResolver(final SitePageContext context) {
        return new NavspecModel.TaglibPrefixResolver(){
            private Map map;
            private boolean isAttempted;

            @Override
            public String getPrefix(String uri) {
                if (!this.isAttempted) {
                    this.isAttempted = true;
                    this.map = context.getTaglibMappings();
                }
                return this.map == null ? null : (String)this.map.get(uri);
            }
        };
    }
}

