/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.site;

import com.ibm.etools.siteedit.internal.builder.site.GSPage;
import com.ibm.etools.siteedit.internal.builder.site.GSUnmappedPage;
import com.ibm.etools.siteedit.internal.builder.site.bean.SiteNavItem;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.LinkModel;
import com.ibm.etools.siteedit.site.model.NavItemSiteComponent;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.webedit.links.util.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SiteNavItemImpl
implements SiteNavItem {
    private final String src;
    private final String title;
    private boolean fSelf;
    private final boolean fGroup;
    private final int depth;
    private boolean fAncestor;
    private String nextLabel;
    private int baseDepth;
    private final GSPage gmodel;

    public SiteNavItemImpl(GSPage gmodel, GSPage gself, int depth) {
        this.gmodel = gmodel;
        this.fSelf = false;
        SiteComponent model = this.findSiteComponent(gmodel, gself);
        this.src = SiteNavItemImpl.getHrefProperty(gmodel.getComponent(), model);
        this.title = ((NavItemSiteComponent)model).getTitle();
        this.depth = depth;
        this.fGroup = model.getType() == SiteComponentType.GROUP;
    }

    private SiteComponent findSiteComponent(GSPage gmodel, GSPage gself) {
        SiteComponent model = gmodel.getSiteComponent();
        if (!(gself instanceof GSUnmappedPage)) {
            PageModel self = (PageModel)gself.getSiteComponent();
            this.fSelf = self == model;
        }
        return model;
    }

    @Override
    public String getHref() {
        return this.src;
    }

    @Override
    public String getLabel() {
        return this.nextLabel == null ? this.title : this.nextLabel;
    }

    @Override
    public boolean isSelf() {
        return this.fSelf;
    }

    @Override
    public boolean isGroup() {
        return this.fGroup;
    }

    @Override
    public boolean isAncestor() {
        return this.fAncestor;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getLevel() {
        return this.depth - this.baseDepth >= 0 ? this.depth - this.baseDepth : 0;
    }

    public void overrideAncestor(boolean f) {
        this.fAncestor = f;
    }

    public void overrideLabel(String s) {
        this.nextLabel = s;
    }

    public void overrideBaseDepth(int baseDepth) {
        this.baseDepth = baseDepth;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SiteNavItemImpl)) {
            return false;
        }
        SiteNavItemImpl o = (SiteNavItemImpl)other;
        return (this.title == null ? o.title == null : this.src.equals(o.title)) && (this.src == null ? o.src == null : this.src.equals(o.src)) && this.fSelf == o.fSelf && this.depth == o.depth;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 37 * result + (this.src == null ? 0 : this.src.hashCode());
        result = 37 * result + (!this.fSelf ? 0 : 1);
        result = 37 * result + this.depth;
        return result;
    }

    private static String getHrefProperty(IVirtualComponent component, SiteComponent siteComponent) {
        if (siteComponent == null) {
            return null;
        }
        if (siteComponent.getType() == SiteComponentType.PAGE) {
            PageModel page = (PageModel)siteComponent;
            String servletUrl = page.getServletUrl();
            if (servletUrl != null && servletUrl.length() > 0) {
                return servletUrl;
            }
            return SiteNavItemImpl.getDocRootRelative(component, page.getSRC());
        }
        if (siteComponent.getType() == SiteComponentType.LINK) {
            return ((LinkModel)siteComponent).getSRC();
        }
        if (siteComponent.getType() == SiteComponentType.SHAREDPAGE) {
            return SiteNavItemImpl.getHrefProperty(component, ((SharedPageModel)siteComponent).getTargetPage());
        }
        return null;
    }

    private static String getDocRootRelative(IVirtualComponent component, String src) {
        IFile file = SiteResourceUtil.fileForProjectRelative(component, src);
        if (file != null) {
            String contextRoot = WebComponentUtil.getServerContextRoot(component);
            String docRoot = WebComponentUtil.getRootPublishableFolder(component).getLocation().toString();
            String result = SiteNavItemImpl.makeDocRootRelative(component.getProject(), null, file.getLocation().toString(), docRoot, contextRoot, "A", "href", null);
            if (result != null && result.length() > 0) {
                return result;
            }
        }
        return "#";
    }

    public static String makeDocRootRelative(IProject project, String sourceLocation, String absoluteLink, String docRoot, String serverContextRoot, String tagname, String attributeName, String taglibURI) {
        String protocol = URI.getOnlyScheme((String)absoluteLink).toLowerCase();
        if (!"".equals(protocol) && !"file".equals(protocol)) {
            return null;
        }
        if (absoluteLink == null || absoluteLink.length() == 0) {
            if (absoluteLink != null) {
                return absoluteLink;
            }
            return "";
        }
        Path filePath = null;
        filePath = new Path(absoluteLink);
        IPath docRootPath = new Path(docRoot).makeRelative();
        int docRootSegments = docRootPath.matchingFirstSegments((IPath)filePath);
        if (docRootSegments == docRootPath.segmentCount()) {
            filePath = filePath.removeFirstSegments(docRootSegments);
            if (serverContextRoot != null && serverContextRoot.length() > 0) {
                Path serverContextRootIPath = new Path(serverContextRoot);
                IPath webAppPath = serverContextRootIPath.makeAbsolute();
                filePath = filePath.setDevice(null);
                filePath = webAppPath.append((IPath)filePath);
            }
            return filePath.setDevice(null).makeAbsolute().toString();
        }
        return null;
    }

    @Override
    public int getBaseDepth() {
        return this.baseDepth;
    }

    GSPage getGSPage() {
        return this.gmodel;
    }
}

