/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.site;

import com.ibm.etools.siteedit.internal.builder.site.GSItem;
import com.ibm.etools.siteedit.internal.builder.site.GSStructure;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import java.util.ArrayList;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class GSPage
implements GSItem {
    protected GSPage[] parent;
    protected GSPage[] child;
    protected SiteComponent siteComponent;
    protected GSStructure struc;
    protected IVirtualComponent component;

    public GSPage(SiteComponent siteComponent, IVirtualComponent component, GSStructure struc) {
        this.siteComponent = siteComponent;
        this.component = component;
        this.struc = struc;
    }

    public GSPage getParent() {
        if (this.parent == null) {
            this.parent = new GSPage[]{this.struc.getParentThroughProject(this)};
        }
        return this.parent[0];
    }

    public GSPage[] getChildren() {
        if (this.child == null) {
            this.child = this.struc.getChildThroughProject(this);
        }
        return this.child;
    }

    public GSPage[] getSibling() {
        GSPage p = this.getParent();
        if (p != null) {
            return p.getChildren();
        }
        return new GSPage[]{this};
    }

    public GSPage[] getTopChildren() {
        return this.getTop().getChildren();
    }

    public GSPage[] getAncestor() {
        GSPage parent = this.getParent();
        ArrayList<GSPage> ancestors = new ArrayList<GSPage>();
        while (parent != null) {
            ancestors.add(parent);
            parent = parent.getParent();
        }
        int ancestorSize = ancestors.size();
        if (ancestorSize == 0) {
            return null;
        }
        return ancestors.toArray(new GSPage[ancestorSize]);
    }

    public GSPage getFirstChild() {
        GSPage[] c = this.getChildren();
        int i = 0;
        while (i < c.length) {
            if (GSStructure.ST.hasDepth(c[i].getSiteComponent())) {
                return c[i];
            }
            ++i;
        }
        return null;
    }

    public GSPage getFirstChildNavItem() {
        GSPage[] c = this.getChildren();
        int i = 0;
        while (i < c.length) {
            if (GSStructure.ST.isNavItem(c[i].getSiteComponent())) {
                return c[i];
            }
            ++i;
        }
        return null;
    }

    public GSPage getNextSiblingNavItem() {
        GSPage[] c = this.getSibling();
        int i = 0;
        while (i < c.length) {
            if (c[i].equals(this)) {
                int j = i + 1;
                while (j < c.length) {
                    if (GSStructure.ST.isNavItem(c[j].getSiteComponent())) {
                        return c[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IVirtualComponent getComponent() {
        return this.component;
    }

    @Override
    public SiteComponent getSiteComponent() {
        return this.siteComponent;
    }

    public String toString() {
        return "GSP(" + this.siteComponent.toString() + ")";
    }

    public GSPage getTop() {
        return this.getRoot(false);
    }

    public GSPage getNavRoot() {
        return this.getRoot(true);
    }

    private GSPage getRoot(boolean isNavRoot) {
        if (isNavRoot && this.getSiteComponent().getType() == SiteComponentType.PAGE && ((PageModel)this.getSiteComponent()).getNavroot()) {
            return this;
        }
        GSPage p = this.getParent();
        if (p == null) {
            return this;
        }
        return p.getRoot(isNavRoot);
    }
}

