/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.tag;

import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.navspec.Tag;
import com.ibm.etools.siteedit.internal.builder.navspec.TagFactory;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreChooseTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreForEachTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreIfTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreOtherwiseTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreOutTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreRemoveTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreSetTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreWhenTag;
import java.util.HashMap;

public class MyTagFactory
implements TagFactory {
    private static HashMap tagFactoryMap;

    @Override
    public boolean canHandle(String tagName) {
        MyTagFactory.initFactory();
        return tagFactoryMap.keySet().contains(tagName);
    }

    @Override
    public Tag getTag(TagNode targetTagNode) {
        MyTagFactory.initFactory();
        TagCreater c = (TagCreater)tagFactoryMap.get(targetTagNode.getTagName());
        if (c != null) {
            return c.create(targetTagNode);
        }
        return null;
    }

    private static void initFactory() {
        if (tagFactoryMap != null) {
            return;
        }
        tagFactoryMap = new HashMap();
        tagFactoryMap.put("siteedit:out", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreOutTag(element);
            }
        });
        tagFactoryMap.put("siteedit:set", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreSetTag(element);
            }
        });
        tagFactoryMap.put("siteedit:if", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreIfTag(element);
            }
        });
        tagFactoryMap.put("siteedit:choose", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreChooseTag();
            }
        });
        tagFactoryMap.put("siteedit:when", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreWhenTag(element);
            }
        });
        tagFactoryMap.put("siteedit:otherwise", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreOtherwiseTag();
            }
        });
        tagFactoryMap.put("siteedit:forEach", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreForEachTag(element);
            }
        });
        tagFactoryMap.put("siteedit:remove", new TagCreater(){

            @Override
            public Tag create(TagNode element) {
                return new CoreRemoveTag(element);
            }
        });
    }

    private static interface TagCreater {
        public Tag create(TagNode var1);
    }
}

