/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.tag;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.impl.ErrorTool;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.navspec.Context;
import com.ibm.etools.siteedit.internal.builder.navspec.PageWriter;
import com.ibm.etools.siteedit.internal.builder.navspec.Tag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreChooseTag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreEL;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreErrorTool;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.VariableResolverUtil;

public class CoreWhenTag
implements Tag {
    private TagNode element;
    private CoreEL testExp;
    private PageWriter origPageWriter;

    public CoreWhenTag(TagNode element) {
        this.element = element;
        if (!element.containsAttr("test")) {
            CoreErrorTool.reportNoAttr(element.getErrorReporter(), element.getTagName(), "test");
            this.testExp = CoreEL.getNullEL();
        } else {
            String s = element.getAttr("test");
            this.testExp = new CoreEL(s, element.getErrorReporterForAttr("test"));
        }
    }

    @Override
    public int doStartTag(Context context) {
        Tag t = context.getParent();
        if (t instanceof CoreChooseTag) {
            CoreChooseTag ct = (CoreChooseTag)t;
            this.origPageWriter = context.getPageWriter();
            context.setPageWriter(ct.getOriginalWriter());
            if (ct.isHandled()) {
                return 1;
            }
            try {
                Object o = this.testExp.evaluate(VariableResolverUtil.getResolver(context.getPageAttr()));
                Boolean f = CoreEL.toBoolean(o);
                if (f != null && f.booleanValue()) {
                    ct.checkHandled();
                    return 0;
                }
            }
            catch (ELErrorException e) {
                ErrorTool.reportELRuntimeError(this.element.getErrorReporterForAttr("test"), e);
            }
        }
        return 1;
    }

    @Override
    public int doEndTag(Context context) {
        Tag t = context.getParent();
        if (t instanceof CoreChooseTag) {
            context.setPageWriter(this.origPageWriter);
        }
        return 2;
    }

    @Override
    public void doInitBody(Context context) {
    }

    @Override
    public int doAfterBody(Context context) {
        return 2;
    }
}

