/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.tag;

import com.ibm.etools.siteedit.core.internal.el.ELErrorException;
import com.ibm.etools.siteedit.core.internal.el.VariableResolver;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.navspec.Context;
import com.ibm.etools.siteedit.internal.builder.navspec.LoopTagStatus;
import com.ibm.etools.siteedit.internal.builder.navspec.PageAttr;
import com.ibm.etools.siteedit.internal.builder.navspec.Tag;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreEL;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.CoreErrorTool;
import com.ibm.etools.siteedit.internal.builder.navspec.tag.VariableResolverUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class CoreForEachTag
implements Tag {
    private CoreEL itemsExp;
    private CoreEL beginExp;
    private CoreEL endExp;
    private CoreEL stepExp;
    private boolean hasItems;
    private String varName;
    private String varStatusName;
    private boolean hasOldVar;
    private Object objOldVar;
    private boolean hasOldVarStatus;
    private Object objOldVarStatus;
    private LoopTagStatusImpl status;

    public CoreForEachTag(TagNode element) {
        String s;
        if (element.containsAttr("items")) {
            this.hasItems = true;
        }
        this.varName = element.getAttr("var");
        this.varStatusName = element.getAttr("varStatus");
        if (this.hasItems) {
            s = element.getAttr("items");
            this.itemsExp = new CoreEL(s, element.getErrorReporterForAttr("items"));
        }
        if (element.containsAttr("begin")) {
            s = element.getAttr("begin");
            this.beginExp = new CoreEL(s, element.getErrorReporterForAttr("begin"));
        }
        if (element.containsAttr("end")) {
            s = element.getAttr("end");
            this.endExp = new CoreEL(s, element.getErrorReporterForAttr("end"));
        }
        if (element.containsAttr("step")) {
            s = element.getAttr("step");
            this.stepExp = new CoreEL(s, element.getErrorReporterForAttr("step"));
        }
        if (!this.hasItems && !element.containsAttr("end")) {
            CoreErrorTool.reportNoAttr(element.getErrorReporter(), element.getTagName(), "items");
        }
    }

    @Override
    public int doStartTag(Context context) {
        this.status = null;
        this.saveOldStatusVariables(context.getPageAttr());
        Object[] items = null;
        VariableResolver valR = VariableResolverUtil.getResolver(context.getPageAttr());
        if (this.hasItems) {
            Object o = this.itemsExp.evaluate(valR);
            items = this.getItemsFromObject(o);
        }
        Integer beginAttr = this.getAttrAsInteger(this.beginExp, valR);
        Integer endAttr = this.getAttrAsInteger(this.endExp, valR);
        Integer stepAttr = this.getAttrAsInteger(this.stepExp, valR);
        this.status = new LoopTagStatusImpl(items, beginAttr, endAttr, stepAttr);
        if (this.status.hasNext()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int doEndTag(Context context) {
        this.restoreOldStatusVariables(context.getPageAttr());
        return 2;
    }

    @Override
    public void doInitBody(Context context) {
        this.status.next();
        if (this.varName != null) {
            context.getPageAttr().set(this.varName, this.status.getCurrent());
        }
        if (this.varStatusName != null) {
            context.getPageAttr().set(this.varStatusName, this.status);
        }
    }

    @Override
    public int doAfterBody(Context context) {
        if (this.status.hasNext()) {
            return 0;
        }
        return 2;
    }

    private Integer getAttrAsInteger(CoreEL exp, VariableResolver valR) {
        String s;
        block5: {
            if (exp == null) {
                return null;
            }
            s = CoreEL.toString(exp.evaluate(valR));
            if (s != null && !s.equals("")) break block5;
            return null;
        }
        try {
            return Integer.decode(s);
        }
        catch (ELErrorException eLErrorException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    private Object[] getItemsFromObject(Object o) {
        if (o != null) {
            if (o.getClass().isArray()) {
                return this.getItemsFromArray(o);
            }
            if (o instanceof Collection) {
                return this.getItemsFromCollection((Collection)o);
            }
            if (o instanceof Iterator) {
                return this.getItemsFromIterator((Iterator)o);
            }
            if (o instanceof Enumeration) {
                return this.getItemsFromEnumeration((Enumeration)o);
            }
            if (o instanceof Map) {
                return this.getItemsFromCollection(((Map)o).entrySet());
            }
            if (o instanceof String) {
                return this.getItemsFromEnumeration(new StringTokenizer((String)o, ","));
            }
        }
        return new Object[0];
    }

    private Object[] getItemsFromArray(Object o) {
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        if (o != null && o.getClass().isArray()) {
            Object[] r = new Object[Array.getLength(o)];
            int i = 0;
            while (i < r.length) {
                r[i] = Array.get(o, i);
                ++i;
            }
            return r;
        }
        return null;
    }

    private Object[] getItemsFromCollection(Collection o) {
        return o.toArray();
    }

    private Object[] getItemsFromIterator(Iterator it) {
        ArrayList ar = new ArrayList();
        while (it.hasNext()) {
            ar.add(it.next());
        }
        return this.getItemsFromCollection(ar);
    }

    private Object[] getItemsFromEnumeration(Enumeration enumer) {
        ArrayList ar = new ArrayList();
        while (enumer.hasMoreElements()) {
            ar.add(enumer.nextElement());
        }
        return this.getItemsFromCollection(ar);
    }

    private void saveOldStatusVariables(PageAttr pageAttr) {
        if (this.varName.length() > 0) {
            this.hasOldVar = pageAttr.exists(this.varName);
            if (this.hasOldVar) {
                this.objOldVar = pageAttr.get(this.varName);
            }
        }
        if (this.varStatusName.length() > 0) {
            this.hasOldVarStatus = pageAttr.exists(this.varStatusName);
            if (this.hasOldVarStatus) {
                this.objOldVarStatus = pageAttr.get(this.varStatusName);
            }
        }
    }

    private void restoreOldStatusVariables(PageAttr pageAttr) {
        if (this.varName.length() > 0) {
            if (this.hasOldVar) {
                pageAttr.remove(this.varName);
            } else {
                pageAttr.set(this.varName, this.objOldVar);
            }
        }
        if (this.varStatusName.length() > 0) {
            if (this.hasOldVarStatus) {
                pageAttr.remove(this.varStatusName);
            } else {
                pageAttr.set(this.varStatusName, this.objOldVarStatus);
            }
        }
    }

    public static class LoopTagStatusImpl
    implements LoopTagStatus {
        private Object[] items;
        private Integer beginAttr;
        private Integer endAttr;
        private Integer stepAttr;
        private int begin;
        private int end;
        private int step;
        private int index;

        protected LoopTagStatusImpl(Object[] items, Integer begin, Integer end, Integer step) {
            this.items = items;
            this.beginAttr = begin;
            this.endAttr = end;
            this.stepAttr = step;
            this.initDerivedData();
        }

        private void initDerivedData() {
            this.begin = 0;
            this.end = this.items != null ? this.items.length - 1 : (this.endAttr != null ? Integer.MAX_VALUE : -1);
            this.step = 1;
            if (this.beginAttr != null) {
                this.begin = Math.max(this.begin, this.beginAttr);
            }
            if (this.endAttr != null) {
                this.end = Math.min(this.end, this.endAttr);
            }
            if (this.stepAttr != null) {
                this.step = this.stepAttr;
                if (this.step < 1) {
                    this.step = 1;
                }
            }
            this.index = this.begin - this.step;
        }

        protected boolean hasNext() {
            return this.index + this.step <= this.end;
        }

        protected void next() {
            this.index += this.step;
        }

        @Override
        public Object getCurrent() {
            return this.items == null ? null : this.items[this.index];
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getCount() {
            return (this.end - this.begin + 1) / this.step;
        }

        @Override
        public boolean isFirst() {
            return this.index == this.begin;
        }

        @Override
        public boolean isLast() {
            return this.index == this.end;
        }

        @Override
        public Integer getBegin() {
            return this.beginAttr;
        }

        @Override
        public Integer getEnd() {
            return this.endAttr;
        }

        @Override
        public Integer getStep() {
            return this.stepAttr;
        }
    }
}

