/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.impl;

import com.ibm.etools.siteedit.core.internal.el.Expression;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporterTagNode;
import com.ibm.etools.siteedit.internal.builder.common.FlatModelDifference;
import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import com.ibm.etools.siteedit.internal.builder.common.TagNodeFactory;
import com.ibm.etools.siteedit.internal.builder.common.TagParser;
import com.ibm.etools.siteedit.internal.builder.navspec.TagFactory;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageInterpreter;
import com.ibm.etools.siteedit.internal.builder.navspec.impl.PageItem;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTaglibDirectiveReader;
import com.ibm.etools.siteedit.util.NavigationTagUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class PageParser {
    private TagFactory factory;
    private static NullErrorReporter NULL_REPORTER = new NullErrorReporter();

    public PageParser(TagFactory factory) {
        this.factory = factory;
    }

    public PageInterpreter parse(IStructuredDocument model, IFile orgFileName) {
        FlatModelData data = new FlatModelData(model, orgFileName);
        this.parseCore(data);
        return new PageInterpreter(data.getPageItems(), data.prefixToURI);
    }

    private void parseCore(FlatModelData data) {
        boolean fInBody = false;
        while (data.hasNext()) {
            IStructuredDocumentRegion node = data.next();
            String nodeType = node.getType();
            if (TagParser.isXMLJSPCommentType(nodeType)) {
                if (!fInBody) continue;
                this.putCommentNode(data);
                continue;
            }
            if ("XML_TAG_NAME" == nodeType) {
                boolean fCloseTag = false;
                String tagName = null;
                int posTagName = 0;
                ITextRegionList regions = node.getRegions();
                for (ITextRegion r : regions) {
                    String type = r.getType();
                    if ("XML_TAG_NAME" == type) {
                        tagName = node.getText(r);
                        posTagName = node.getStartOffset(r);
                        continue;
                    }
                    if ("XML_END_TAG_OPEN" != type && "XML_EMPTY_TAG_CLOSE" != type) continue;
                    fCloseTag = true;
                }
                if (tagName == null) continue;
                if (tagName.equalsIgnoreCase("BODY")) {
                    if (!fCloseTag) {
                        data.setTextFrom(node);
                        fInBody = true;
                        continue;
                    }
                    data.commitTextTo(node);
                    while (!data.stack.isEmpty()) {
                        StackItem si = data.stack.top();
                        data.putItem(PageItem.createEnd(si.item.getTag(), si.startIndex));
                        data.stack.pop();
                    }
                    fInBody = false;
                    continue;
                }
                if (!fInBody) continue;
                this.putTagname(tagName, posTagName, data);
                this.putAttributeNode(data);
                continue;
            }
            if ("XML_CONTENT" != nodeType || !fInBody) continue;
            this.putTextNode(data, node);
        }
    }

    private void putTextNode(FlatModelData data, IStructuredDocumentRegion node) {
        String value = node.getFullText();
        if (value.indexOf("${") == -1 || value.indexOf(125) == -1) {
            return;
        }
        data.commitTextTo(node);
        ErrorReporterTagNode er = data.getErrorReporter();
        Expression el = new Expression(value, true, er);
        data.putItem(PageItem.createEl(el, er));
        data.setTextFrom(node);
    }

    private void putTagname(String tagName, int posTagName, FlatModelData data) {
        int posColon = tagName.indexOf(58);
        if (posColon == -1) {
            return;
        }
        data.commitTextTo(posTagName);
        data.putItem(PageItem.createPrefix(tagName.substring(0, posColon)));
        data.setTextFrom(posTagName + posColon);
    }

    private void putAttributeNode(FlatModelData data) {
        IStructuredDocumentRegion currentRegion = data.getCurrentNode();
        ITextRegionList regions = currentRegion.getRegions();
        String tagName = null;
        String attrName = null;
        for (ITextRegion r : regions) {
            ErrorReporterTagNode ernode;
            String value;
            String type = r.getType();
            if ("XML_TAG_NAME" == type) {
                tagName = currentRegion.getText(r);
                continue;
            }
            if ("XML_TAG_ATTRIBUTE_NAME" == type) {
                attrName = currentRegion.getText(r);
                continue;
            }
            if ("XML_TAG_ATTRIBUTE_VALUE" != type || (value = currentRegion.getText(r)).indexOf("${") == -1 || value.indexOf(125) == -1) continue;
            boolean fQuote = StringUtils.isQuoted((String)value);
            if (fQuote) {
                value = StringUtils.strip((String)value);
            }
            data.commitTextTo(currentRegion.getStart() + r.getStart() + (fQuote ? 1 : 0));
            ErrorReporter er = NULL_REPORTER;
            if (tagName != null && tagName.indexOf(58) == -1 && (ernode = data.getErrorReporter()) != null) {
                er = ernode.getAttr(attrName);
            }
            Expression el = new Expression(value, true, er);
            data.putItem(PageItem.createEl(el, er));
            data.setTextFrom(currentRegion.getStart() + r.getTextEnd() - (fQuote ? 1 : 0));
        }
    }

    private void putCommentNode(FlatModelData data) {
        IStructuredDocumentRegion curNode = data.getCurrentNode();
        TagNode d = TagParser.parseXMLJSPComment(curNode, "siteedit:", data.getTaqNodeFactory());
        if (d != null) {
            d.setErrorReporter(data.getErrorReporter());
            data.commitTextTo(curNode);
            this.rawPutTag(data, d);
            data.setTextFrom(curNode);
        }
    }

    private void rawPutTag(FlatModelData data, TagNode d) {
        if (!this.factory.canHandle(d.getTagName())) {
            try {
                ErrorReporterTagNode er = data.getErrorReporter();
                if (er != null) {
                    er.reportError(2, "com.ibm.etools.siteedit.SiteNavBuilder.navspecmarker", SiteNavMessages.UNKNOWN_TAG, false);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return;
        }
        switch (d.getType()) {
            case 3: {
                data.putItem(PageItem.createEmpty(this.factory.getTag(d)));
                break;
            }
            case 1: {
                StackItem item = new StackItem();
                item.item = PageItem.createStart(this.factory.getTag(d));
                item.startIndex = data.getItemCount();
                item.tagName = d.getTagName();
                data.stack.push(item);
                data.putItem(item.item);
                break;
            }
            case 2: {
                StackItem openTag = data.stack.getByTagName(d.getTagName());
                if (openTag == null) break;
                StackItem target = null;
                do {
                    target = data.stack.top();
                    data.putItem(PageItem.createEnd(target.item.getTag(), target.startIndex));
                    data.stack.pop();
                } while (target != openTag);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private static class FlatModelData {
        public final IStructuredDocument model;
        private final IStructuredDocumentRegion[] nodes;
        public final Map prefixToURI;
        private final TagNodeFactory tagFactory;
        private int nodeIndex = -1;
        private final IFile orgFile;
        private final FlatModelDifference orgMatchData;
        public final Stack stack;
        private final ArrayList out;
        private int textIndex = -1;

        public FlatModelData(IStructuredDocument model, IFile orgFile) {
            this.model = model;
            this.nodes = model.getStructuredDocumentRegions();
            this.prefixToURI = SiteTaglibDirectiveReader.createPrefixToURIMap(model);
            this.tagFactory = TagNodeFactory.getDefFactory(orgFile);
            this.orgFile = orgFile;
            int specType = NavigationTagUtil.getInstance().getSpecType(orgFile);
            if (specType == 2) {
                this.orgMatchData = null;
            } else {
                IStructuredDocument sd = null;
                try {
                    IModelManager mm = SiteModelUtil.getModelManager();
                    sd = mm.createStructuredDocumentFor(orgFile);
                }
                catch (Exception e) {
                    SiteNavBuilderLogger.log(e);
                }
                this.orgMatchData = sd != null ? new FlatModelDifference(sd, model, orgFile) : null;
            }
            this.out = new ArrayList();
            this.stack = new Stack();
        }

        public boolean hasNext() {
            return this.nodeIndex + 1 < this.nodes.length;
        }

        public IStructuredDocumentRegion next() {
            return this.nodes[++this.nodeIndex];
        }

        public IStructuredDocumentRegion getCurrentNode() {
            return this.nodes[this.nodeIndex];
        }

        private IStructuredDocumentRegion getCorrespondedNode() {
            if (this.orgMatchData != null) {
                return this.orgMatchData.getSrcNode(this.getCurrentNode());
            }
            return null;
        }

        public TagNodeFactory getTaqNodeFactory() {
            return this.tagFactory;
        }

        public ErrorReporterTagNode getErrorReporter() {
            IStructuredDocumentRegion n = this.getCorrespondedNode();
            if (n == null) {
                return null;
            }
            return new ErrorReporterTagNode(this.orgFile, n);
        }

        public void putItem(PageItem item) {
            this.out.add(item);
        }

        public int getItemCount() {
            return this.out.size();
        }

        public PageItem[] getPageItems() {
            return this.out.toArray(new PageItem[this.out.size()]);
        }

        public void setTextFrom(int pos) {
            this.textIndex = pos;
        }

        public void setTextFrom(IStructuredDocumentRegion node) {
            this.textIndex = node.getEnd();
        }

        public void commitTextTo(int pos) {
            if (this.textIndex < 0) {
                throw new RuntimeException();
            }
            try {
                String toPut = this.model.get(this.textIndex, pos - this.textIndex);
                if (toPut.length() > 0) {
                    this.out.add(PageItem.createText(toPut));
                }
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException();
            }
        }

        public void commitTextTo(IStructuredDocumentRegion node) {
            this.commitTextTo(node.getStart());
        }

        public void putTextItem(String text) {
            this.out.add(PageItem.createText(text));
        }
    }

    private static class NullErrorReporter
    implements ErrorReporter {
        private NullErrorReporter() {
        }

        @Override
        public void reportError(int sev, String type, String msg, boolean isMulti) {
        }

        @Override
        public long reportError(int sev, String type, String msg) {
            return 0L;
        }

        @Override
        public ErrorReporter getPart(int startPosition, int length) {
            return null;
        }

        @Override
        public boolean setAttribute(String attributeName, String attributeValue, long markerID) {
            return false;
        }

        @Override
        public boolean setAttribute(String attributeName, int attributeValueI, long markerID) {
            return false;
        }
    }

    private static class Stack {
        private LinkedList data = new LinkedList();

        private Stack() {
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public StackItem top() {
            return (StackItem)this.data.getFirst();
        }

        public void pop() {
            this.data.removeFirst();
        }

        public void push(StackItem item) {
            this.data.addFirst(item);
        }

        public StackItem getByTagName(String name) {
            for (StackItem item : this.data) {
                if (!item.tagName.equalsIgnoreCase(name)) continue;
                return item;
            }
            return null;
        }
    }

    private static class StackItem {
        public PageItem item;
        public int startIndex;
        public String tagName;

        private StackItem() {
        }
    }
}

