/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec.impl;

import com.ibm.etools.siteedit.core.internal.el.Expression;
import com.ibm.etools.siteedit.internal.builder.common.ErrorReporter;
import com.ibm.etools.siteedit.internal.builder.navspec.Tag;

public final class PageItem {
    public static final int TYPE_START = 1;
    public static final int TYPE_END = 2;
    public static final int TYPE_EMPTY = 3;
    public static final int TYPE_TEXT = 4;
    public static final int TYPE_EL = 5;
    public static final int TYPE_PREFIX = 6;
    private final int type;
    private final ErrorReporter er;
    private Tag tag;
    private String text;
    private int startPos = -1;
    private Expression el;

    public static PageItem createText(String text) {
        PageItem result = new PageItem(4, null);
        result.text = text;
        return result;
    }

    public static PageItem createStart(Tag tag) {
        PageItem result = new PageItem(1, null);
        result.tag = tag;
        return result;
    }

    public static PageItem createEmpty(Tag tag) {
        PageItem result = new PageItem(3, null);
        result.tag = tag;
        return result;
    }

    public static PageItem createEnd(Tag tag, int startIndex) {
        PageItem result = new PageItem(2, null);
        result.tag = tag;
        result.startPos = startIndex;
        return result;
    }

    public static PageItem createEl(Expression el, ErrorReporter er) {
        PageItem result = new PageItem(5, er);
        result.el = el;
        return result;
    }

    public static PageItem createPrefix(String originPrefix) {
        PageItem result = new PageItem(6, null);
        result.text = originPrefix;
        return result;
    }

    private PageItem(int type, ErrorReporter er) {
        this.type = type;
        this.er = er;
    }

    public int getType() {
        return this.type;
    }

    public ErrorReporter getErrorReporter() {
        return this.er;
    }

    public String getText() {
        return this.text;
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getStartPosition() {
        return this.startPos;
    }

    public Expression getEl() {
        return this.el;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "[Start tag: " + this.tag.getClass().toString() + "]";
            }
            case 2: {
                return "[End tag: " + this.tag.getClass().toString() + "]";
            }
            case 3: {
                return "[Empty tag: " + this.tag.getClass().toString() + "]";
            }
            case 5: {
                return "[EL: " + this.el.toString() + "]";
            }
            case 4: {
                return "[TEXT: " + this.text + "]";
            }
            case 6: {
                return "[PREFIX: " + this.text + "]";
            }
        }
        return "[Unknown type]";
    }
}

