/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.navspec;

import com.ibm.etools.siteedit.internal.builder.navspec.NavspecModel;
import com.ibm.etools.siteedit.internal.builder.navspec.NavspecModelFactoryImpl;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class NavspecProvider {
    static QualifiedName qname = new QualifiedName("com.ibm.etools.siteedit", "NavspecProvider");
    static final WeakHashMap objectCounter = new WeakHashMap();

    public NavspecModel getNavspec(IFile file, String declaration, String publicId) {
        if (file == null || !file.exists()) {
            return null;
        }
        NavspecCacheData data = this.getNavspecCacheData(file);
        NavspecModel result = data.get(declaration, publicId);
        if (result == null) {
            result = NavspecModelFactoryImpl.create(file, declaration, publicId);
            data.put(declaration, publicId, result);
        }
        return result;
    }

    private NavspecCacheData getNavspecCacheData(IFile file) {
        NavspecCacheData data = null;
        try {
            data = (NavspecCacheData)file.getSessionProperty(qname);
            if (file.getModificationStamp() == -1L) {
                if (data != null) {
                    data = null;
                    file.setSessionProperty(qname, (Object)data);
                }
            } else if (data == null || file.getModificationStamp() != data.modificationStamp) {
                data = new NavspecCacheData(file);
                file.setSessionProperty(qname, (Object)data);
            }
        }
        catch (CoreException coreException) {}
        return data;
    }

    public void clear(IProject project) {
        try {
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && proxy.getSessionProperty(qname) != null) {
                        proxy.requestResource().setSessionProperty(qname, null);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
    }

    public void clear() {
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int sizeOfProjects = projects.length;
            int index = 0;
            while (index < sizeOfProjects) {
                IProject project = projects[index];
                project.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1 && proxy.getSessionProperty(qname) != null) {
                            proxy.requestResource().setSessionProperty(qname, null);
                        }
                        return true;
                    }
                }, 0);
                ++index;
            }
        }
        catch (CoreException coreException) {}
    }

    public int getSize() {
        return objectCounter.size();
    }

    private static class NavspecCacheData {
        final long modificationStamp;
        private final HashMap map = new HashMap(1);

        public NavspecCacheData(IFile file) {
            this.modificationStamp = file.getModificationStamp();
        }

        NavspecModel get(String declaration, String publicId) {
            return (NavspecModel)this.map.get(NavspecCacheData.getKey(declaration, publicId));
        }

        void put(String declaration, String publicId, NavspecModel model) {
            this.map.put(NavspecCacheData.getKey(declaration, publicId), model);
            objectCounter.put(model, qname);
        }

        private static Object getKey(String declaration, String publicId) {
            return declaration + "##" + publicId;
        }
    }
}

